/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSRefactoringDescriptionLocation;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.util.JSMemberUsageInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSRefactoringConflictsUtil {
    public static void analyzeModuleConflicts(Project project, Collection<? extends PsiElement> scope2, UsageInfo[] usages, PsiElement target, MultiMap<PsiElement, String> conflicts) {
        if (scope2 == null) {
            return;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)target);
        if (vFile == null) {
            return;
        }
        JSRefactoringConflictsUtil.analyzeModuleConflicts(project, scope2, usages, vFile, conflicts);
    }

    private static void analyzeModuleConflicts(Project project, final Collection<? extends PsiElement> scopes, UsageInfo[] usages, VirtualFile vFile, final MultiMap<PsiElement, String> conflicts) {
        if (scopes == null) {
            return;
        }
        final Module targetModule = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)project);
        if (targetModule == null) {
            return;
        }
        final GlobalSearchScope resolveScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)targetModule);
        final HashSet reported = new HashSet();
        for (PsiElement psiElement : scopes) {
            psiElement.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

                public void visitJSReferenceExpression(@NotNull JSReferenceExpression reference) {
                    if (reference == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitJSReferenceExpression(reference);
                    PsiElement resolved = reference.resolve();
                    if (!(resolved == null || reported.contains(resolved) || CommonRefactoringUtil.isAncestor((PsiElement)resolved, (Collection)scopes) || JSResolveUtil.isFromPredefinedFile((PsiFile)resolved.getContainingFile()) || PsiSearchScopeUtil.isInScope((GlobalSearchScope)resolveScope, (PsiElement)resolved))) {
                        String scopeDescription = RefactoringUIUtil.getDescription((PsiElement)JSRefactoringConflictsUtil.getUsageLocation((PsiElement)reference), (boolean)true);
                        String message = RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.in.module.2", (Object[])new Object[]{StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)resolved, (boolean)true)), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)targetModule.getName())});
                        conflicts.putValue((Object)resolved, (Object)message);
                        reported.add(resolved);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/refactoring/util/JSRefactoringConflictsUtil$1", "visitJSReferenceExpression"));
                }
            });
        }
        boolean isInTestSources = ModuleRootManager.getInstance((Module)targetModule).getFileIndex().isInTestSourceContent(vFile) || TestSourcesFilter.isTestSources((VirtualFile)vFile, (Project)project);
        block1: for (UsageInfo usage : usages) {
            Module module;
            PsiFile container;
            if (!(usage instanceof MoveRenameUsageInfo)) continue;
            MoveRenameUsageInfo moveRenameUsageInfo = (MoveRenameUsageInfo)usage;
            PsiElement element2 = usage.getElement();
            if (element2 == null || PsiTreeUtil.getParentOfType((PsiElement)element2, JSImportStatement.class, (boolean)false) != null) continue;
            for (PsiElement psiElement : scopes) {
                if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element2, (boolean)false)) continue;
                continue block1;
            }
            GlobalSearchScope resolveScope1 = element2.getResolveScope();
            if (resolveScope1.isSearchInModuleContent(targetModule, isInTestSources)) continue;
            PsiFile psiFile = element2.getContainingFile();
            if (psiFile instanceof JSFile) {
                container = JSRefactoringConflictsUtil.getContainerMember(element2);
                if (container == null) {
                    container = psiFile;
                }
            } else {
                container = psiFile;
            }
            String scopeDescription = RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true);
            VirtualFile usageVFile = psiFile.getVirtualFile();
            if (usageVFile == null || (module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(usageVFile)) == null) continue;
            PsiElement referencedElement = moveRenameUsageInfo.getReferencedElement();
            String message = module == targetModule && isInTestSources ? RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.from.production.of.module.2", (Object[])new Object[]{StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)referencedElement, (boolean)true)), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)module.getName())}) : RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.from.module.2", (Object[])new Object[]{StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)referencedElement, (boolean)true)), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)module.getName())});
            conflicts.putValue((Object)referencedElement, (Object)message);
        }
    }

    @Nullable
    private static PsiElement getContainerMember(PsiElement place) {
        PsiElement parent = place;
        while (!JSUtils.isMember((PsiElement)parent)) {
            if (parent instanceof PsiFile) {
                return null;
            }
            parent = parent.getParent();
        }
        return parent;
    }

    public static void checkIncomingReferencesAccessibility(UsageInfo[] usages, JSClass targetClass, @Nullable String newVisibility, MultiMap<PsiElement, String> conflicts, @NotNull JSVisibilityUtil.Options options) {
        if (options == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(0);
        }
        for (UsageInfo usage : usages) {
            if (!(usage instanceof JSMemberUsageInfo)) continue;
            JSMemberUsageInfo usageInfo = (JSMemberUsageInfo)usage;
            PsiElement element2 = usage.getElement();
            if (!(element2 instanceof JSReferenceExpression)) continue;
            JSRefactoringConflictsUtil.checkAccessibility(usageInfo.member, targetClass, newVisibility, element2, conflicts, false, options);
        }
    }

    public static void checkAccessibility(JSAttributeListOwner member, @Nullable JSClass targetClass, @Nullable String newVisibility, PsiElement usage, MultiMap<PsiElement, String> conflicts, boolean showTargetClass, @NotNull JSVisibilityUtil.Options options) {
        JSAttributeList.AccessType accessType;
        boolean accessible;
        if (options == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(1);
        }
        if (newVisibility == null) {
            accessible = JSVisibilityUtil.isAccessible((PsiElement)member, (JSAttributeList)null, (JSClass)targetClass, (PsiElement)usage, (JSVisibilityUtil.Options)options);
            accessType = member.getAttributeList().getAccessType();
        } else {
            accessType = "escalate".equals(newVisibility) ? JSAttributeList.AccessType.PUBLIC : JSAttributeList.AccessType.valueOf((String)newVisibility);
            accessible = JSVisibilityUtil.isAccessible((PsiElement)member, (JSAttributeList.AccessType)accessType, (JSClass)targetClass, (PsiElement)usage, (JSVisibilityUtil.Options)options);
        }
        if (!accessible) {
            if (accessType == JSAttributeList.AccessType.PUBLIC) {
                String message = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{ElementDescriptionUtil.getElementDescription((PsiElement)targetClass, (ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT), JSFormatUtil.formatVisibility((JSAttributeList.AccessType)targetClass.getAttributeList().getAccessType()), ElementDescriptionUtil.getElementDescription((PsiElement)JSRefactoringConflictsUtil.getUsageLocation(usage), (ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT)});
                message = StringUtil.capitalize((String)message);
                conflicts.putValue((Object)usage, (Object)message);
            } else {
                String message = JavaScriptBundle.message((String)(showTargetClass ? "0.with.1.visibility.is.not.accessible.from.2" : "0.with.1.visibility.in.the.target.class.is.not.accessible.from.2"), (Object[])new Object[]{ElementDescriptionUtil.getElementDescription((PsiElement)member, (ElementDescriptionLocation)(showTargetClass ? RefactoringDescriptionLocation.WITH_PARENT : RefactoringDescriptionLocation.WITHOUT_PARENT)), JSFormatUtil.formatVisibility((JSAttributeList.AccessType)accessType), ElementDescriptionUtil.getElementDescription((PsiElement)JSRefactoringConflictsUtil.getUsageLocation(usage), (ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT)});
                message = StringUtil.capitalize((String)message);
                conflicts.putValue((Object)usage, (Object)message);
            }
        }
    }

    public static PsiElement getUsageLocation(PsiElement usage) {
        XmlBackedJSClass xmlBackedClass;
        Object result2 = usage.getParent() instanceof JSReferenceListMember && XmlBackedJSClassImpl.isImplementsAttribute((JSFile)((JSFile)usage.getContainingFile())) ? usage.getContainingFile() : PsiTreeUtil.getParentOfType((PsiElement)usage, JSFunction.class);
        if (result2 == null) {
            result2 = PsiTreeUtil.getParentOfType((PsiElement)usage, (Class[])new Class[]{JSVariable.class, JSClass.class, JSFile.class});
        }
        if (result2 instanceof JSFile && (xmlBackedClass = JSResolveUtil.getXmlBackedClass((JSFile)((JSFile)result2))) != null) {
            return xmlBackedClass;
        }
        return result2 != null ? result2 : usage.getContainingFile();
    }

    public static void checkMembersAlreadyExist(@NotNull Collection<? extends JSAttributeListOwner> members, @NotNull JSClass targetClass, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (members == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(2);
        }
        if (targetClass == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(3);
        }
        if (conflicts == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(4);
        }
        for (JSAttributeListOwner jSAttributeListOwner : members) {
            JSRefactoringConflictsUtil.checkMemberExist(jSAttributeListOwner, targetClass, conflicts);
        }
    }

    public static void checkMemberExist(@NotNull JSAttributeListOwner member, @NotNull JSClass targetClass, @NotNull MultiMap<PsiElement, String> conflicts) {
        JSAttributeListOwner conflict;
        if (member == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(5);
        }
        if (targetClass == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(6);
        }
        if (conflicts == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(7);
        }
        if ((conflict = JSRefactoringConflictsUtil.getConflictingMember(member, targetClass)) != null) {
            String message = StringUtil.capitalize((String)RefactoringBundle.message((String)"0.already.contains.a.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)}));
            conflicts.putValue((Object)conflict, (Object)message);
        }
    }

    @Nullable
    public static JSAttributeListOwner getConflictingMember(@NotNull JSAttributeListOwner member, @NotNull JSClass targetClass) {
        if (member == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(8);
        }
        if (targetClass == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(9);
        }
        JSField existing = null;
        if (member instanceof JSVariable) {
            existing = targetClass.findFieldByName(member.getName());
        } else if (member instanceof JSFunction) {
            TypeScriptFunction existingTypeScriptFunction;
            existing = JSInheritanceUtil.findMethodInClass((JSFunction)((JSFunction)member), (JSClass)targetClass, (boolean)targetClass.isInterface());
            if (existing != null && JSRefactoringUtil.isAbstract((PsiElement)targetClass, (JSAttributeListOwner)existing)) {
                return null;
            }
            TypeScriptFunction memberAsTypeScriptFunction = member instanceof TypeScriptFunction ? (TypeScriptFunction)member : null;
            TypeScriptFunction typeScriptFunction = existingTypeScriptFunction = existing instanceof TypeScriptFunction ? (TypeScriptFunction)existing : null;
            if (memberAsTypeScriptFunction != null && existingTypeScriptFunction != null && (memberAsTypeScriptFunction.isOverloadDeclaration() || memberAsTypeScriptFunction.isOverloadImplementation())) {
                return JSRefactoringConflictsUtil.parameterTypesEquivalent(memberAsTypeScriptFunction, existingTypeScriptFunction) ? existing : null;
            }
        }
        return existing;
    }

    private static boolean parameterTypesEquivalent(@NotNull TypeScriptFunction one, @NotNull TypeScriptFunction two) {
        JSParameterListElement[] secondParameters;
        JSParameterListElement[] firstParameters;
        if (one == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(10);
        }
        if (two == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(11);
        }
        if ((firstParameters = one.getParameters()).length != (secondParameters = two.getParameters()).length) {
            return false;
        }
        for (int i = 0; i < firstParameters.length; ++i) {
            JSType secondParameterType;
            JSParameterListElement firstParameter = firstParameters[i];
            JSParameterListElement secondParameter = secondParameters[i];
            JSType firstParameterType = firstParameter != null ? firstParameter.getJSType() : null;
            JSType jSType = secondParameterType = secondParameter != null ? secondParameter.getJSType() : null;
            if ((firstParameterType != null || secondParameterType == null) && (firstParameterType == null || firstParameterType.isEquivalentTo(secondParameterType, null))) continue;
            return false;
        }
        return true;
    }

    public static void checkOutgoingReferencesAccessibility(PsiElement memberToMove, @NotNull Collection<? extends PsiElement> membersToMove, @Nullable PsiElement target, boolean moveNotInline, MultiMap<PsiElement, String> conflicts, Condition<? super PsiElement> acceptor, @NotNull JSVisibilityUtil.Options options) {
        if (membersToMove == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(12);
        }
        if (options == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(13);
        }
        JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility(memberToMove, memberToMove, membersToMove, target, moveNotInline, conflicts, acceptor, new HashSet(), options);
    }

    public static void checkOutgoingReferencesInSignatureAccessibility(JSFunction memberToMove, @NotNull PsiElement target, boolean moveNotInline, MultiMap<PsiElement, String> conflicts, @NotNull JSVisibilityUtil.Options options) {
        if (target == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(14);
        }
        if (options == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(15);
        }
        ArrayList<JSParameterListElement> elements = new ArrayList<JSParameterListElement>(Arrays.asList(memberToMove.getParameters()));
        if (memberToMove.getReturnTypeElement() != null) {
            elements.add((JSParameterListElement)memberToMove.getReturnTypeElement());
        }
        HashSet reported = new HashSet();
        for (PsiElement psiElement : elements) {
            JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility((PsiElement)memberToMove, psiElement, Collections.emptyList(), target, moveNotInline, conflicts, (Condition<? super PsiElement>)Conditions.alwaysTrue(), reported, options);
        }
    }

    private static void checkOutgoingReferencesAccessibility(PsiElement member, PsiElement current, @NotNull Collection<? extends PsiElement> membersToMove, @Nullable PsiElement target, boolean moveNotInline, MultiMap<PsiElement, String> conflicts, Condition<? super PsiElement> acceptor, Collection<? super PsiElement> reported, @NotNull JSVisibilityUtil.Options options) {
        if (membersToMove == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(16);
        }
        if (options == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(17);
        }
        if (current instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)current;
            JSExpression qualifier = refExpr.getQualifier();
            if (JSResolveUtil.getTopReferenceExpression((JSReferenceExpression)refExpr) == refExpr || qualifier instanceof JSThisExpression) {
                String qName;
                JSNamespaceDeclaration namespaceDecl;
                boolean ignore;
                PsiElement resolved = refExpr.resolve();
                if (resolved != null && acceptor.value((Object)resolved) && !(ignore = moveNotInline ? JSRefactoringUtil.isOrWillBeInTargetClass(resolved, membersToMove, (JSClass)target, false) : PsiTreeUtil.isAncestor((PsiElement)member, (PsiElement)resolved, (boolean)false)) && !JSVisibilityUtil.isAccessible((PsiElement)resolved, (JSAttributeList)null, null, (PsiElement)(target != null ? target : refExpr), (JSVisibilityUtil.Options)options)) {
                    JSRefactoringConflictsUtil.reportInaccessibleElement(resolved, null, moveNotInline ? JSRefactoringConflictsUtil.getUsageLocation((PsiElement)refExpr) : target, moveNotInline, conflicts, reported);
                }
                if (resolved != null && DialectDetector.isActionScript((PsiElement)resolved) && (namespaceDecl = JSRefactoringUtil.getNamespace(resolved)) != null && !reported.contains(namespaceDecl) && !"AS3".equals(qName = namespaceDecl.getQualifiedName()) && !JSVisibilityUtil.isAccessible((PsiElement)namespaceDecl, (JSAttributeList)null, null, (PsiElement)(target != null ? target : refExpr), (JSVisibilityUtil.Options)options)) {
                    JSRefactoringConflictsUtil.reportInaccessibleElement((PsiElement)namespaceDecl, null, moveNotInline ? member : target, moveNotInline, conflicts, reported);
                }
            }
        }
        for (PsiElement child : current.getChildren()) {
            if (child instanceof PsiWhiteSpace) continue;
            JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility(member, child, membersToMove, target, moveNotInline, conflicts, acceptor, reported, options);
        }
    }

    private static PsiElement getInaccessibleElement(PsiElement element2) {
        JSClass clazz;
        if (!(element2 instanceof JSAttributeListOwner)) {
            return element2;
        }
        JSAttributeList attributeList = ((JSAttributeListOwner)element2).getAttributeList();
        if ((ActionScriptPsiImplUtil.getNamespace((JSAttributeList)attributeList) != null || attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC) && (clazz = JSUtils.getMemberContainingClass((PsiElement)element2)) != null) {
            return clazz;
        }
        return element2;
    }

    public static void reportInaccessibleElement(PsiElement subject, @Nullable JSClass subjectClassOverride, @NotNull PsiElement from, boolean moveNotInline, MultiMap<PsiElement, String> conflicts, Collection<? super PsiElement> reported) {
        if (from == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(18);
        }
        if (!reported.add((PsiElement)(subject = JSRefactoringConflictsUtil.getInaccessibleElement(subject)))) {
            return;
        }
        boolean reportVisibility = JSUtils.getMemberContainingClass((PsiElement)subject) != null || !ActionScriptResolveUtil.isFileLocalSymbol((PsiElement)subject);
        String subjectDescription = ElementDescriptionUtil.getElementDescription((PsiElement)subject, (ElementDescriptionLocation)JSRefactoringDescriptionLocation.overrideParentClass((JSClass)subjectClassOverride));
        String fromDescription = ElementDescriptionUtil.getElementDescription((PsiElement)from, (ElementDescriptionLocation)(moveNotInline ? RefactoringDescriptionLocation.WITHOUT_PARENT : RefactoringDescriptionLocation.WITH_PARENT));
        String message = reportVisibility ? RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{subjectDescription, JSFormatUtil.formatVisibility((PsiElement)subject), fromDescription}) : JavaScriptBundle.message((String)"0.is.not.accessible.from.1", (Object[])new Object[]{subjectDescription, fromDescription});
        message = StringUtil.capitalize((String)message);
        conflicts.putValue((Object)from, (Object)message);
    }

    public static void checkClassMemberAccessibilityConflicts(@NotNull PsiElement referenceElement, JSAttributeListOwner referenced, @NotNull JSVisibilityUtil.Options options, MultiMap<PsiElement, String> conflicts) {
        if (referenceElement == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(19);
        }
        if (options == null) {
            JSRefactoringConflictsUtil.$$$reportNull$$$0(20);
        }
        if (PsiTreeUtil.isAncestor((PsiElement)referenced, (PsiElement)referenceElement, (boolean)true)) {
            return;
        }
        PsiElement target = PsiTreeUtil.getParentOfType((PsiElement)referenceElement, JSFunction.class);
        if (target == null) {
            target = JSResolveUtil.getClassOfContext((PsiElement)referenceElement);
        }
        if (target == null) {
            target = referenceElement.getContainingFile();
        }
        JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility((PsiElement)referenced, Collections.singletonList(referenced), target, false, conflicts, (Condition<? super PsiElement>)Conditions.alwaysTrue(), options);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "one";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "two";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToMove";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/util/JSRefactoringConflictsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIncomingReferencesAccessibility";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAccessibility";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMembersAlreadyExist";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMemberExist";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getConflictingMember";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "parameterTypesEquivalent";
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOutgoingReferencesAccessibility";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOutgoingReferencesInSignatureAccessibility";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "reportInaccessibleElement";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassMemberAccessibilityConflicts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

