/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.application.options.CodeCompletionConfigurable;
import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSDialectsMappings;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.FlowJSConfigurationPanel;
import com.intellij.lang.javascript.settings.JSDialectMappingsConfigurable;
import com.intellij.lang.javascript.settings.JSLanguageVersionModel;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import com.intellij.webcore.libraries.ui.PerFileMappingsDialogWrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRootConfigurationPanel {
    JPanel myMainPanel;
    ComponentWithBrowseButton<JComboBox<JSLanguageLevel>> myJSLanguageComponent;
    JComboBox<JSLanguageLevel> myJSLanguageVersion;
    private final JEditorPane myDescription;
    @NotNull
    private final FlowJSConfigurationPanel myFlowSettings;
    @NotNull
    private final Project myProject;

    public JSRootConfigurationPanel(@NotNull Project project) {
        if (project == null) {
            JSRootConfigurationPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        JLabel versionLabel = new JLabel(JavaScriptBundle.message((String)"js.language.version.label", (Object[])new Object[0]));
        this.myJSLanguageVersion = new ComboBox((ComboBoxModel)new JSLanguageVersionModel());
        this.myJSLanguageVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSRootConfigurationPanel.this.updateLanguageDependentViews(JSRootConfigurationPanel.this.myProject);
            }
        });
        this.myJSLanguageComponent = new ComponentWithBrowseButton(this.myJSLanguageVersion, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSRootConfigurationPanel.this.showJSDialectMappingsDialog(JSRootConfigurationPanel.this.myProject);
            }
        });
        versionLabel.setLabelFor(this.myJSLanguageVersion);
        this.myDescription = SwingHelper.createHtmlViewer((boolean)true, null, null, null);
        GridBagLayout layout = new GridBagLayout();
        JPanel languageVersionPanel = new JPanel(layout);
        GridBagConstraints c0 = new GridBagConstraints();
        c0.insets = JBUI.insetsRight((int)10);
        languageVersionPanel.add((Component)versionLabel, c0);
        GridBagConstraints c1 = new GridBagConstraints();
        c1.insets = JBUI.insetsRight((int)10);
        languageVersionPanel.add((Component)this.myJSLanguageComponent, c1);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.weightx = 1.0;
        languageVersionPanel.add((Component)this.myDescription, c2);
        this.myFlowSettings = new FlowJSConfigurationPanel(project);
        JSRootConfigurationPanel.createCompletionSettingsHyperlink();
        this.myMainPanel = FormBuilder.createFormBuilder().setVerticalGap(8).addComponent((JComponent)languageVersionPanel).addComponent((JComponent)this.myFlowSettings.getPanel()).addVerticalGap(2).addComponent(JSRootConfigurationPanel.createCompletionSettingsHyperlink()).addComponentFillVertically((JComponent)new JPanel(), 0).getPanel();
    }

    private static JComponent createCompletionSettingsHyperlink() {
        final HyperlinkLabel settingsLink = new HyperlinkLabel(JavaScriptBundle.message((String)"configure.code.completion.settings", (Object[])new Object[0]));
        settingsLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                DataContext dataContext;
                Settings settings;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((settings = (Settings)Settings.KEY.getData(dataContext = DataManager.getInstance().getDataContext((Component)settingsLink))) == null) {
                    return;
                }
                Configurable codeCompletionConfigurable = settings.find("editor.preferences.completion");
                if (codeCompletionConfigurable instanceof CodeCompletionConfigurable) {
                    settings.select(codeCompletionConfigurable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/settings/JSRootConfigurationPanel$3", "hyperlinkActivated"));
            }
        });
        return settingsLink;
    }

    public JPanel getPanel() {
        return this.myMainPanel;
    }

    @NotNull
    public JSLanguageLevel getLanguageLevel() {
        JSLanguageLevel jSLanguageLevel = (JSLanguageLevel)this.myJSLanguageVersion.getModel().getSelectedItem();
        if (jSLanguageLevel == null) {
            JSRootConfigurationPanel.$$$reportNull$$$0(1);
        }
        return jSLanguageLevel;
    }

    public void setLanguageLevel(@NotNull JSLanguageLevel level) {
        if (level == null) {
            JSRootConfigurationPanel.$$$reportNull$$$0(2);
        }
        this.myJSLanguageVersion.getModel().setSelectedItem(level);
        this.updateLanguageDependentViews(this.myProject);
    }

    private void updateDescription(@Nullable JSLanguageLevel level) {
        String message = level != null ? level.getDescription() : JavaScriptBundle.message((String)"js.dialects.customized.label", (Object[])new Object[0]);
        SwingHelper.setHtml((JEditorPane)this.myDescription, (String)message, (Color)(level != null ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground()));
    }

    @NotNull
    public FlowJSConfigurationPanel getFlowPanel() {
        FlowJSConfigurationPanel flowJSConfigurationPanel = this.myFlowSettings;
        if (flowJSConfigurationPanel == null) {
            JSRootConfigurationPanel.$$$reportNull$$$0(3);
        }
        return flowJSConfigurationPanel;
    }

    private void showJSDialectMappingsDialog(Project project) {
        JSDialectMappingsConfigurable configurable = new JSDialectMappingsConfigurable(this, project);
        PerFileMappingsDialogWrapper dialogWrapper = new PerFileMappingsDialogWrapper((JComponent)this.myMainPanel, (PerFileConfigurableBase)configurable);
        dialogWrapper.setTitle(JavaScriptBundle.message((String)"js.dialect.settings.dialog.title", (Object[])new Object[0]));
        dialogWrapper.show();
    }

    void updateLanguageDependentViews(@NotNull Project project) {
        if (project == null) {
            JSRootConfigurationPanel.$$$reportNull$$$0(4);
        }
        JSLanguageVersionModel jsModel = (JSLanguageVersionModel)this.myJSLanguageVersion.getModel();
        JSLanguageLevel level = jsModel.getSelectedItem();
        Collection languageMappings = JSDialectsMappings.getInstance(project).getMappings().values();
        boolean hasFlow = level == JSLanguageLevel.FLOW || languageMappings.contains(JSLanguageLevel.FLOW.getId());
        this.myFlowSettings.getPanel().setVisible(hasFlow);
        this.updateDescription((JSLanguageLevel)(languageMappings.isEmpty() ? level : null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/settings/JSRootConfigurationPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/settings/JSRootConfigurationPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateLanguageDependentViews";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

