/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.ConstantUtils;
import org.jetbrains.annotations.NotNull;

public final class PointlessArithmeticExpressionJSInspection
extends JavaScriptInspection {
    private final PointlessArithmeticFix fix = new PointlessArithmeticFix();

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("pointless.arithmetic.error.message", PointlessArithmeticExpressionJSInspection.calculateReplacementExpression((JSExpression)args[0]));
        if (string == null) {
            PointlessArithmeticExpressionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String calculateReplacementExpression(JSExpression expression) {
        JSBinaryExpression exp = (JSBinaryExpression)expression;
        IElementType sign = exp.getOperationSign();
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        assert (rhs != null);
        assert (lhs != null);
        assert (sign != null);
        if (sign == JSTokenTypes.PLUS) {
            if (ConstantUtils.isZero(lhs)) {
                return rhs.getText();
            }
            return lhs.getText();
        }
        if (sign == JSTokenTypes.MINUS) {
            return lhs.getText();
        }
        if (sign == JSTokenTypes.MULT) {
            if (ConstantUtils.isOne(lhs)) {
                return rhs.getText();
            }
            if (ConstantUtils.isOne(rhs)) {
                return lhs.getText();
            }
            return "0";
        }
        if (sign == JSTokenTypes.DIV) {
            return lhs.getText();
        }
        throw new IncorrectOperationException("Token type " + sign.getClass().getName() + " not supported!");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessArithmeticVisitor();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    private static boolean subtractionExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
        return ConstantUtils.isZero(rhs) && PointlessArithmeticExpressionJSInspection.isNumber(lhs);
    }

    private static boolean additionExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
        return ConstantUtils.isZero(lhs) && PointlessArithmeticExpressionJSInspection.isNumber(rhs) || ConstantUtils.isZero(rhs) && PointlessArithmeticExpressionJSInspection.isNumber(lhs);
    }

    private static boolean multiplyExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
        if (ConstantUtils.isZero(lhs) || ConstantUtils.isZero(rhs)) {
            return true;
        }
        return ConstantUtils.isOne(lhs) && PointlessArithmeticExpressionJSInspection.isNumber(rhs) || ConstantUtils.isOne(rhs) && PointlessArithmeticExpressionJSInspection.isNumber(lhs);
    }

    private static boolean divideExpressionIsPointless(JSExpression lhs, JSExpression rhs) {
        return ConstantUtils.isOne(rhs) && PointlessArithmeticExpressionJSInspection.isNumber(lhs);
    }

    private static boolean isNumber(JSExpression exp) {
        return JSResolveUtil.getExpressionJSType((JSExpression)exp) instanceof JSNumberType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/PointlessArithmeticExpressionJSInspection", "buildErrorString"));
    }

    private static class PointlessArithmeticFix
    extends InspectionJSFix {
        private PointlessArithmeticFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("simplify.fix", new Object[0]);
            if (string == null) {
                PointlessArithmeticFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            JSExpression expression = (JSExpression)descriptor.getPsiElement();
            String newExpression = PointlessArithmeticExpressionJSInspection.calculateReplacementExpression(expression);
            PointlessArithmeticFix.replaceExpression(expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/PointlessArithmeticExpressionJSInspection$PointlessArithmeticFix", "getFamilyName"));
        }
    }

    private static class PointlessArithmeticVisitor
    extends BaseInspectionVisitor {
        private static final TokenSet ARITHMETIC_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.PLUS, JSTokenTypes.MINUS, JSTokenTypes.MULT, JSTokenTypes.DIV});

        private PointlessArithmeticVisitor() {
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                PointlessArithmeticVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSBinaryExpression(expression);
            if (PointlessArithmeticVisitor.isPointless(expression.getOperationSign(), expression.getROperand(), expression.getLOperand())) {
                this.registerError((PsiElement)expression);
            }
        }

        private static boolean isPointless(IElementType sign, JSExpression rhs, JSExpression lhs) {
            if (!ARITHMETIC_TOKENS.contains(sign) || lhs == null || rhs == null) {
                return false;
            }
            if (sign == JSTokenTypes.PLUS) {
                return PointlessArithmeticExpressionJSInspection.additionExpressionIsPointless(lhs, rhs);
            }
            if (sign == JSTokenTypes.MINUS) {
                return PointlessArithmeticExpressionJSInspection.subtractionExpressionIsPointless(lhs, rhs);
            }
            if (sign == JSTokenTypes.MULT) {
                return PointlessArithmeticExpressionJSInspection.multiplyExpressionIsPointless(lhs, rhs);
            }
            if (sign == JSTokenTypes.DIV) {
                return PointlessArithmeticExpressionJSInspection.divideExpressionIsPointless(lhs, rhs);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/confusing/PointlessArithmeticExpressionJSInspection$PointlessArithmeticVisitor", "visitJSBinaryExpression"));
        }
    }
}

