/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.functionmetrics.LoopCountVisitor;
import org.jetbrains.annotations.NotNull;

public final class FunctionWithMultipleLoopsJSInspection
extends JavaScriptInspection {
    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        JSFunction function = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function != null);
        int loopCount = LoopCountVisitor.countLoops(function);
        if (FunctionWithMultipleLoopsJSInspection.functionHasIdentifier(function)) {
            String string = InspectionJSBundle.message("function.contains.multiple.loops.error.string", loopCount);
            if (string == null) {
                FunctionWithMultipleLoopsJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionJSBundle.message("anonymous.function.contains.multiple.loops.error.string", loopCount);
        if (string == null) {
            FunctionWithMultipleLoopsJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/FunctionWithMultipleLoopsJSInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
            int negationCount;
            if (function == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if ((negationCount = LoopCountVisitor.countLoops(function)) <= 1) {
                return;
            }
            this.registerFunctionError(function);
        }

        public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.visitJSFunctionDeclaration((JSFunction)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/functionmetrics/FunctionWithMultipleLoopsJSInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionDeclaration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

