/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.codeWithMe.ClientId;
import com.intellij.kubernetes.DownloadManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\b\u0007\u0018\u0000 %2\u00020\u0001:\u0003$%&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000eJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001aH\u0007J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/kubernetes/DownloadManager;", "", "<init>", "()V", "ETAG_FILE_EXT", "", "TEMP_FILE_EXT", "cacheDir", "Ljava/nio/file/Path;", "timeOut", "", "lock", "Ljava/lang/Object;", "download", "", "url", "Lcom/intellij/util/Url;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "forced", "getLocalFileInfo", "Lcom/intellij/kubernetes/DownloadManager$LocalFileInfo;", "isUpToDate", "fileInfo", "Lcom/intellij/kubernetes/DownloadManager$InternalLocalFileInfo;", "markOutdated", "", "clearCache", "isEtagFile", "file", "isTempFile", "isOutdated", "time", "", "getInternalLocalFileInfo", "computeLocalFileName", "LocalFileInfo", "Companion", "InternalLocalFileInfo", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nDownloadManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadManager.kt\ncom/intellij/kubernetes/DownloadManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,200:1\n1#2:201\n13#3:202\n*S KotlinDebug\n*F\n+ 1 DownloadManager.kt\ncom/intellij/kubernetes/DownloadManager\n*L\n40#1:202\n*E\n"})
public final class DownloadManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String ETAG_FILE_EXT;
    @NotNull
    private final String TEMP_FILE_EXT;
    @NotNull
    private final Path cacheDir;
    private final int timeOut;
    @NotNull
    private final Object lock;
    @NotNull
    private static final Logger log;

    public DownloadManager() {
        this.ETAG_FILE_EXT = "etag";
        this.TEMP_FILE_EXT = "dl-tmp";
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("kubernetes").resolve("crd-cache");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.cacheDir = path;
        this.timeOut = 10800000;
        this.lock = new Object();
        Files.createDirectories(this.cacheDir, new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean download(@NotNull Url url, @Nullable ProgressIndicator progressIndicator, boolean forced) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object object = this.lock;
        synchronized (object) {
            Ref.BooleanRef updated;
            block12: {
                String string;
                InternalLocalFileInfo localFileInfo;
                block11: {
                    boolean bl = false;
                    localFileInfo = this.getInternalLocalFileInfo(url);
                    if (forced || !this.isUpToDate(localFileInfo)) break block11;
                    boolean bl2 = false;
                    return bl2;
                }
                if (localFileInfo.getContentFileExists()) {
                    String string2;
                    try {
                        string2 = FileUtil.loadFile((File)localFileInfo.getEtagFile().toFile(), (Charset)StandardCharsets.UTF_8);
                    }
                    catch (Exception e) {
                        string2 = null;
                    }
                    string = string2;
                } else {
                    string = null;
                }
                String lastEtag = string;
                RequestBuilder request = HttpRequests.request((Url)url);
                if (lastEtag != null) {
                    request.tuner(arg_0 -> DownloadManager.download$lambda$0$0(lastEtag, arg_0));
                }
                updated = new Ref.BooleanRef();
                try {
                    Unit cfr_ignored_0 = (Unit)request.connect(arg_0 -> DownloadManager.download$lambda$0$1(localFileInfo, this, progressIndicator, updated, arg_0));
                }
                catch (Exception e) {
                    if (e instanceof ProcessCanceledException) break block12;
                    throw e;
                }
            }
            boolean bl = updated.element;
            return bl;
        }
    }

    @Nullable
    public final LocalFileInfo getLocalFileInfo(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        InternalLocalFileInfo info = this.getInternalLocalFileInfo(url);
        if (!info.getContentFileExists()) {
            return null;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(info.getContentFile().toFile());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return new LocalFileInfo(virtualFile2, this, info){
            private final VirtualFile contentFile;
            private final boolean isUpToDate;
            {
                this.contentFile = $virtualFile;
                this.isUpToDate = DownloadManager.access$isUpToDate($receiver, $info);
            }

            public VirtualFile getContentFile() {
                return this.contentFile;
            }

            public boolean isUpToDate() {
                return this.isUpToDate;
            }
        };
    }

    private final boolean isUpToDate(InternalLocalFileInfo fileInfo) {
        boolean bl;
        try {
            bl = fileInfo.getContentFileExists() && !this.isOutdated(fileInfo.getContentFile());
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markOutdated() {
        AutoCloseable autoCloseable = Files.list(this.cacheDir);
        Throwable throwable = null;
        try {
            Stream files = (Stream)autoCloseable;
            boolean bl = false;
            files.filter(arg_0 -> DownloadManager.markOutdated$lambda$0$1(arg_0 -> DownloadManager.markOutdated$lambda$0$0(this, arg_0), arg_0)).forEach(arg_0 -> DownloadManager.markOutdated$lambda$0$3(arg_0 -> DownloadManager.markOutdated$lambda$0$2(this, arg_0), arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void clearCache() {
        AutoCloseable autoCloseable = Files.list(this.cacheDir);
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl = false;
            it.forEach(arg_0 -> DownloadManager.clearCache$lambda$0$0(clearCache.1.1.INSTANCE, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final boolean isEtagFile(Path file) {
        return StringsKt.endsWith$default((String)((Object)file.getFileName()).toString(), (String)("." + this.ETAG_FILE_EXT), (boolean)false, (int)2, null);
    }

    private final boolean isTempFile(Path file) {
        return StringsKt.endsWith$default((String)((Object)file.getFileName()).toString(), (String)("." + this.TEMP_FILE_EXT), (boolean)false, (int)2, null);
    }

    private final boolean isOutdated(Path file) {
        return this.isOutdated(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis());
    }

    private final boolean isOutdated(long time) {
        return System.currentTimeMillis() - time > (long)this.timeOut;
    }

    private final InternalLocalFileInfo getInternalLocalFileInfo(Url url) {
        String localFileName = this.computeLocalFileName(url);
        Path etagFile = this.cacheDir.resolve(localFileName + "." + this.ETAG_FILE_EXT);
        Path mainContentFile = this.cacheDir.resolve(localFileName);
        Intrinsics.checkNotNull((Object)mainContentFile);
        Intrinsics.checkNotNull((Object)etagFile);
        return new InternalLocalFileInfo(mainContentFile, etagFile, Files.exists(mainContentFile, new LinkOption[0]));
    }

    private final String computeLocalFileName(Url url) {
        String string = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        char[] cArray = new char[]{'/'};
        String fileNameInUrl = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        String urlHash = Integer.toHexString(url.hashCode());
        String name = null;
        String extension = null;
        char[] cArray2 = new char[]{'.'};
        List it = StringsKt.split$default((CharSequence)fileNameInUrl, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        name = CollectionsKt.joinToString$default((Iterable)it.subList(0, it.size() - 1), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        extension = it.size() > 1 && !StringsKt.isBlank((CharSequence)((CharSequence)CollectionsKt.last((List)it))) ? (String)CollectionsKt.last((List)it) : "txt";
        return name + "." + urlHash + "." + extension;
    }

    private static final void download$lambda$0$0(String $lastEtag, URLConnection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setRequestProperty("If-None-Match", $lastEtag);
    }

    private static final Unit download$lambda$0$1(InternalLocalFileInfo $localFileInfo, DownloadManager this$0, ProgressIndicator $progressIndicator, Ref.BooleanRef $updated, HttpRequests.Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String etag = it.getConnection().getHeaderField("ETag");
        URLConnection uRLConnection = it.getConnection();
        HttpURLConnection httpURLConnection = uRLConnection instanceof HttpURLConnection ? (HttpURLConnection)uRLConnection : null;
        boolean bl = httpURLConnection != null ? httpURLConnection.getResponseCode() == 304 : false;
        if (bl) {
            Files.setLastModifiedTime($localFileInfo.getContentFile(), FileTime.fromMillis(System.currentTimeMillis()));
            return Unit.INSTANCE;
        }
        File tempContentFile = $localFileInfo.getContentFile().resolveSibling($localFileInfo.getContentFile().getFileName() + "." + this$0.TEMP_FILE_EXT).toFile();
        it.saveToFile(tempContentFile, $progressIndicator);
        FileUtil.rename((File)tempContentFile, (File)$localFileInfo.getContentFile().toFile());
        LocalFileSystem.getInstance().refreshIoFiles((Iterable)CollectionsKt.listOf((Object)$localFileInfo.getContentFile().toFile()), false, false, null);
        if (etag != null) {
            File ioEtagFile = $localFileInfo.getEtagFile().toFile();
            FileUtil.writeToFile((File)ioEtagFile, (String)etag);
            LocalFileSystem.getInstance().refreshIoFiles((Iterable)CollectionsKt.listOf((Object)ioEtagFile), false, false, null);
        }
        $updated.element = true;
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean markOutdated$lambda$0$0(DownloadManager this$0, Path it) {
        if (Files.isDirectory(it, new LinkOption[0])) return false;
        Intrinsics.checkNotNull((Object)it);
        if (this$0.isTempFile(it)) return false;
        return true;
    }

    private static final boolean markOutdated$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit markOutdated$lambda$0$2(DownloadManager this$0, Path it) {
        Intrinsics.checkNotNull((Object)it);
        if (this$0.isEtagFile(it)) {
            try {
                FileUtil.delete((Path)it);
            }
            catch (Exception e) {
                log.warn("unable to delete file " + it, (Throwable)e);
            }
        } else if (!this$0.isOutdated(it)) {
            try {
                Files.setLastModifiedTime(it, FileTime.fromMillis(System.currentTimeMillis() - (long)(this$0.timeOut + 1000)));
            }
            catch (Exception e) {
                log.warn("unable to set modification time for " + it, (Throwable)e);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void markOutdated$lambda$0$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void clearCache$lambda$0$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isUpToDate(DownloadManager $this, InternalLocalFileInfo fileInfo) {
        return $this.isUpToDate(fileInfo);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DownloadManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/kubernetes/DownloadManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/kubernetes/DownloadManager;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nDownloadManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadManager.kt\ncom/intellij/kubernetes/DownloadManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,200:1\n42#2,3:201\n*S KotlinDebug\n*F\n+ 1 DownloadManager.kt\ncom/intellij/kubernetes/DownloadManager$Companion\n*L\n38#1:201,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DownloadManager getInstance() {
            boolean $i$f$service = false;
            Class<DownloadManager> serviceClass$iv = DownloadManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (DownloadManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kubernetes/DownloadManager$InternalLocalFileInfo;", "", "contentFile", "Ljava/nio/file/Path;", "etagFile", "contentFileExists", "", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Z)V", "getContentFile", "()Ljava/nio/file/Path;", "getEtagFile", "getContentFileExists", "()Z", "intellij.clouds.kubernetes"})
    private static final class InternalLocalFileInfo {
        @NotNull
        private final Path contentFile;
        @NotNull
        private final Path etagFile;
        private final boolean contentFileExists;

        public InternalLocalFileInfo(@NotNull Path contentFile, @NotNull Path etagFile, boolean contentFileExists) {
            Intrinsics.checkNotNullParameter((Object)contentFile, (String)"contentFile");
            Intrinsics.checkNotNullParameter((Object)etagFile, (String)"etagFile");
            this.contentFile = contentFile;
            this.etagFile = etagFile;
            this.contentFileExists = contentFileExists;
        }

        @NotNull
        public final Path getContentFile() {
            return this.contentFile;
        }

        @NotNull
        public final Path getEtagFile() {
            return this.etagFile;
        }

        public final boolean getContentFileExists() {
            return this.contentFileExists;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/kubernetes/DownloadManager$LocalFileInfo;", "", "contentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getContentFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "isUpToDate", "", "()Z", "intellij.clouds.kubernetes"})
    public static interface LocalFileInfo {
        @NotNull
        public VirtualFile getContentFile();

        public boolean isUpToDate();
    }
}

