/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.vfs;

import com.intellij.kubernetes.view.vfs.KubernetesVfsRoot;
import com.intellij.kubernetes.view.vfs.KubernetesVirtualDirectory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.project.ProjectKt;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\f\u001a\u00020\u000b2\u000f\b\u0002\u0010\r\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000f2\u000f\b\u0002\u0010\u0010\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kubernetes/view/vfs/KubernetesVfsRoot;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "rootDirectory", "Lcom/intellij/kubernetes/view/vfs/KubernetesVirtualDirectory;", "getRootDirectory", "()Lcom/intellij/kubernetes/view/vfs/KubernetesVirtualDirectory;", "rootTempDirectory", "Ljava/nio/file/Path;", "createTempFile", "prefix", "", "Lorg/jetbrains/annotations/NonNls;", "suffix", "dispose", "", "Companion", "intellij.clouds.kubernetes"})
public final class KubernetesVfsRoot
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KubernetesVirtualDirectory rootDirectory;
    @NotNull
    private final Path rootTempDirectory;

    public KubernetesVfsRoot(@NotNull Project project) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!project.isDefault()) {
            String string2 = ProjectKt.getStateStore((Project)project).getProjectWorkspaceId();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            string = "default";
        }
        String workspaceId = string;
        this.rootDirectory = new KubernetesVirtualDirectory(workspaceId, null);
        Path path = PathManager.getSystemDir().resolve("kubernetes").resolve(workspaceId);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.rootTempDirectory = path;
        Files.createDirectories(this.rootTempDirectory, new FileAttribute[0]);
    }

    @NotNull
    public final KubernetesVirtualDirectory getRootDirectory() {
        return this.rootDirectory;
    }

    @NotNull
    public final Path createTempFile(@Nullable String prefix, @Nullable String suffix) {
        Path path = Files.createTempFile(this.rootTempDirectory, prefix, suffix, new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
        return path;
    }

    public static /* synthetic */ Path createTempFile$default(KubernetesVfsRoot kubernetesVfsRoot, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return kubernetesVfsRoot.createTempFile(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AutoCloseable autoCloseable = Files.walk(this.rootTempDirectory, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            stream.sorted(Comparator.reverseOrder()).forEach(arg_0 -> KubernetesVfsRoot.dispose$lambda$0$0(dispose.1.1.INSTANCE, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Files.deleteIfExists(this.rootTempDirectory);
    }

    private static final void dispose$lambda$0$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final KubernetesVfsRoot getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/kubernetes/view/vfs/KubernetesVfsRoot$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/kubernetes/view/vfs/KubernetesVfsRoot;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesVfsRoot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesVfsRoot.kt\ncom/intellij/kubernetes/view/vfs/KubernetesVfsRoot$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,55:1\n30#2,2:56\n*S KotlinDebug\n*F\n+ 1 KubernetesVfsRoot.kt\ncom/intellij/kubernetes/view/vfs/KubernetesVfsRoot$Companion\n*L\n21#1:56,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KubernetesVfsRoot getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KubernetesVfsRoot> serviceClass$iv = KubernetesVfsRoot.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KubernetesVfsRoot)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

