/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.modulith;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringClassAccessInfoProvider;
import com.intellij.spring.modulith.SpringModulithLibraryUtilsKt;
import com.intellij.spring.modulith.model.ApplicationModule;
import com.intellij.spring.modulith.model.SpringModulithModelService;
import com.intellij.spring.modulith.verification.SpringModulithVerificationKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/modulith/SpringModulithAccessInfoProvider;", "Lcom/intellij/spring/SpringClassAccessInfoProvider;", "<init>", "()V", "isApplicable", "", "module", "Lcom/intellij/openapi/module/Module;", "getAccessInfo", "Lcom/intellij/spring/SpringClassAccessInfoProvider$AccessInfo;", "source", "Lcom/intellij/psi/PsiClass;", "target", "intellij.spring.modulith"})
@SourceDebugExtension(value={"SMAP\nSpringModulithAccessInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringModulithAccessInfoProvider.kt\ncom/intellij/spring/modulith/SpringModulithAccessInfoProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1#2:35\n*E\n"})
public final class SpringModulithAccessInfoProvider
implements SpringClassAccessInfoProvider {
    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return SpringModulithLibraryUtilsKt.hasModulithLibrary(module);
    }

    @NotNull
    public SpringClassAccessInfoProvider.AccessInfo getAccessInfo(@NotNull PsiClass source, @NotNull PsiClass target) {
        Object v3;
        List<ApplicationModule> appModules;
        block6: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)source));
            if (module == null) {
                return SpringClassAccessInfoProvider.Companion.getACCESS_ALLOWED();
            }
            Module module2 = module;
            if (!SpringModulithLibraryUtilsKt.hasModulithLibrary(module2)) {
                return SpringClassAccessInfoProvider.Companion.getACCESS_ALLOWED();
            }
            Project project = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            appModules = SpringModulithModelService.Companion.getInstance$intellij_spring_modulith(project).getModel$intellij_spring_modulith(module2);
            if (appModules.isEmpty()) {
                return SpringClassAccessInfoProvider.Companion.getACCESS_ALLOWED();
            }
            Iterable iterable = appModules;
            for (Object t : iterable) {
                ApplicationModule it = (ApplicationModule)t;
                boolean bl = false;
                String string = target.getQualifiedName();
                if (string == null) {
                    string = "";
                }
                if (!it.hasClass(string)) continue;
                v3 = t;
                break block6;
            }
            v3 = null;
        }
        ApplicationModule targetModule = v3;
        if (targetModule == null) {
            return SpringClassAccessInfoProvider.Companion.getACCESS_ALLOWED();
        }
        return new SpringClassAccessInfoProvider.AccessInfo(SpringModulithVerificationKt.verifyApiAccess(source, target, appModules).isAccessAllowed(), targetModule.getId());
    }
}

