/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.protobuf.lang.lexer.ProtoLexer;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import java.io.Reader;

public class _ProtoLexer
implements FlexLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int COMMENT = 2;
    public static final int AFTER_NUMBER = 4;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2};
    private static final int[] ZZ_CMAP_TOP = _ProtoLexer.zzUnpackcmap_top();
    private static final String ZZ_CMAP_TOP_PACKED_0 = "\u0001\u0000\u10ff\u0100";
    private static final int[] ZZ_CMAP_BLOCKS = _ProtoLexer.zzUnpackcmap_blocks();
    private static final String ZZ_CMAP_BLOCKS_PACKED_0 = "\t\u0000\u0001\u0001\u0001\u0002\u0003\u0001\u0012\u0000\u0001\u0001\u0001\u0003\u0001\u0004\u0001\u0005\u0003\u0003\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0007\u0010\u0002\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0002\u0003\u0004\u0017\u0001\u0018\u0001\u0019\u0011\u001a\u0001\u001b\u0002\u001a\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u0003\u0001\u001f\u0001\u0003\u0001 \u0001!\u0001\"\u0001#\u0001$\u0001%\u0001&\u0001\u001a\u0001'\u0001(\u0001)\u0001*\u0001+\u0001,\u0001-\u0001.\u0001/\u00010\u00011\u00012\u00013\u00014\u00015\u00016\u00017\u0001\u001a\u00018\u0001\u0003\u00019\u0001\u0003\u0181\u0000";
    private static final int[] ZZ_ACTION = _ProtoLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0004\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0002\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\r\u0012\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0000\u0001\u0018\u0001\u0019\u0003\u0004\u0001\u001a\u0001\u001b\u0001\f\u0001\u0000\u0001\u001c\u0001\u0000\u0013\u0012\u0001\u001d\u0002\u0012\u0001\u001e\u0001\u001f\u0001\u0000\u0001\u001a\u0001\f\t\u0012\u0001 \u0001!\t\u0012\u0001\"\u0005\u0012\u0001\u001e\u0002\u0012\u0001#\u0012\u0012\u0001$\u0001%\u0001\u001e\u0004\u0012\u0001&\u0002\u0012\u0001'\u0001\u0012\u0001(\f\u0012\u0001)\u0001*\u0001\u0012\u0001+\u0002\u0012\u0001,\u0001\u0012\u0001-\u0005\u0012\u0001.\u0001/\u00010\u00011\u0002\u0012\u00012\u0001\u0012\u00013\u0003\u0012\u00014\u00015\u0002\u0012\u00016\u00017\u00018\u00019\u0001\u0012\u0001:\u0001;";
    private static final int[] ZZ_ROWMAP = _ProtoLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000:\u0000t\u0000\u00ae\u0000\u00e8\u0000\u00ae\u0000\u0122\u0000\u00ae\u0000\u015c\u0000\u00ae\u0000\u00ae\u0000\u00ae\u0000\u00ae\u0000\u0196\u0000\u01d0\u0000\u020a\u0000\u0244\u0000\u00ae\u0000\u00ae\u0000\u00ae\u0000\u00ae\u0000\u00ae\u0000\u027e\u0000\u00ae\u0000\u00ae\u0000\u02b8\u0000\u02f2\u0000\u032c\u0000\u0366\u0000\u03a0\u0000\u03da\u0000\u0414\u0000\u044e\u0000\u0488\u0000\u04c2\u0000\u04fc\u0000\u0536\u0000\u0570\u0000\u00ae\u0000\u00ae\u0000\u05aa\u0000\u05e4\u0000\u00ae\u0000\u061e\u0000\u00ae\u0000\u0658\u0000\u0692\u0000\u06cc\u0000\u00ae\u0000\u0706\u0000\u0740\u0000\u00ae\u0000\u077a\u0000\u07b4\u0000\u07ee\u0000\u0828\u0000\u0862\u0000\u089c\u0000\u08d6\u0000\u0910\u0000\u094a\u0000\u0984\u0000\u09be\u0000\u09f8\u0000\u0a32\u0000\u0a6c\u0000\u0aa6\u0000\u0ae0\u0000\u0b1a\u0000\u0b54\u0000\u0b8e\u0000\u0bc8\u0000\u027e\u0000\u0c02\u0000\u0c3c\u0000\u0c76\u0000\u00ae\u0000\u0cb0\u0000\u0cea\u0000\u077a\u0000\u0d24\u0000\u0d5e\u0000\u0d98\u0000\u0dd2\u0000\u0e0c\u0000\u0e46\u0000\u0e80\u0000\u0eba\u0000\u0ef4\u0000\u027e\u0000\u027e\u0000\u0f2e\u0000\u0f68\u0000\u0fa2\u0000\u0fdc\u0000\u1016\u0000\u1050\u0000\u108a\u0000\u10c4\u0000\u10fe\u0000\u027e\u0000\u1138\u0000\u1172\u0000\u11ac\u0000\u11e6\u0000\u1220\u0000\u125a\u0000\u1294\u0000\u12ce\u0000\u027e\u0000\u1308\u0000\u1342\u0000\u137c\u0000\u13b6\u0000\u13f0\u0000\u142a\u0000\u1464\u0000\u149e\u0000\u14d8\u0000\u1512\u0000\u154c\u0000\u1586\u0000\u15c0\u0000\u15fa\u0000\u1634\u0000\u166e\u0000\u16a8\u0000\u16e2\u0000\u027e\u0000\u027e\u0000\u00ae\u0000\u171c\u0000\u1756\u0000\u1790\u0000\u17ca\u0000\u027e\u0000\u1804\u0000\u183e\u0000\u027e\u0000\u1878\u0000\u027e\u0000\u18b2\u0000\u18ec\u0000\u1926\u0000\u1960\u0000\u199a\u0000\u19d4\u0000\u1a0e\u0000\u1a48\u0000\u1a82\u0000\u1abc\u0000\u1af6\u0000\u1b30\u0000\u027e\u0000\u027e\u0000\u1b6a\u0000\u027e\u0000\u1ba4\u0000\u1bde\u0000\u1c18\u0000\u1c52\u0000\u027e\u0000\u1c8c\u0000\u1cc6\u0000\u1d00\u0000\u1d3a\u0000\u1d74\u0000\u027e\u0000\u027e\u0000\u027e\u0000\u027e\u0000\u1dae\u0000\u1de8\u0000\u027e\u0000\u1e22\u0000\u027e\u0000\u1e5c\u0000\u1e96\u0000\u1ed0\u0000\u027e\u0000\u027e\u0000\u1f0a\u0000\u1f44\u0000\u027e\u0000\u027e\u0000\u027e\u0000\u027e\u0000\u1f7e\u0000\u027e\u0000\u027e";
    private static final int[] ZZ_TRANS = _ProtoLexer.zzUnpacktrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0004\u0002\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0002\u0006\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0002\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0005\u0017\u0001\u0018\u0001\u0006\u0001\u0019\u0004\u0017\u0001\u001a\u0001\u001b\u0001\u0017\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u0017\u0001\u001f\u0001 \u0001\u0017\u0001!\u0001\"\u0001\u0017\u0001#\u0001$\u0001%\u0002\u0017\u0001&\u0002\u0017\u0001'\u0001(\u0005\u0000\u0001)\b\u0000\u0001*+\u0000\u0017+\u0005,\u0003+\u0019,\u0002+;\u0000\u0002\u00057\u0000\u0002\u0007\u0001\u0000\u0001\u0007\u0001-\u0018\u0007\u0001.\u001c\u0007\u0002\t\u0001\u0000\u0003\t\u0001-\u0016\t\u0001/\u001c\t\u000f\u0000\u000301\u0000\u00011\u0004\u0000\u000118\u0000\u00010\u0001\u0000\u00022\u0007\u0000\u00013\u00014\u0001\u0000\u00015\b\u0000\u00013\u00014\u0010\u0000\u00015\u0010\u0000\u00010\u0001\u0000\u0003\u0011\u0006\u0000\u00013\u00014\n\u0000\u00013\u00014#\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0019\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u00016\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0004\u0017\u00017\b\u0017\u00018\t\u0017\u00019\u0001\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u0001:\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\f\u0017\u0001;\f\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0012\u0017\u0001<\u0006\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001=\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001>\u0003\u0017\u0001?\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001@\u0001\u0017\u0001A\t\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001B\u0012\u0017\u0001C\u0004\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001D\t\u0017\u0001E\t\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001F\r\u0017\u0001G\u0004\u0017\u0001H\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001I\u0002\u0017\u0001J\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001K\u0013\u0017\u0002\u0000\u0002)\u0001\u00007)\t\u0000\u0001L\u0004\u0000\u0001):\u0000\u0003,\u0005\u0000\u0005,\u0003\u0000\u0019,\u0002\u0000\u0002\u0007\u0001\u00007\u0007\u0002\t\u0001\u00007\t\u000f\u0000\u00030\u0006\u0000\u00013\u0001M\n\u0000\u00013\u0001M#\u0000\u000223\u0000\u0001N\u0001\u0000\u0001N\u0002\u0000\u0003O7\u0000\u0003P\u0005\u0000\u0003P\u0006\u0000\u0006P#\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0006\u0017\u0001Q\u0012\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\b\u0017\u0001R\u0010\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0014\u0017\u0001S\u0004\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000f\u0017\u0001T\u0003\u0017\u0001U\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001V\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000f\u0017\u0001W\t\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001X\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0003\u0017\u0001Y\u0015\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000f\u0017\u0001Z\u0007\u0017\u0001[\u0001\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0012\u0017\u0001\\\u0006\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001]\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0013\u0017\u0001^\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0003\u0017\u0001_\u0015\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0002\u0017\u0001`\u0016\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000f\u0017\u0001a\u0001b\u0001\u0017\u0001c\u0001d\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0003\u0017\u0001e\u0015\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u0001f\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u0001g\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001h\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0014\u0017\u0001i\u0004\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001j\u0017\u0017\u0002\u0000\tL\u0001k0L\u000f\u0000\u0003O7\u0000\u0003O\u0007\u0000\u0001M\u000b\u0000\u0001M#\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001l\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0013\u0017\u0001m\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\f\u0017\u0001n\f\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001o\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001p\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0014\u0017\u0001q\u0004\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001r\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001s\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001t\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0012\u0017\u0001u\u0006\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001v\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\b\u0017\u0001w\u0010\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\n\u0017\u0001x\u000e\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000b\u0017\u0001y\r\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001z\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0014\u0017\u0001{\u0004\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001|\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0014\u0017\u0001}\u0004\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0015\u0017\u0001~\u0003\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u007f\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0013\u0017\u0001\u0080\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u0081\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\n\u0017\u0001\u0082\u000e\u0017\u0002\u0000\tL\u0001k\u0004L\u0001\u0083+L\u000f\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0014\u0017\u0001\u0084\u0004\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\b\u0017\u0001\u0085\u0010\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u0001\u0086\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001\u0087\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000f\u0017\u0001\u0088\t\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u0001\u0089\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u008a\u0018\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000b\u0017\u0001\u008b\r\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001\u008c\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0006\u0017\u0001\u008d\u0012\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001\u008e\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001\u008f\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\b\u0017\u0001\u0090\u0010\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001\u0091\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\b\u0017\u0001\u0092\u0010\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u0001\u0093\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u0001\u0094\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\b\u0017\u0001\u0095\u0010\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001\u0096\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001\u0097\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000b\u0017\u0001\u0098\r\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001\u0099\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0013\u0017\u0001\u009a\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0004\u0017\u0001\u009b\r\u0017\u0001\u009c\u0006\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0013\u0017\u0001\u009d\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001\u009e\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0007\u0017\u0001\u009f\u0011\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001\u00a0\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0007\u0017\u0001\u00a1\u0011\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0003\u0017\u0001\u00a2\u0015\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0013\u0017\u0001\u00a3\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u0001\u00a4\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0015\u0017\u0001\u00a5\u0003\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001\u00a6\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0003\u0017\u0001\u00a7\u0015\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\f\u0017\u0001\u00a8\f\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0017\u0017\u0001\u00a9\u0001\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0013\u0017\u0001\u00aa\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001\u00ab\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\b\u0017\u0001\u00ac\u0010\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001\u00ad\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u00ae\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001\u00af\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u00b0\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u00b1\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u00b2\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u00b3\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0012\u0017\u0001\u00b4\u0006\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u00b5\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001\u00b6\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\f\u0017\u0001\u00b7\f\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000b\u0017\u0001\u00b8\r\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0004\u0017\u0001\u00b9\u0014\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0004\u0017\u0001\u00ba\u0014\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0004\u0017\u0001\u00bb\u0014\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001\u00bc\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u00bd\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0012\u0017\u0001\u00be\u0006\u0017\u0002\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _ProtoLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0003\u0000\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0004\t\u0004\u0001\u0005\t\u0001\u0001\u0002\t\r\u0001\u0002\t\u0001\u0001\u0001\u0000\u0001\t\u0001\u0001\u0001\t\u0003\u0001\u0001\t\u0001\u0001\u0001\u0000\u0001\t\u0001\u0000\u0017\u0001\u0001\t\u0001\u00004\u0001\u0001\t;\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    private int yyline;
    protected int yycolumn;
    private long yychar;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;
    private ProtoLexer.CommentStyle commentStyle;
    private boolean allowFloatCast;
    private boolean returnKeywords;

    private static int[] zzUnpackcmap_top() {
        int[] result = new int[4352];
        int offset = 0;
        offset = _ProtoLexer.zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_top(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] result = new int[512];
        int offset = 0;
        offset = _ProtoLexer.zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_blocks(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[190];
        int offset = 0;
        offset = _ProtoLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[190];
        int offset = 0;
        offset = _ProtoLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length() - 1;
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpacktrans() {
        int[] result = new int[8120];
        int offset = 0;
        offset = _ProtoLexer.zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpacktrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[190];
        int offset = 0;
        offset = _ProtoLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public _ProtoLexer(ProtoLexer.CommentStyle commentStyle, boolean allowFloatCast, boolean returnKeywords) {
        this(null);
        this.commentStyle = commentStyle;
        this.allowFloatCast = allowFloatCast;
        this.returnKeywords = returnKeywords;
    }

    private IElementType keyword(IElementType type) {
        return this.returnKeywords ? type : ProtoTokenTypes.IDENTIFIER_LITERAL;
    }

    public _ProtoLexer(Reader in) {
        this.zzReader = in;
    }

    private int zzMaxBufferLen() {
        return Integer.MAX_VALUE;
    }

    private boolean zzCanGrow() {
        return true;
    }

    private static int zzCMap(int input) {
        int offset = input & 0xFF;
        return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block120: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + _ProtoLexer.zzCMap(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return TokenType.BAD_CHARACTER;
                }
                case 60: {
                    continue block120;
                }
                case 2: {
                    return TokenType.WHITE_SPACE;
                }
                case 61: {
                    continue block120;
                }
                case 3: {
                    return ProtoTokenTypes.SYMBOL;
                }
                case 62: {
                    continue block120;
                }
                case 4: {
                    return ProtoTokenTypes.STRING_LITERAL;
                }
                case 63: {
                    continue block120;
                }
                case 5: {
                    if (this.commentStyle == ProtoLexer.CommentStyle.SH_STYLE) {
                        this.yypushback(1);
                        this.yybegin(2);
                    } else {
                        return ProtoTokenTypes.SYMBOL;
                    }
                }
                case 64: {
                    continue block120;
                }
                case 6: {
                    return ProtoTokenTypes.LPAREN;
                }
                case 65: {
                    continue block120;
                }
                case 7: {
                    return ProtoTokenTypes.RPAREN;
                }
                case 66: {
                    continue block120;
                }
                case 8: {
                    return ProtoTokenTypes.COMMA;
                }
                case 67: {
                    continue block120;
                }
                case 9: {
                    return ProtoTokenTypes.MINUS;
                }
                case 68: {
                    continue block120;
                }
                case 10: {
                    return ProtoTokenTypes.DOT;
                }
                case 69: {
                    continue block120;
                }
                case 11: {
                    return ProtoTokenTypes.SLASH;
                }
                case 70: {
                    continue block120;
                }
                case 12: {
                    this.yybegin(4);
                    return ProtoTokenTypes.INTEGER_LITERAL;
                }
                case 71: {
                    continue block120;
                }
                case 13: {
                    return ProtoTokenTypes.COLON;
                }
                case 72: {
                    continue block120;
                }
                case 14: {
                    return ProtoTokenTypes.SEMI;
                }
                case 73: {
                    continue block120;
                }
                case 15: {
                    return ProtoTokenTypes.LT;
                }
                case 74: {
                    continue block120;
                }
                case 16: {
                    return ProtoTokenTypes.ASSIGN;
                }
                case 75: {
                    continue block120;
                }
                case 17: {
                    return ProtoTokenTypes.GT;
                }
                case 76: {
                    continue block120;
                }
                case 18: {
                    return ProtoTokenTypes.IDENTIFIER_LITERAL;
                }
                case 77: {
                    continue block120;
                }
                case 19: {
                    return ProtoTokenTypes.LBRACK;
                }
                case 78: {
                    continue block120;
                }
                case 20: {
                    return ProtoTokenTypes.RBRACK;
                }
                case 79: {
                    continue block120;
                }
                case 21: {
                    return ProtoTokenTypes.LBRACE;
                }
                case 80: {
                    continue block120;
                }
                case 22: {
                    return ProtoTokenTypes.RBRACE;
                }
                case 81: {
                    continue block120;
                }
                case 23: {
                    this.yybegin(0);
                    return ProtoTokenTypes.LINE_COMMENT;
                }
                case 82: {
                    continue block120;
                }
                case 24: {
                    this.yybegin(0);
                    this.yypushback(this.yylength());
                }
                case 83: {
                    continue block120;
                }
                case 25: {
                    this.yybegin(0);
                    return ProtoTokenTypes.IDENTIFIER_AFTER_NUMBER;
                }
                case 84: {
                    continue block120;
                }
                case 26: {
                    this.yybegin(4);
                    return ProtoTokenTypes.FLOAT_LITERAL;
                }
                case 85: {
                    continue block120;
                }
                case 27: {
                    if (this.commentStyle == ProtoLexer.CommentStyle.C_STYLE) {
                        this.yypushback(2);
                        this.yybegin(2);
                    } else {
                        this.yypushback(1);
                        return ProtoTokenTypes.SLASH;
                    }
                }
                case 86: {
                    continue block120;
                }
                case 28: {
                    this.yybegin(4);
                    if (this.allowFloatCast) {
                        return ProtoTokenTypes.FLOAT_LITERAL;
                    }
                    this.yypushback(1);
                    return ProtoTokenTypes.INTEGER_LITERAL;
                }
                case 87: {
                    continue block120;
                }
                case 29: {
                    return this.keyword(ProtoTokenTypes.TO);
                }
                case 88: {
                    continue block120;
                }
                case 30: {
                    this.yybegin(0);
                    return ProtoTokenTypes.BLOCK_COMMENT;
                }
                case 89: {
                    continue block120;
                }
                case 31: {
                    this.yybegin(4);
                    if (!this.allowFloatCast) {
                        this.yypushback(1);
                    }
                    return ProtoTokenTypes.FLOAT_LITERAL;
                }
                case 90: {
                    continue block120;
                }
                case 32: {
                    return this.keyword(ProtoTokenTypes.MAP);
                }
                case 91: {
                    continue block120;
                }
                case 33: {
                    return this.keyword(ProtoTokenTypes.MAX);
                }
                case 92: {
                    continue block120;
                }
                case 34: {
                    return this.keyword(ProtoTokenTypes.RPC);
                }
                case 93: {
                    continue block120;
                }
                case 35: {
                    return this.keyword(ProtoTokenTypes.ENUM);
                }
                case 94: {
                    continue block120;
                }
                case 36: {
                    return this.keyword(ProtoTokenTypes.TRUE);
                }
                case 95: {
                    continue block120;
                }
                case 37: {
                    return this.keyword(ProtoTokenTypes.WEAK);
                }
                case 96: {
                    continue block120;
                }
                case 38: {
                    return this.keyword(ProtoTokenTypes.GROUP);
                }
                case 97: {
                    continue block120;
                }
                case 39: {
                    return this.keyword(ProtoTokenTypes.LOCAL);
                }
                case 98: {
                    continue block120;
                }
                case 40: {
                    return this.keyword(ProtoTokenTypes.ONEOF);
                }
                case 99: {
                    continue block120;
                }
                case 41: {
                    return this.keyword(ProtoTokenTypes.EXPORT);
                }
                case 100: {
                    continue block120;
                }
                case 42: {
                    return this.keyword(ProtoTokenTypes.EXTEND);
                }
                case 101: {
                    continue block120;
                }
                case 43: {
                    return this.keyword(ProtoTokenTypes.IMPORT);
                }
                case 102: {
                    continue block120;
                }
                case 44: {
                    return this.keyword(ProtoTokenTypes.OPTION);
                }
                case 103: {
                    continue block120;
                }
                case 45: {
                    return this.keyword(ProtoTokenTypes.PUBLIC);
                }
                case 104: {
                    continue block120;
                }
                case 46: {
                    return this.keyword(ProtoTokenTypes.STREAM);
                }
                case 105: {
                    continue block120;
                }
                case 47: {
                    return this.keyword(ProtoTokenTypes.SYNTAX);
                }
                case 106: {
                    continue block120;
                }
                case 48: {
                    return this.keyword(ProtoTokenTypes.DEFAULT);
                }
                case 107: {
                    continue block120;
                }
                case 49: {
                    return this.keyword(ProtoTokenTypes.EDITION);
                }
                case 108: {
                    continue block120;
                }
                case 50: {
                    return this.keyword(ProtoTokenTypes.MESSAGE);
                }
                case 109: {
                    continue block120;
                }
                case 51: {
                    return this.keyword(ProtoTokenTypes.PACKAGE);
                }
                case 110: {
                    continue block120;
                }
                case 52: {
                    return this.keyword(ProtoTokenTypes.RETURNS);
                }
                case 111: {
                    continue block120;
                }
                case 53: {
                    return this.keyword(ProtoTokenTypes.SERVICE);
                }
                case 112: {
                    continue block120;
                }
                case 54: {
                    return this.keyword(ProtoTokenTypes.OPTIONAL);
                }
                case 113: {
                    continue block120;
                }
                case 55: {
                    return this.keyword(ProtoTokenTypes.REPEATED);
                }
                case 114: {
                    continue block120;
                }
                case 56: {
                    return this.keyword(ProtoTokenTypes.REQUIRED);
                }
                case 115: {
                    continue block120;
                }
                case 57: {
                    return this.keyword(ProtoTokenTypes.RESERVED);
                }
                case 116: {
                    continue block120;
                }
                case 58: {
                    return this.keyword(ProtoTokenTypes.JSON_NAME);
                }
                case 117: {
                    continue block120;
                }
                case 59: {
                    return this.keyword(ProtoTokenTypes.EXTENSIONS);
                }
                case 118: {
                    continue block120;
                }
            }
            this.zzScanError(1);
        }
    }
}

