/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input.run;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.handlers.DataInputCodeGenerationContext;
import com.intellij.jupyter.core.executor.cell.JupyterCellTask;
import com.intellij.jupyter.core.executor.kernel.JupyterKernelCellTask;
import com.intellij.jupyter.core.executor.task.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterTaskExecutorResult;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputPathWithVariableName;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputUtil;
import com.intellij.jupyter.core.jupyter.data.input.run.JupyterDataInputErrorMessageFactory;
import com.intellij.jupyter.core.jupyter.data.input.run.JupyterDataInputGenerateCodeTaskData;
import com.intellij.lang.Language;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.project.Project;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/run/JupyterDataInputCellTask;", "Lcom/intellij/jupyter/core/executor/task/JupyterExecutionTask;", "Lcom/intellij/jupyter/core/executor/cell/JupyterCellTask;", "data", "Lcom/intellij/jupyter/core/jupyter/data/input/run/JupyterDataInputGenerateCodeTaskData;", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/data/input/run/JupyterDataInputGenerateCodeTaskData;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/openapi/project/Project;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;)V", "getData", "()Lcom/intellij/jupyter/core/jupyter/data/input/run/JupyterDataInputGenerateCodeTaskData;", "getCellPointer", "()Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "doExecuteTask", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterTaskExecutorResult;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generateCode", "", "showError", "text", "notebookLanguage", "Lcom/intellij/lang/Language;", "intellij.jupyter.core"})
public final class JupyterDataInputCellTask
extends JupyterExecutionTask
implements JupyterCellTask {
    @NotNull
    private final JupyterDataInputGenerateCodeTaskData data;
    @NotNull
    private final NotebookIntervalPointer cellPointer;

    public JupyterDataInputCellTask(@NotNull JupyterDataInputGenerateCodeTaskData data, @NotNull BackedNotebookVirtualFile notebookVirtualFile2, @NotNull Project project, @NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile2, (String)"notebookVirtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        super(notebookVirtualFile2, project, null, 4, null);
        this.data = data;
        this.cellPointer = cellPointer;
    }

    @NotNull
    public final JupyterDataInputGenerateCodeTaskData getData() {
        return this.data;
    }

    @Override
    @NotNull
    public NotebookIntervalPointer getCellPointer() {
        return this.cellPointer;
    }

    @Override
    @Nullable
    public Object doExecuteTask(@NotNull CoroutineScope scope, @NotNull Continuation<? super JupyterTaskExecutorResult> $completion) {
        Project project = this.getProject();
        if (project == null) {
            return JupyterTaskExecutorResult.Aborted.INSTANCE;
        }
        Project project2 = project;
        String codeToExec = this.generateCode();
        return new JupyterKernelCellTask(this.getCellPointer(), this.getNotebookVirtualFile(), project2, codeToExec, null, 16, null).doExecuteTask(scope, $completion);
    }

    @VisibleForTesting
    @NotNull
    public final String generateCode() {
        Path path;
        Project project = this.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        Language language = this.getNotebookVirtualFile().getNotebook().getLanguage();
        String notebookRelativedFilePath = this.data.getMetadata().getNotebookRelativedFilePath();
        String errorCode = this.showError("unknown file '" + notebookRelativedFilePath + "'", language);
        CharSequence charSequence = notebookRelativedFilePath;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return errorCode;
        }
        try {
            JupyterDataInputCellMetadata jupyterDataInputCellMetadata = this.data.getMetadata();
            Path path2 = this.getNotebookVirtualFile().getFile().toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
            path = jupyterDataInputCellMetadata.getFilePath(path2);
            if (path == null) {
                return errorCode;
            }
        }
        catch (InvalidPathException invalidPathException) {
            return errorCode;
        }
        Path fullPath = path;
        List<String> cells = JupyterDataInputUtil.INSTANCE.generateCells(this.getNotebookVirtualFile(), project2, CollectionsKt.listOf((Object)new JupyterDataInputPathWithVariableName(fullPath, this.data.getMetadata().getVariableName())), DataInputCodeGenerationContext.FOR_EXECUTION);
        String string = (String)CollectionsKt.singleOrNull(cells);
        if (string == null) {
            string = errorCode;
        }
        return string;
    }

    private final String showError(String text, Language notebookLanguage) {
        String string = JupyterDataInputErrorMessageFactory.Companion.makeErrorMessage(text, notebookLanguage);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }
}

