/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.bool.ComparisonPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSFlipComparisonIntention
extends JSMutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        JSBinaryExpression exp = (JSBinaryExpression)element;
        String operatorText = null;
        String flippedOperatorText = null;
        if (exp != null) {
            operatorText = ComparisonUtils.getOperatorText((IElementType)exp.getOperationSign());
            flippedOperatorText = ComparisonUtils.getFlippedOperatorText((IElementType)exp.getOperationSign());
        }
        if (exp == null) {
            return JSIntentionBundle.message("bool.flip-comparison.display-name.unknown", new Object[0]);
        }
        if (operatorText.equals(flippedOperatorText)) {
            return JSIntentionBundle.message("bool.flip-comparison.display-name.equals", operatorText);
        }
        return JSIntentionBundle.message("bool.flip-comparison.display-name.not-equals", operatorText, flippedOperatorText);
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("bool.flip-comparison.family-name", new Object[0]);
        if (string == null) {
            JSFlipComparisonIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new ComparisonPredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSFlipComparisonIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSFlipComparisonIntention.$$$reportNull$$$0(2);
        }
        JSBinaryExpression exp = (JSBinaryExpression)element;
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        IElementType sign = exp.getOperationSign();
        assert (rhs != null);
        String expString = rhs.getText() + ComparisonUtils.getFlippedOperatorText((IElementType)sign) + lhs.getText();
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)expString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/bool/JSFlipComparisonIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/bool/JSFlipComparisonIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

