/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.inspections.JSDeclarationsAtScopeStartInspection;
import com.intellij.lang.javascript.inspections.JSVariablesWithInitializerPredicate;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariableDeclaringScope;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.initialization.JSSplitDeclarationAndInitializationIntention;
import org.jetbrains.annotations.NotNull;

public final class JSSplitDeclarationAndMoveToScopeStartIntention
extends JSSplitDeclarationAndInitializationIntention {
    private static final JSElementPredicate PREDICATE = new JSVariablesWithInitializerPredicate(){

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!super.satisfiedBy(element)) {
                return false;
            }
            if (((JSVarStatement)element).getVarKeyword() != JSVarStatement.VarKeyword.VAR) {
                return false;
            }
            JSFunction scope = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
            return scope != null && JSPsiImplUtils.findFirstFunctionStatement((JSFunction)scope) != element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndMoveToScopeStartIntention$1", "satisfiedBy"));
        }
    };

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = PREDICATE;
        if (jSElementPredicate == null) {
            JSSplitDeclarationAndMoveToScopeStartIntention.$$$reportNull$$$0(0);
        }
        return jSElementPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        return JSIntentionBundle.message("initialization.split-declaration-and-move-to-scope-start.display-name", new Object[0]);
    }

    @Override
    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("initialization.split-declaration-and-move-to-scope-start.family-name", new Object[0]);
        if (string == null) {
            JSSplitDeclarationAndMoveToScopeStartIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void doReplacement(String declarations, List<String> initializations, JSVarStatement oldVarStatement) {
        JSStatement newStatement = JSPsiElementFactory.createJSStatement((String)declarations, (PsiElement)oldVarStatement);
        JSStatement newStatementAnchor = JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement((PsiElement)oldVarStatement);
        if (newStatementAnchor == null) {
            newStatementAnchor = oldVarStatement;
        }
        newStatement = newStatementAnchor.getParent().addBefore((PsiElement)newStatement, (PsiElement)newStatementAnchor);
        PsiElement parent = oldVarStatement.getParent();
        if (parent instanceof JSVariableDeclaringScope) {
            PsiElement newElement = JSSplitDeclarationAndMoveToScopeStartIntention.createForParent(oldVarStatement, parent, initializations);
            oldVarStatement.replace(newElement);
            return;
        }
        int startOffset = newStatement.getTextOffset();
        JSStatement assignmentStatement = null;
        boolean first = true;
        for (String initialization : initializations) {
            if (first) {
                first = false;
                JSStatement newInitializer = JSPsiElementFactory.createJSStatement((String)initialization, (PsiElement)newStatement);
                assignmentStatement = oldVarStatement.replace(newInitializer);
                continue;
            }
            assignmentStatement = assignmentStatement.addStatementAfter(JSPsiElementFactory.createJSStatement((String)initialization, (PsiElement)newStatement));
        }
        if (assignmentStatement == null) {
            return;
        }
        int endOffset = assignmentStatement.getTextOffset() + assignmentStatement.getTextLength();
        if (PsiDocumentManager.getInstance((Project)newStatement.getProject()).getDocument(newStatement.getContainingFile()) != null) {
            CodeStyleManager.getInstance((Project)newStatement.getProject()).reformatText(newStatement.getContainingFile(), startOffset, endOffset);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndMoveToScopeStartIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

