/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.BeforeCheckinDialogHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.VcsCheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.actions.RevertAllUnchangedFilesAction;
import org.jetbrains.idea.perforce.actions.ShelfUtils;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.ShelvedChange;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

public class PerforceCheckinHandlerFactory
extends VcsCheckinHandlerFactory {
    public PerforceCheckinHandlerFactory() {
        super(PerforceVcs.getKey());
    }

    @NotNull
    protected CheckinHandler createVcsHandler(final @NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        if (panel == null) {
            PerforceCheckinHandlerFactory.$$$reportNull$$$0(0);
        }
        if (commitContext == null) {
            PerforceCheckinHandlerFactory.$$$reportNull$$$0(1);
        }
        final Project project = panel.getProject();
        return new CheckinHandler(this){

            public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
                return BooleanCommitOption.create((Project)project, (CheckinHandler)this, (boolean)false, (String)PerforceBundle.message("message.revert.unchanged.files", new Object[0]), () -> PerforceSettings.getSettings((Project)project2).REVERT_UNCHANGED_FILES_CHECKIN, value -> {
                    PerforceSettings.getSettings((Project)project2).REVERT_UNCHANGED_FILES_CHECKIN = value;
                });
            }

            public RefreshableOnComponent getAfterCheckinConfigurationPanel(Disposable parentDisposable) {
                if (panel.getCommitWorkflowHandler().getExecutor("Perforce.Shelf.Executor") == null) {
                    return null;
                }
                return BooleanCommitOption.create((Project)project, (CheckinHandler)this, (boolean)false, (String)PerforceBundle.message("checkbox.revert.files.after.shelf", new Object[0]), () -> PerforceSettings.getSettings((Project)project2).REVERT_FILES_AFTER_SHELF, value -> {
                    PerforceSettings.getSettings((Project)project2).REVERT_FILES_AFTER_SHELF = value;
                });
            }

            public CheckinHandler.ReturnResult beforeCheckin() {
                if (PerforceSettings.getSettings((Project)project).REVERT_UNCHANGED_FILES_CHECKIN) {
                    RevertAllUnchangedFilesAction.revertUnchanged(project, panel.getVirtualFiles(), panel, null);
                }
                MultiMap map = MultiMap.create();
                for (Change change : panel.getSelectedChanges()) {
                    LocalChangeList list = ChangeListManager.getInstance((Project)project).getChangeList(change);
                    if (list == null) continue;
                    map.putValue((Object)list, (Object)change);
                }
                for (LocalChangeList list : map.keySet()) {
                    List<ShelvedChange> shelvedChanges = PerforceManager.getInstance(project).getShelf().getShelvedChanges(list);
                    if (shelvedChanges.isEmpty()) continue;
                    String message = PerforceBundle.message("changelist.has.shelved.changes", list.getName());
                    int rc = Messages.showYesNoDialog((Project)project, (String)message, (String)PerforceBundle.message("changelist.shelved.changes.found", new Object[0]), (String)PerforceBundle.message("changelist.remove.shelved.changes", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon());
                    if (rc == 1) {
                        return CheckinHandler.ReturnResult.CANCEL;
                    }
                    ShelfUtils.deleteFromShelf(shelvedChanges, project);
                }
                return super.beforeCheckin();
            }
        };
    }

    public BeforeCheckinDialogHandler createSystemReadyHandler(@NotNull Project project) {
        if (project == null) {
            PerforceCheckinHandlerFactory.$$$reportNull$$$0(2);
        }
        return new MyBeforeCheckinDialogHandler();
    }

    public static boolean beforeRemoteOperationCheck(Project project, String operationName) {
        int result;
        PerforceSettings settings = PerforceSettings.getSettings(project);
        if (!settings.ENABLED && 0 == (result = Messages.showYesNoDialog((Project)project, (String)PerforceBundle.message("connection.offline.go.online", operationName), (String)PerforceBundle.message("connection.offline.title", new Object[0]), (Icon)Messages.getWarningIcon()))) {
            settings.enable();
        }
        boolean allOk = PerforceLoginManager.getInstance(project).checkAndRepairAll();
        return ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss().length > 1 || allOk && settings.ENABLED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceCheckinHandlerFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVcsHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createSystemReadyHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyBeforeCheckinDialogHandler
    extends BeforeCheckinDialogHandler {
        private MyBeforeCheckinDialogHandler() {
        }

        public boolean beforeCommitDialogShown(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull Iterable<? extends CommitExecutor> executors, boolean showVcsCommit) {
            if (project == null) {
                MyBeforeCheckinDialogHandler.$$$reportNull$$$0(0);
            }
            if (changes == null) {
                MyBeforeCheckinDialogHandler.$$$reportNull$$$0(1);
            }
            if (executors == null) {
                MyBeforeCheckinDialogHandler.$$$reportNull$$$0(2);
            }
            if (showVcsCommit) {
                return PerforceCheckinHandlerFactory.beforeRemoteOperationCheck(project, "Commit");
            }
            for (CommitExecutor commitExecutor : executors) {
                if (commitExecutor instanceof LocalCommitExecutor) continue;
                return PerforceCheckinHandlerFactory.beforeRemoteOperationCheck(project, "Commit");
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executors";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/perforce/application/PerforceCheckinHandlerFactory$MyBeforeCheckinDialogHandler";
            objectArray[2] = "beforeCommitDialogShown";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

