/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.collections.visualizer.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/debugger/collections/visualizer/jvm/DebuggerExpression;", "", "methodName", "", "signature", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getMethodName", "()Ljava/lang/String;", "getSignature", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.debugger.collections.visualizer.jvm"})
@ApiStatus.Experimental
public final class DebuggerExpression {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String methodName;
    @NotNull
    private final String signature;
    @NotNull
    private static final DebuggerExpression TO_ARRAY = new DebuggerExpression("toArray", "()[Ljava/lang/Object;");

    public DebuggerExpression(@NotNull String methodName, @NotNull String signature) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.methodName = methodName;
        this.signature = signature;
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    @NotNull
    public final String getSignature() {
        return this.signature;
    }

    @NotNull
    public final String component1() {
        return this.methodName;
    }

    @NotNull
    public final String component2() {
        return this.signature;
    }

    @NotNull
    public final DebuggerExpression copy(@NotNull String methodName, @NotNull String signature) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        return new DebuggerExpression(methodName, signature);
    }

    public static /* synthetic */ DebuggerExpression copy$default(DebuggerExpression debuggerExpression, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = debuggerExpression.methodName;
        }
        if ((n & 2) != 0) {
            string2 = debuggerExpression.signature;
        }
        return debuggerExpression.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "DebuggerExpression(methodName=" + this.methodName + ", signature=" + this.signature + ")";
    }

    public int hashCode() {
        int result = this.methodName.hashCode();
        result = result * 31 + this.signature.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DebuggerExpression)) {
            return false;
        }
        DebuggerExpression debuggerExpression = (DebuggerExpression)other;
        if (!Intrinsics.areEqual((Object)this.methodName, (Object)debuggerExpression.methodName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.signature, (Object)debuggerExpression.signature);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/debugger/collections/visualizer/jvm/DebuggerExpression$Companion;", "", "<init>", "()V", "TO_ARRAY", "Lcom/intellij/debugger/collections/visualizer/jvm/DebuggerExpression;", "getTO_ARRAY", "()Lcom/intellij/debugger/collections/visualizer/jvm/DebuggerExpression;", "intellij.debugger.collections.visualizer.jvm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DebuggerExpression getTO_ARRAY() {
            return TO_ARRAY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

