/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.functional.webClient;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/intellij/spring/mvc/functional/webClient/WebClientUrl;", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "myUriPresentation", "", "myHttpMethod", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Ljava/lang/String;)V", "myElementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getPsiElement", "()Lcom/intellij/psi/PsiElement;", "isValid", "", "()Z", "uriPresentation", "getUriPresentation", "()Ljava/lang/String;", "httpMethod", "getHttpMethod", "equals", "other", "hashCode", "", "intellij.spring.mvc.impl"})
public final class WebClientUrl {
    @NotNull
    private final String myUriPresentation;
    @Nullable
    private final String myHttpMethod;
    @NotNull
    private final SmartPsiElementPointer<PsiElement> myElementPointer;

    public WebClientUrl(@NotNull PsiElement psiElement, @NotNull String myUriPresentation, @Nullable String myHttpMethod) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)myUriPresentation, (String)"myUriPresentation");
        this.myUriPresentation = myUriPresentation;
        this.myHttpMethod = myHttpMethod;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)psiElement.getProject()).createSmartPsiElementPointer(psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        this.myElementPointer = smartPsiElementPointer;
    }

    @NotNull
    public final PsiElement getPsiElement() {
        PsiElement psiElement = this.myElementPointer.getElement();
        if (psiElement == null) {
            throw new PsiInvalidElementAccessException(null, "Pointer hasn't survive");
        }
        return psiElement;
    }

    public final boolean isValid() {
        return this.myElementPointer.getElement() != null;
    }

    @NotNull
    public final String getUriPresentation() {
        return this.myUriPresentation;
    }

    @Nullable
    public final String getHttpMethod() {
        return this.myHttpMethod;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WebClientUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.myUriPresentation, (Object)((WebClientUrl)other).myUriPresentation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.myHttpMethod, (Object)((WebClientUrl)other).myHttpMethod)) {
            return false;
        }
        return Intrinsics.areEqual(this.myElementPointer, ((WebClientUrl)other).myElementPointer);
    }

    public int hashCode() {
        int result = this.myUriPresentation.hashCode();
        String string = this.myHttpMethod;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        result = 31 * result + this.myElementPointer.hashCode();
        return result;
    }
}

