/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.functional.webClient;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.microservices.jvm.cache.ScopedCacheValueHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0000\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0000\u001a&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0014H\u0002\u00a8\u0006\u0018"}, d2={"isFunctionalWebClientAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "isWebTestClientAvailable", "getFunctionalClientUrlApiMethods", "", "Lcom/intellij/psi/PsiMethod;", "getFunctionalApiClasses", "Lcom/intellij/psi/PsiClass;", "query", "Lcom/intellij/microservices/jvm/cache/ScopedCacheValueHolder;", "getWebTestClientUrlApiMethods", "getWebTestClientApiClasses", "findApiClasses", "webClientSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "clientApiSpec", "", "findUrlMethods", "apiSearchScope", "specClassName", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nWebClientUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebClientUtils.kt\ncom/intellij/spring/mvc/functional/webClient/WebClientUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,84:1\n3919#2:85\n4434#2,2:86\n*S KotlinDebug\n*F\n+ 1 WebClientUtils.kt\ncom/intellij/spring/mvc/functional/webClient/WebClientUtilsKt\n*L\n79#1:85\n79#1:86,2\n*E\n"})
public final class WebClientUtilsKt {
    public static final boolean isFunctionalWebClientAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"org.springframework.web.reactive.function.client.WebClient");
    }

    public static final boolean isFunctionalWebClientAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"org.springframework.web.reactive.function.client.WebClient");
    }

    public static final boolean isWebTestClientAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"org.springframework.test.web.reactive.server.WebTestClient");
    }

    public static final boolean isWebTestClientAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"org.springframework.test.web.reactive.server.WebTestClient");
    }

    @NotNull
    public static final List<PsiMethod> getFunctionalClientUrlApiMethods(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> WebClientUtilsKt.getFunctionalClientUrlApiMethods$lambda$0(project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @NotNull
    public static final List<PsiClass> getFunctionalApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return (List)query.getCachedValue(() -> WebClientUtilsKt.getFunctionalApiClasses$lambda$0(query));
    }

    @NotNull
    public static final List<PsiMethod> getWebTestClientUrlApiMethods(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> WebClientUtilsKt.getWebTestClientUrlApiMethods$lambda$0(project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @NotNull
    public static final List<PsiClass> getWebTestClientApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return (List)query.getCachedValue(() -> WebClientUtilsKt.getWebTestClientApiClasses$lambda$0(query));
    }

    private static final List<PsiClass> findApiClasses(Project project, GlobalSearchScope webClientSearchScope, String clientApiSpec) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass[] psiClassArray = javaPsiFacade.findClasses(clientApiSpec, webClientSearchScope);
        return CollectionsKt.mutableListOf((Object[])Arrays.copyOf(psiClassArray, psiClassArray.length));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PsiMethod> findUrlMethods(Project project, GlobalSearchScope apiSearchScope, String specClassName) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        Function1 stringReceiverMethod = WebClientUtilsKt::findUrlMethods$lambda$0;
        List methods = new ArrayList();
        PsiClass[] psiClassArray = javaPsiFacade.findClasses(specClassName, apiSearchScope);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"findClasses(...)");
        for (PsiClass httpUrlClass : psiClassArray) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            PsiMethod[] psiMethodArray = httpUrlClass.findMethodsByName("uri", true);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
            Object[] objectArray = psiMethodArray;
            List list = methods;
            boolean $i$f$filter = false;
            void var12_12 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)stringReceiverMethod.invoke((Object)element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list.addAll((List)destination$iv$iv);
        }
        return methods;
    }

    private static final CachedValueProvider.Result getFunctionalClientUrlApiMethods$lambda$0(Project $project) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        List<PsiMethod> methods = WebClientUtilsKt.findUrlMethods($project, globalSearchScope, "org.springframework.web.reactive.function.client.WebClient.UriSpec");
        return CachedValueProvider.Result.createSingleDependency(methods, (Object)JavaLibraryModificationTracker.getInstance((Project)$project));
    }

    private static final CachedValueProvider.Result getFunctionalApiClasses$lambda$0(ScopedCacheValueHolder $query) {
        List<PsiClass> classes = WebClientUtilsKt.findApiClasses($query.getProject(), $query.getApiSearchScope(), "org.springframework.web.reactive.function.client.WebClient.UriSpec");
        return CachedValueProvider.Result.createSingleDependency(classes, (Object)JavaLibraryModificationTracker.getInstance((Project)$query.getProject()));
    }

    private static final CachedValueProvider.Result getWebTestClientUrlApiMethods$lambda$0(Project $project) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        List<PsiMethod> methods = WebClientUtilsKt.findUrlMethods($project, globalSearchScope, "org.springframework.test.web.reactive.server.WebTestClient.UriSpec");
        return CachedValueProvider.Result.createSingleDependency(methods, (Object)JavaLibraryModificationTracker.getInstance((Project)$project));
    }

    private static final CachedValueProvider.Result getWebTestClientApiClasses$lambda$0(ScopedCacheValueHolder $query) {
        List<PsiClass> classes = WebClientUtilsKt.findApiClasses($query.getProject(), $query.getApiSearchScope(), "org.springframework.test.web.reactive.server.WebTestClient.UriSpec");
        return CachedValueProvider.Result.createSingleDependency(classes, (Object)JavaLibraryModificationTracker.getInstance((Project)$query.getProject()));
    }

    private static final boolean findUrlMethods$lambda$0(PsiMethod it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.hasParameters() && TypeUtils.isJavaLangString((PsiType)it.getParameterList().getParameters()[0].getType());
    }
}

