/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model.xml;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourcesLocationConverter
extends DelimitedListConverter<PsiFileSystemItem> {
    private static final Condition<PsiFileSystemItem> DIRECTORY_CONDITION = item -> item.isDirectory();

    public ResourcesLocationConverter() {
        super(", ");
    }

    @Nullable
    protected PsiFileSystemItem convertString(@Nullable String string, @NotNull ConvertContext context) {
        if (context == null) {
            ResourcesLocationConverter.$$$reportNull$$$0(0);
        }
        if (string == null) {
            return null;
        }
        PsiReference[] references = ResourcesLocationConverter.getReferences(string, context);
        if (references.length <= 0) {
            return null;
        }
        for (int i = references.length - 1; i >= 0; --i) {
            FileReference fileReference = FileReference.findFileReference((PsiReference)references[i]);
            if (fileReference == null) continue;
            FileReference lastFileReference = fileReference.getLastFileReference();
            if (lastFileReference == null) {
                return null;
            }
            PsiFileSystemItem result = lastFileReference.resolve();
            if (result == null) continue;
            return DIRECTORY_CONDITION.value((Object)result) ? result : null;
        }
        return null;
    }

    @Nullable
    protected String toString(@Nullable PsiFileSystemItem item) {
        return item == null ? null : item.getName();
    }

    protected Object[] getReferenceVariants(@NotNull ConvertContext context, GenericDomValue<? extends List<PsiFileSystemItem>> genericDomValue) {
        if (context == null) {
            ResourcesLocationConverter.$$$reportNull$$$0(1);
        }
        String text = genericDomValue.getStringValue();
        ArrayList variants = new ArrayList();
        for (PsiReference reference : ResourcesLocationConverter.getReferences(text, context)) {
            ContainerUtil.addAll(variants, (Object[])reference.getVariants());
        }
        return ArrayUtil.toObjectArray(variants);
    }

    @Nullable
    protected PsiElement resolveReference(@Nullable PsiFileSystemItem item, @NotNull ConvertContext context) {
        if (context == null) {
            ResourcesLocationConverter.$$$reportNull$$$0(2);
        }
        return item;
    }

    protected String getUnresolvedMessage(String value) {
        return SpringMvcBundle.message("resource.location.unresolved.message", value);
    }

    private static PsiReference[] getReferences(@Nullable String string, ConvertContext context) {
        if (string == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        XmlElement element = context.getXmlElement();
        if (element == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)element, (String)string).filter(DIRECTORY_CONDITION).endingSlashNotAllowed(false);
        return SpringResourcesUtil.getInstance().getReferences(builder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "context";
        objectArray2[1] = "com/intellij/spring/mvc/model/xml/ResourcesLocationConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "convertString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

