/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.toolwindow;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.documentation.ide.DocumentationUtil;
import com.intellij.lang.documentation.ide.ui.DocumentationComponent;
import com.intellij.lang.documentation.psi.UtilKt;
import com.intellij.model.Pointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.toolwindow.SpringMvcViewSettings;
import com.intellij.spring.mvc.toolwindow.SpringMvcViewUtils;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMvcRequestMappingsPanel
extends FinderRecursivePanel<UrlMappingElement> {
    private final SpringBeanPointer<?> myControllerSpringBeanPointer;
    private final NotNullLazyValue<Set<Module>> myModules;
    private DocumentationComponent myDocumentationComponent;

    public SpringMvcRequestMappingsPanel(@NotNull Project project, @NotNull SpringBeanPointer<?> controllerSpringBeanPointer) {
        if (project == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(0);
        }
        if (controllerSpringBeanPointer == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(1);
        }
        super(project, null);
        this.myModules = NotNullLazyValue.lazy(() -> this.getModules());
        this.setNonBlockingLoad(true);
        this.myControllerSpringBeanPointer = controllerSpringBeanPointer;
    }

    private Set<Module> getModules() {
        PsiFile controllerFile = this.myControllerSpringBeanPointer.getContainingFile();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)controllerFile);
        return SpringMvcRequestMappingsPanel.getRelevantModules(module);
    }

    private static Set<Module> getRelevantModules(Module module) {
        HashSet<Module> modules = new HashSet<Module>();
        ModuleUtilCore.visitMeAndDependentModules((Module)module, module1 -> {
            if (SpringCommonUtils.isSpringConfigured((Module)module)) {
                modules.add(module1);
            }
            return true;
        });
        return modules;
    }

    protected JComponent createLeftComponent() {
        JComponent component = super.createLeftComponent();
        if (component instanceof ListWithFilter) {
            ListWithFilter list = (ListWithFilter)component;
            list.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        }
        return component;
    }

    @NotNull
    protected List<UrlMappingElement> getListItems() {
        Module module;
        ArrayList<UrlMappingElement> items = new ArrayList<UrlMappingElement>();
        Set<RequestMethod> requestMethods = SpringMvcViewSettings.getInstance(this.getProject()).getRequestMethods();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(items);
        Iterator iterator = ((Set)this.myModules.get()).iterator();
        while (iterator.hasNext() && SpringMvcViewUtils.processUrls(module = (Module)iterator.next(), this.myControllerSpringBeanPointer, requestMethods, (Processor<? super UrlMappingElement>)processor)) {
        }
        items.sort((item, item2) -> item.getPresentation().compareToIgnoreCase(item2.getPresentation()));
        ArrayList<UrlMappingElement> arrayList = items;
        if (arrayList == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    protected void doCustomizeCellRenderer(@NotNull SimpleColoredComponent comp, @NotNull JList list, @NotNull UrlMappingElement value, int index, boolean selected, boolean hasFocus) {
        if (comp == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(3);
        }
        if (list == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(4);
        }
        if (value == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(5);
        }
        comp.clear();
        comp.setIcon(this.getItemIcon(value));
        comp.append(UrlMappingElement.getPathPresentation(value), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        String requestMethodPresentation = UrlMappingElement.getRequestMethodPresentation(value);
        if (requestMethodPresentation != null) {
            comp.append(" " + requestMethodPresentation, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
    }

    @NotNull
    protected String getItemText(@NotNull UrlMappingElement item) {
        if (item == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(6);
        }
        String string = UrlMappingElement.getPathPresentation(item) + " " + StringUtil.notNullize((String)UrlMappingElement.getContainingFileName(item)) + " " + StringUtil.notNullize((String)UrlMappingElement.getRequestMethodPresentation(item));
        if (string == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(@NotNull UrlMappingElement item) {
        if (item == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(8);
        }
        return SpringApiIcons.RequestMapping;
    }

    protected boolean hasChildren(@NotNull UrlMappingElement item) {
        if (item == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(9);
        }
        return false;
    }

    @Nullable
    protected VirtualFile getContainingFile(@NotNull UrlMappingElement item) {
        PsiElement psiElement;
        if (item == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(10);
        }
        return (psiElement = item.getNavigationTarget()) == null ? null : psiElement.getContainingFile().getVirtualFile();
    }

    protected boolean performEditAction() {
        UrlMappingElement value = (UrlMappingElement)this.getSelectedValue();
        if (value == null) {
            return true;
        }
        PsiElement element = value.getNavigationTarget();
        if (element != null) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)element);
        }
        return true;
    }

    protected AnAction[] getCustomListActions() {
        final SpringMvcViewSettings settings = SpringMvcViewSettings.getInstance(this.getProject());
        return new AnAction[]{new RequestMethodActionGroup(this.getProject(), settings), new ToggleAction(SpringMvcBundle.message("SpringMvcView.designer.properties.show.javadoc", new Object[0]), null, AllIcons.Toolwindows.Documentation){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                return settings.isShowDoc();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                settings.setShowDoc(state);
                SpringMvcViewSettings.fireSettingsChanged(SpringMvcRequestMappingsPanel.this.getProject(), SpringMvcViewSettings.ChangeType.UPDATE_DETAILS);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/mvc/toolwindow/SpringMvcRequestMappingsPanel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/mvc/toolwindow/SpringMvcRequestMappingsPanel$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }};
    }

    protected JComponent createDefaultRightComponent() {
        if (!this.isShowDoc()) {
            return null;
        }
        return super.createDefaultRightComponent();
    }

    @Nullable
    protected JComponent createRightComponent(@NotNull UrlMappingElement item) {
        if (item == null) {
            SpringMvcRequestMappingsPanel.$$$reportNull$$$0(11);
        }
        if (!this.isShowDoc() || this.isDisposed()) {
            return null;
        }
        FinderRecursivePanel.DisposablePanel panel = new FinderRecursivePanel.DisposablePanel((LayoutManager)new BorderLayout(), (Disposable)this);
        ReadAction.nonBlocking(() -> {
            PsiElement element = item.getDocumentationPsiElement();
            if (element == null) {
                return null;
            }
            DocumentationTarget target = (DocumentationTarget)UtilKt.psiDocumentationTargets((PsiElement)element, null).get(0);
            return Pair.create((Object)target.createPointer(), (Object)target.computePresentation());
        }).finishOnUiThread(ModalityState.any(), pair -> {
            if (pair != null && !this.isDisposed()) {
                if (this.myDocumentationComponent == null) {
                    this.myDocumentationComponent = DocumentationUtil.documentationComponent((Project)this.getProject(), (Pointer)((Pointer)pair.first), (TargetPresentation)((TargetPresentation)pair.second), (Disposable)this);
                } else {
                    this.myDocumentationComponent.resetBrowser((Pointer)pair.first, (TargetPresentation)pair.second);
                }
                Disposer.register((Disposable)panel, () -> this.myDocumentationComponent.resetBrowser());
                panel.add((Component)this.myDocumentationComponent.getComponent(), (Object)"Center");
            }
        }).coalesceBy(new Object[]{this}).inSmartMode(this.getProject()).expireWith((Disposable)panel).submit((Executor)AppExecutorUtil.getAppExecutorService());
        return panel;
    }

    private boolean isShowDoc() {
        return SpringMvcViewSettings.getInstance(this.getProject()).isShowDoc();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllerSpringBeanPointer";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/toolwindow/SpringMvcRequestMappingsPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/toolwindow/SpringMvcRequestMappingsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCustomizeCellRenderer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getItemText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRightComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7 -> new IllegalStateException(string);
        };
    }

    private static final class RequestMethodActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        private RequestMethodActionGroup(final @NotNull Project project, final SpringMvcViewSettings settings) {
            if (project == null) {
                RequestMethodActionGroup.$$$reportNull$$$0(0);
            }
            this.setPopup(true);
            this.getTemplatePresentation().setText(SpringMvcBundle.message("SpringMvcView.request.method", new Object[0]));
            this.getTemplatePresentation().setIcon(AllIcons.Nodes.Method);
            for (final RequestMethod method : RequestMethod.values()) {
                @NlsSafe String name = method.name();
                this.add((AnAction)new ToggleAction(this, name){

                    public boolean isSelected(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return settings.getRequestMethods().contains((Object)method);
                    }

                    public void setSelected(@NotNull AnActionEvent e, boolean state) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (state) {
                            settings.getRequestMethods().add(method);
                        } else {
                            settings.getRequestMethods().remove((Object)method);
                        }
                        SpringMvcViewSettings.fireSettingsChanged(project, SpringMvcViewSettings.ChangeType.UPDATE_LIST);
                    }

                    @NotNull
                    public ActionUpdateThread getActionUpdateThread() {
                        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                        if (actionUpdateThread == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return actionUpdateThread;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 2 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "e";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/spring/mvc/toolwindow/SpringMvcRequestMappingsPanel$RequestMethodActionGroup$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/spring/mvc/toolwindow/SpringMvcRequestMappingsPanel$RequestMethodActionGroup$1";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getActionUpdateThread";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "isSelected";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "setSelected";
                                break;
                            }
                            case 2: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 2 -> new IllegalStateException(string);
                        };
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/mvc/toolwindow/SpringMvcRequestMappingsPanel$RequestMethodActionGroup", "<init>"));
        }
    }
}

