/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.views.resolvers;

import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.mvc.services.SpringMvcUtils;
import com.intellij.spring.mvc.views.BeanNameViewResolverFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XmlViewResolver
extends BeanNameViewResolverFactory.BeanNameViewResolver {
    private final String myLocation;

    public XmlViewResolver(@NotNull Module module, CommonSpringBean bean) {
        if (module == null) {
            XmlViewResolver.$$$reportNull$$$0(0);
        }
        super(module, "XmlViewResolver[" + bean.getBeanName() + "]");
        String location = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"location");
        this.myLocation = location == null ? "/WEB-INF/views.xml" : location;
    }

    @Override
    @NotNull
    protected Collection<SpringModel> getModels() {
        HashSet<SpringModel> models = new HashSet<SpringModel>();
        for (WebDirectoryElement element : SpringMvcUtils.findWebDirectoryElements(this.myLocation, this.getModule())) {
            PsiFile file = element.getOriginalFile();
            if (!(file instanceof XmlFile)) {
                List<SpringModel> list = Collections.emptyList();
                if (list == null) {
                    XmlViewResolver.$$$reportNull$$$0(1);
                }
                return list;
            }
            ContainerUtil.addIfNotNull(models, (Object)SpringManager.getInstance((Project)file.getProject()).getSpringModelByFile(file));
        }
        HashSet<SpringModel> hashSet = models;
        if (hashSet == null) {
            XmlViewResolver.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/views/resolvers/XmlViewResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/views/resolvers/XmlViewResolver";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

