/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.environment;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterTaskExecutorResult;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutine;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.variables.common.JupyterEnvironmentUpdateListener;
import com.intellij.jupyter.py.environment.stores.JupyterEnvironmentStore;
import com.intellij.jupyter.py.environment.stores.JupyterStandaloneVariablesViewStore;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleService;
import com.intellij.jupyter.py.variables.inline.JupyterRuntimeInlineValuesHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.debugger.PyFrameAccessor;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001a\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\fJ\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#J\b\u0010$\u001a\u00020\fH\u0002J\u0012\u0010%\u001a\u00020\f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00138BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00178BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lcom/intellij/jupyter/py/environment/PythonNotebookEnvironmentStateManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "backedNotebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "triggerFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "realNotebookVirtualFile", "variablesViewStore", "Lcom/intellij/jupyter/py/environment/stores/JupyterStandaloneVariablesViewStore;", "environmentStore", "Lcom/intellij/jupyter/py/environment/stores/JupyterEnvironmentStore;", "jupyterEditor", "Lcom/intellij/openapi/editor/Editor;", "getJupyterEditor", "()Lcom/intellij/openapi/editor/Editor;", "runtimeInlineValuesHandler", "Lcom/intellij/jupyter/py/variables/inline/JupyterRuntimeInlineValuesHandler;", "getRuntimeInlineValuesHandler", "()Lcom/intellij/jupyter/py/variables/inline/JupyterRuntimeInlineValuesHandler;", "sessionDeleted", "taskStopped", "executorResult", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterTaskExecutorResult;", "debugStart", "updateDebugEnvironmentState", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "newValues", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "updateRuntimeEnvironmentState", "publishUpdate", "intellij.jupyter.py"})
public final class PythonNotebookEnvironmentStateManager {
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile backedNotebookVirtualFile;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final MutableSharedFlow<Unit> triggerFlow;
    @NotNull
    private final BackedNotebookVirtualFile realNotebookVirtualFile;
    @NotNull
    private final JupyterStandaloneVariablesViewStore variablesViewStore;
    @NotNull
    private final JupyterEnvironmentStore environmentStore;
    @Nullable
    private Editor jupyterEditor;
    @Nullable
    private JupyterRuntimeInlineValuesHandler runtimeInlineValuesHandler;

    public PythonNotebookEnvironmentStateManager(@NotNull Project project, @NotNull BackedNotebookVirtualFile backedNotebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)backedNotebookVirtualFile, (String)"backedNotebookVirtualFile");
        this.project = project;
        this.backedNotebookVirtualFile = backedNotebookVirtualFile;
        this.scope = CoroutineScopeKt.childScope$default((CoroutineScope)JupyterCoroutine.Utils.INSTANCE.getScope(), (String)("PythonEnvironmentUpdateNotifier " + this.backedNotebookVirtualFile.getFile().getName()), null, (boolean)false, (int)6, null);
        this.triggerFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)64, null, (int)5, null);
        this.realNotebookVirtualFile = JupyterConsoleService.Companion.resolveRealNotebook(this.backedNotebookVirtualFile);
        this.variablesViewStore = JupyterStandaloneVariablesViewStore.Companion.getInstance(this.project);
        this.environmentStore = JupyterEnvironmentStore.Companion.getInstance(this.project);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PythonNotebookEnvironmentStateManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.debounce-HG0u8IE((Flow)((Flow)this.this$0.triggerFlow), (long)DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS)).collect(new FlowCollector(){

                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                boolean isKernelRunning = JupyterExecutionManager.Companion.getInstance(this$0.project, this$0.backedNotebookVirtualFile).hasSession();
                                if (!isKernelRunning) {
                                    return Unit.INSTANCE;
                                }
                                this$0.updateRuntimeEnvironmentState();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Editor getJupyterEditor() {
        if (this.jupyterEditor != null) {
            return this.jupyterEditor;
        }
        this.jupyterEditor = JupyterHelper.INSTANCE.getJupyterEditorByOriginalVirtualFile(this.backedNotebookVirtualFile.getOriginFile());
        return this.jupyterEditor;
    }

    private final JupyterRuntimeInlineValuesHandler getRuntimeInlineValuesHandler() {
        Editor editor = this.getJupyterEditor();
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        if (this.runtimeInlineValuesHandler != null) {
            return this.runtimeInlineValuesHandler;
        }
        this.runtimeInlineValuesHandler = new JupyterRuntimeInlineValuesHandler(this.project, this.backedNotebookVirtualFile, editor2);
        return this.runtimeInlineValuesHandler;
    }

    public final void sessionDeleted() {
        JupyterRuntimeInlineValuesHandler jupyterRuntimeInlineValuesHandler = this.getRuntimeInlineValuesHandler();
        if (jupyterRuntimeInlineValuesHandler != null) {
            jupyterRuntimeInlineValuesHandler.deleteInlineValues();
        }
        this.publishUpdate(null);
    }

    public final void taskStopped(@NotNull JupyterTaskExecutorResult executorResult) {
        Intrinsics.checkNotNullParameter((Object)executorResult, (String)"executorResult");
        if (Intrinsics.areEqual((Object)executorResult, (Object)JupyterTaskExecutorResult.Aborted.INSTANCE)) {
            return;
        }
        this.triggerFlow.tryEmit((Object)Unit.INSTANCE);
    }

    public final void debugStart() {
        block0: {
            JupyterRuntimeInlineValuesHandler jupyterRuntimeInlineValuesHandler = this.getRuntimeInlineValuesHandler();
            if (jupyterRuntimeInlineValuesHandler == null) break block0;
            jupyterRuntimeInlineValuesHandler.deleteInlineValues();
        }
    }

    public final void updateDebugEnvironmentState(@NotNull PyFrameAccessor frameAccessor, @Nullable XValueChildrenList newValues) {
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        this.environmentStore.updateEnvironmentState(this.realNotebookVirtualFile, frameAccessor, newValues);
        this.publishUpdate(newValues);
    }

    private final void updateRuntimeEnvironmentState() {
        XValueChildrenList newValues = this.environmentStore.updateEnvironmentState(this.realNotebookVirtualFile);
        this.variablesViewStore.updateVariablesView(this.backedNotebookVirtualFile);
        JupyterRuntimeInlineValuesHandler jupyterRuntimeInlineValuesHandler = this.getRuntimeInlineValuesHandler();
        if (jupyterRuntimeInlineValuesHandler != null) {
            jupyterRuntimeInlineValuesHandler.updateInlineValues();
        }
        this.publishUpdate(newValues);
    }

    private final void publishUpdate(XValueChildrenList newValues) {
        ((JupyterEnvironmentUpdateListener)this.project.getMessageBus().syncPublisher(JupyterEnvironmentUpdateListener.Companion.getTOPIC())).onJupyterEnvironmentUpdated(this.backedNotebookVirtualFile, newValues);
    }
}

