/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.sarif;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.qodana.staticAnalysis.Static_analysis_dispatchersKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaMessageReporter;
import org.jetbrains.qodana.staticAnalysis.projectDescription.QodanaProjectDescriber;
import org.jetbrains.qodana.staticAnalysis.sarif.DiffChange;
import org.jetbrains.qodana.staticAnalysis.sarif.FileModification;
import org.jetbrains.qodana.staticAnalysis.sarif.FixData;
import org.jetbrains.qodana.staticAnalysis.sarif.FixesLogger;
import org.jetbrains.qodana.staticAnalysis.sarif.FixesLoggerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012J>\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012J\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u001aJ&\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#J\u0018\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0002J2\u0010)\u001a\u0004\u0018\u00010\u001d2\u0006\u0010*\u001a\u00020+2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010,\u001a\u00020\fJ\u0016\u0010-\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/FixesLogger;", "", "<init>", "()V", "fixesData", "", "Lorg/jetbrains/qodana/staticAnalysis/sarif/FixData;", "diffIncluded", "", "getDiffIncluded", "()Z", "logAppliedFix", "", "messageReporter", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaMessageReporter;", "tool", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "problemMessage", "", "problemOriginFilePath", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "modifiedFilePath", "fixText", "logFixesAsJson", "logFileName", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fileDiffs", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/jetbrains/qodana/staticAnalysis/sarif/DiffChange;", "fileModificationsQueue", "Lorg/jetbrains/qodana/staticAnalysis/sarif/FileModification;", "addFileModificationToQueue", "filePath", "textBefore", "", "textAfter", "addLineNumbers", "text", "startLine", "", "calculateDiff", "fragment", "Lcom/intellij/diff/fragments/LineFragment;", "commitFilesModificationsLog", "logFileModificationsAsJson", "Companion", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nFixesLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixesLogger.kt\norg/jetbrains/qodana/staticAnalysis/sarif/FixesLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n774#2:192\n865#2,2:193\n1573#2:195\n1604#2,4:196\n1869#2,2:200\n*S KotlinDebug\n*F\n+ 1 FixesLogger.kt\norg/jetbrains/qodana/staticAnalysis/sarif/FixesLogger\n*L\n135#1:192\n135#1:193,2\n136#1:195\n136#1:196,4\n171#1:200,2\n*E\n"})
public final class FixesLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<FixData> fixesData = new ArrayList();
    private final boolean diffIncluded = Boolean.getBoolean("qodana.fixes.log.include.diff");
    @NotNull
    private final ConcurrentLinkedQueue<DiffChange> fileDiffs = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentLinkedQueue<FileModification> fileModificationsQueue = new ConcurrentLinkedQueue();
    @NotNull
    public static final String TEXT_NOT_CAPTURED_MESSAGE = "Text was not captured";
    @NotNull
    public static final String FILE_NOT_CAPTURED_MESSAGE = "File was not captured";
    @VisibleForTesting
    @NotNull
    public static final String INCLUDE_FIXES_DIFF_KEY = "qodana.fixes.log.include.diff";

    public final boolean getDiffIncluded() {
        return this.diffIncluded;
    }

    public final void logAppliedFix(@NotNull QodanaMessageReporter messageReporter, @NotNull InspectionToolWrapper<?, ?> tool, @NotNull String problemMessage, @NotNull String problemOriginFilePath, @NotNull ProblemDescriptor problemDescriptor, @NotNull String modifiedFilePath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)messageReporter, (String)"messageReporter");
        Intrinsics.checkNotNullParameter(tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)problemMessage, (String)"problemMessage");
        Intrinsics.checkNotNullParameter((Object)problemOriginFilePath, (String)"problemOriginFilePath");
        Intrinsics.checkNotNullParameter((Object)problemDescriptor, (String)"problemDescriptor");
        Intrinsics.checkNotNullParameter((Object)modifiedFilePath, (String)"modifiedFilePath");
        Object[] fixes = problemDescriptor.getFixes();
        if (fixes == null) {
            object = "fix text was not captured";
        } else if (fixes.length == 1) {
            String string = ((QuickFix)ArraysKt.first((Object[])fixes)).getName();
            Intrinsics.checkNotNull((Object)string);
            object = string;
        } else {
            object = "one of the following: " + ArraysKt.joinToString$default((Object[])fixes, (CharSequence)"; ", null, null, (int)0, null, FixesLogger::logAppliedFix$lambda$0, (int)30, null);
        }
        String fixText = object;
        this.logAppliedFix(messageReporter, tool, problemMessage, problemOriginFilePath, fixText, modifiedFilePath);
    }

    public final void logAppliedFix(@NotNull QodanaMessageReporter messageReporter, @NotNull InspectionToolWrapper<?, ?> tool, @NotNull String problemMessage, @NotNull String problemOriginFilePath, @NotNull String fixText, @NotNull String modifiedFilePath) {
        Intrinsics.checkNotNullParameter((Object)messageReporter, (String)"messageReporter");
        Intrinsics.checkNotNullParameter(tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)problemMessage, (String)"problemMessage");
        Intrinsics.checkNotNullParameter((Object)problemOriginFilePath, (String)"problemOriginFilePath");
        Intrinsics.checkNotNullParameter((Object)fixText, (String)"fixText");
        Intrinsics.checkNotNullParameter((Object)modifiedFilePath, (String)"modifiedFilePath");
        String string = tool.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        String string2 = tool.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        FixData fixData = new FixData(string, string2, problemOriginFilePath, problemMessage, fixText, modifiedFilePath);
        messageReporter.reportMessage(1, "In the file " + modifiedFilePath + " inspection " + fixData.getInspectionName() + " performed fix: " + fixData.getFixText());
        this.fixesData.add(fixData);
    }

    @Nullable
    public final Object logFixesAsJson(@NotNull String logFileName, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)Static_analysis_dispatchersKt.getStaticAnalysisDispatchers().getIO(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(logFileName, this, null){
            Object L$0;
            int label;
            final /* synthetic */ String $logFileName;
            final /* synthetic */ FixesLogger this$0;
            {
                this.$logFileName = $logFileName;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String[] stringArray = new String[]{"qodana", this.$logFileName};
                        Path path = Path.of(PathManager.getLogPath(), stringArray);
                        path.getParent().toFile().mkdirs();
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)path);
                        this.label = 1;
                        Object object2 = InterruptibleKt.runInterruptible((CoroutineContext)Static_analysis_dispatchersKt.getStaticAnalysisDispatchers().getIO(), () -> logFixesAsJson.2.invokeSuspend$lambda$0(path, this.this$0), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        Path path = (Path)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (IOException e) {
                            QodanaProjectDescriber.Companion.getLOG().error("Error while saving fixes", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private static final Unit invokeSuspend$lambda$0(Path $path, FixesLogger this$0) {
                Closeable closeable = Files.newBufferedWriter($path, StandardCharsets.UTF_8, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    void this_$iv;
                    BufferedWriter writer = (BufferedWriter)closeable;
                    boolean bl = false;
                    Json json = FixesLoggerKt.access$getJsonEncoder();
                    List value$iv = FixesLogger.access$getFixesData$p(this$0);
                    boolean $i$f$encodeToString = false;
                    this_$iv.getSerializersModule();
                    writer.write(this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(FixData.Companion.serializer()), (Object)value$iv));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return Unit.INSTANCE;
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final boolean addFileModificationToQueue(@NotNull String filePath, @NotNull String problemMessage, @NotNull CharSequence textBefore, @NotNull CharSequence textAfter) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)problemMessage, (String)"problemMessage");
        Intrinsics.checkNotNullParameter((Object)textBefore, (String)"textBefore");
        Intrinsics.checkNotNullParameter((Object)textAfter, (String)"textAfter");
        return this.fileModificationsQueue.add(new FileModification(filePath, problemMessage, textBefore, textAfter));
    }

    /*
     * WARNING - void declaration
     */
    private final String addLineNumbers(String text2, int startLine) {
        void $this$mapIndexedTo$iv$iv;
        Object object;
        Iterable $this$filterTo$iv$iv;
        char[] cArray = new char[]{'\n'};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)text2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            object = new char[]{'\n'};
            String string = StringsKt.trimEnd((String)it, (char[])object);
            object = new char[]{'\n'};
            boolean bl2 = !StringsKt.isBlank((CharSequence)StringsKt.trimIndent((String)StringsKt.trimStart((String)string, (char[])object)));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$mapIndexed = false;
        $this$filterTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void line;
            void i;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((int)(i + startLine) + (String)line);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final DiffChange calculateDiff(LineFragment fragment, CharSequence textBefore, CharSequence textAfter, String filePath, String problemMessage) {
        if (fragment.getStartOffset1() > fragment.getEndOffset1() || fragment.getStartOffset2() > fragment.getEndOffset2()) {
            return null;
        }
        String oldText = ((Object)textBefore.subSequence(fragment.getStartOffset1(), fragment.getEndOffset1())).toString();
        String newText = ((Object)textAfter.subSequence(fragment.getStartOffset2(), fragment.getEndOffset2())).toString();
        char[] cArray = new char[]{'\n'};
        String string = StringsKt.trimStart((String)oldText, (char[])cArray);
        cArray = new char[]{'\n'};
        if (StringsKt.isBlank((CharSequence)StringsKt.trimIndent((String)StringsKt.trimEnd((String)string, (char[])cArray)))) {
            return new DiffChange("", this.addLineNumbers(newText, fragment.getStartLine2()), filePath, problemMessage);
        }
        cArray = new char[]{'\n'};
        String string2 = StringsKt.trimStart((String)newText, (char[])cArray);
        cArray = new char[]{'\n'};
        if (StringsKt.isBlank((CharSequence)StringsKt.trimIndent((String)StringsKt.trimEnd((String)string2, (char[])cArray)))) {
            return new DiffChange(this.addLineNumbers(oldText, fragment.getStartLine1()), "Was deleted", filePath, problemMessage);
        }
        return new DiffChange(this.addLineNumbers(oldText, fragment.getStartLine1()), this.addLineNumbers(newText, fragment.getStartLine2()), filePath, problemMessage);
    }

    public final void commitFilesModificationsLog() {
        while (this.fileModificationsQueue.poll() != null) {
            List diff;
            FileModification fileModification;
            String modifiedFile = fileModification.component1();
            String problemMessage = fileModification.component2();
            CharSequence beforeFixText = fileModification.component3();
            CharSequence afterFixText = fileModification.component4();
            if (Intrinsics.areEqual((Object)beforeFixText, (Object)TEXT_NOT_CAPTURED_MESSAGE) || Intrinsics.areEqual((Object)afterFixText, (Object)TEXT_NOT_CAPTURED_MESSAGE)) {
                this.fileDiffs.add(new DiffChange(TEXT_NOT_CAPTURED_MESSAGE, TEXT_NOT_CAPTURED_MESSAGE, modifiedFile, problemMessage));
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ComparisonManager.getInstance().compareLines(beforeFixText, afterFixText, ComparisonPolicy.DEFAULT, (ProgressIndicator)new ProgressIndicatorBase()), (String)"compareLines(...)");
            if (diff.size() == 0) {
                this.fileDiffs.add(new DiffChange(TEXT_NOT_CAPTURED_MESSAGE, TEXT_NOT_CAPTURED_MESSAGE, modifiedFile, problemMessage));
                continue;
            }
            Iterable $this$forEach$iv = diff;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LineFragment lineFragment = (LineFragment)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)lineFragment);
                this.fileDiffs.add(this.calculateDiff(lineFragment, beforeFixText, afterFixText, modifiedFile, problemMessage));
            }
        }
    }

    @Nullable
    public final Object logFileModificationsAsJson(@NotNull String logFileName, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)Static_analysis_dispatchersKt.getStaticAnalysisDispatchers().getIO(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(logFileName, this, null){
            Object L$0;
            int label;
            final /* synthetic */ String $logFileName;
            final /* synthetic */ FixesLogger this$0;
            {
                this.$logFileName = $logFileName;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String[] stringArray = new String[]{"qodana", this.$logFileName};
                        Path path = Path.of(PathManager.getLogPath(), stringArray);
                        path.getParent().toFile().mkdirs();
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)path);
                        this.label = 1;
                        Object object2 = InterruptibleKt.runInterruptible((CoroutineContext)Static_analysis_dispatchersKt.getStaticAnalysisDispatchers().getIO(), () -> logFileModificationsAsJson.2.invokeSuspend$lambda$0(path, this.this$0), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        Path path = (Path)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (IOException e) {
                            QodanaProjectDescriber.Companion.getLOG().error("Error while saving file modifications", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private static final Unit invokeSuspend$lambda$0(Path $path, FixesLogger this$0) {
                Closeable closeable = Files.newBufferedWriter($path, StandardCharsets.UTF_8, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    void this_$iv;
                    BufferedWriter writer = (BufferedWriter)closeable;
                    boolean bl = false;
                    Json json = FixesLoggerKt.access$getJsonEncoder();
                    List value$iv = CollectionsKt.toList((Iterable)FixesLogger.access$getFileDiffs$p(this$0));
                    boolean $i$f$encodeToString = false;
                    this_$iv.getSerializersModule();
                    writer.write(this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(BuiltinSerializersKt.getNullable(DiffChange.Companion.serializer())), (Object)value$iv));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return Unit.INSTANCE;
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence logAppliedFix$lambda$0(QuickFix it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public static final /* synthetic */ List access$getFixesData$p(FixesLogger $this) {
        return $this.fixesData;
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$getFileDiffs$p(FixesLogger $this) {
        return $this.fileDiffs;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/FixesLogger$Companion;", "", "<init>", "()V", "TEXT_NOT_CAPTURED_MESSAGE", "", "FILE_NOT_CAPTURED_MESSAGE", "INCLUDE_FIXES_DIFF_KEY", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

