/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.TreeTableWidthController;
import com.jetbrains.nodejs.run.profile.TreeTableWithTreeWidthController;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.TableWithFixedWidth;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.view.actions.GoToSourceAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.MarkUnmarkAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.V8NavigateToMainTreeAction;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTreeNavigator;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.DirectTreeTableRenderer;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class V8Utils {
    public static final DataKey<Long> DETAILS_POSITION = DataKey.create((String)"V8.CPU.DETAILS_POSITION");
    public static final DataKey<Boolean> IS_NAVIGATABLE = DataKey.create((String)"V8.IS.NAVIGATABLE");
    public static final DataKey<Navigatable[]> NAVIGATABLE_ONLY_FOR_ACTION = DataKey.create((String)"V8.NAVIGATABLE_ONLY_FOR_ACTION");
    public static final DataKey<Pair<Integer, Integer>> NAVIGATION_POSITION = DataKey.create((String)"V8.NAVIGATION_POSITION");
    public static final DataKey<V8CpuLogCall> SELECTED_CALL = DataKey.create((String)"V8.SELECTED_CALL");
    @NonNls
    public static final String HEAP_SNAPSHOT = "heapsnapshot";
    private static final Navigatable[] ourEmptyNavigatables = new Navigatable[]{new Navigatable(){

        public void navigate(boolean requestFocus) {
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return true;
        }
    }};

    public static void selectAndNavigate(AnActionEvent e, List<Navigatable> navigatables, Consumer<? super Navigatable> consumer, final @Nullable Map<Navigatable, String> addText) {
        IPopupChooserBuilder popupChooserBuilder = JBPopupFactory.getInstance().createPopupChooserBuilder(navigatables).setTitle(NodeJSBundle.message("popup.title.select.file.to.navigate.to", new Object[0])).setRenderer((ListCellRenderer)new DefaultPsiElementCellRenderer(){

            public String getContainerText(PsiElement element, String name) {
                String text = super.getContainerText(element, name);
                String add = addText == null ? "" : (String)addText.get(element);
                return add == null ? text : text + add;
            }
        }).setMovable(true).setResizable(true).setCancelKeyEnabled(true).setCancelOnWindowDeactivation(true).setCancelOnClickOutside(true).setItemChosenCallback(consumer);
        JBPopup popup = popupChooserBuilder.createPopup();
        V8Utils.showPopup(e, popup);
    }

    public static Point showPopup(AnActionEvent e, JBPopup popup) {
        InputEvent event = e.getInputEvent();
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            if (mouseEvent.getXOnScreen() == 0 && mouseEvent.getYOnScreen() == 0) {
                popup.showInBestPositionFor(e.getDataContext());
                return popup.getLocationOnScreen();
            }
            popup.show(new RelativePoint(mouseEvent));
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
        return popup.getLocationOnScreen();
    }

    public static JComponent wrapWithActions(@NotNull JComponent pane, @NotNull DefaultActionGroup group) {
        if (pane == null) {
            V8Utils.$$$reportNull$$$0(0);
        }
        if (group == null) {
            V8Utils.$$$reportNull$$$0(1);
        }
        return new WithToolbarWrapper(pane, group).getMainPanel();
    }

    public static void adjustTableColumnWidths(TableWithFixedWidth table) {
        TableModel model = table.getModel();
        table.setAutoResizeMode(0);
        int columnCount = table.getColumnCount();
        FontMetrics metrics = table.getFontMetrics(table.getTableHeader().getFont());
        int rowCount = model.getRowCount();
        int total = 0;
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            int maxWidth = metrics.stringWidth(column.getHeaderValue().toString()) + 2;
            for (int j = 0; j < rowCount; ++j) {
                TableCellRenderer renderer = table.getCellRenderer(j, i);
                renderer.getTableCellRendererComponent((JTable)((Object)table), model.getValueAt(j, i), false, false, j, i);
                if (!(renderer instanceof ColoredTableCellRenderer)) continue;
                maxWidth = Math.max(((ColoredTableCellRenderer)renderer).computePreferredSize((boolean)false).width + 2, maxWidth);
            }
            total += maxWidth;
            if (i == 0) {
                column.setMinWidth(maxWidth);
                continue;
            }
            V8Utils.fixColumnWidth(maxWidth, column);
        }
        table.setMinWidth(total);
    }

    public static void collapseAll(TreeTable treeTable) {
        TreeTableTree tree = treeTable.getTree();
        TreePath leadSelectionPath = tree.getLeadSelectionPath();
        V8Utils.collapseAllBare(treeTable);
        Object root = tree.getModel().getRoot();
        tree.expandPath(new TreePath(root));
        if (leadSelectionPath != null && leadSelectionPath.getPath().length > 1) {
            TreeUtil.selectPath((JTree)tree, (TreePath)new TreePath(Arrays.copyOf(leadSelectionPath.getPath(), 2)));
        }
    }

    public static void collapseAllBare(TreeTable treeTable) {
        TreeTableTree tree = treeTable.getTree();
        for (int row = tree.getRowCount() - 1; row >= 0; --row) {
            tree.collapseRow(row);
        }
    }

    public static void setSmallerTreeIndent(TreeTableTree tree) {
        TreeUI ui = tree.getUI();
        if (ui instanceof BasicTreeUI) {
            BasicTreeUI basicUi = (BasicTreeUI)ui;
            basicUi.setRightChildIndent(UIUtil.getTreeRightChildIndent() / 2);
        }
    }

    @NotNull
    public static String formatPercent(int percent) {
        if (percent == 0) {
            return "0%";
        }
        Formatter formatter = new Formatter();
        String string = formatter.format("%.1f%%", (double)percent / 10.0).toString();
        String string2 = string;
        if (string2 == null) {
            V8Utils.$$$reportNull$$$0(2);
        }
        return string2;
        finally {
            formatter.close();
        }
    }

    public static int tensPercent(long ticks, long totalTicks) {
        return V8Utils.tensPercent((int)ticks, (int)totalTicks);
    }

    public static int tensPercent(int ticks, int totalTicks) {
        return (int)Math.round((double)ticks * 1000.0 / (double)totalTicks);
    }

    public static void installHeapPopupMenu(Project project, @NotNull TreeTable treeTable, @NotNull V8CachingReader reader, V8MainTreeNavigator navigator) {
        if (treeTable == null) {
            V8Utils.$$$reportNull$$$0(3);
        }
        if (reader == null) {
            V8Utils.$$$reportNull$$$0(4);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        MarkUnmarkAction markUnmarkAction = new MarkUnmarkAction(project, reader);
        markUnmarkAction.setTable(treeTable);
        group.add((AnAction)markUnmarkAction);
        if (navigator != null) {
            V8NavigateToMainTreeAction action = new V8NavigateToMainTreeAction();
            action.setFixedNavigator(navigator);
            action.setTable(treeTable);
            group.add((AnAction)action);
        }
        group.add((AnAction)new GoToSourceAction(reader, treeTable));
        PopupHandler.installPopupMenu((JComponent)treeTable, (ActionGroup)group, (String)"V8_HEAP_PROFILING_POPUP");
    }

    public static int getTableRowX(@NotNull JTree tree, int row) {
        if (tree == null) {
            V8Utils.$$$reportNull$$$0(5);
        }
        return TreeUtil.getNodeRowX((JTree)tree, (int)row);
    }

    public static V8HeapTreeTable createTable(Project project, TreeTableModel model, V8CachingReader reader) {
        V8HeapTreeTable table = new V8HeapTreeTable(model, reader.getResourses());
        V8Utils.afterModelReset(project, reader, table);
        return table;
    }

    public static void afterModelReset(Project project, V8CachingReader reader, V8HeapTreeTable table) {
        String sample = reader.getRetainedSize(0) + " 100% a b";
        V8Utils.afterModelReset(table, sample, reader.getResourses(), (TreeCellRenderer)((Object)new DirectTreeTableRenderer(project, reader)));
    }

    public static void afterModelReset(V8HeapTreeTable table, @Nullable String sample, CompositeCloseable resources, TreeCellRenderer renderer) {
        table.setAutoResizeMode(0);
        table.getTableHeader().setResizingAllowed(false);
        table.getTableHeader().setReorderingAllowed(false);
        table.setRootVisible(false);
        table.getTree().setShowsRootHandles(true);
        table.smallerIndent();
        table.setSelectionMode(0);
        V8Utils.adjustColumnWidths(table, sample);
        table.attachWidthController(resources, renderer);
    }

    public static void adjustColumnWidths(TreeTable table, String sample) {
        block4: {
            int count;
            TableColumnModel model;
            FontMetrics metrics;
            block3: {
                TreeTableModel treeTableModel;
                metrics = table.getTableHeader().getFontMetrics(table.getTableHeader().getFont());
                model = table.getTableHeader().getColumnModel();
                count = table.getTableModel().getColumnCount();
                if (sample != null || !((treeTableModel = table.getTableModel()) instanceof TreeTableModelWithCustomRenderer)) break block3;
                TreeTableModelWithCustomRenderer withRenderer = (TreeTableModelWithCustomRenderer)treeTableModel;
                for (int col = 1; col < count; ++col) {
                    TableColumn column = table.getColumnModel().getColumn(col);
                    int maxWidth = metrics.stringWidth(column.getHeaderValue().toString()) + 2;
                    for (int row = 0; row < table.getRowCount(); ++row) {
                        Object value = table.getValueAt(row, col);
                        ColoredTableCellRenderer renderer = (ColoredTableCellRenderer)withRenderer.getCustomizedRenderer(col, value, table.getCellRenderer(row, col));
                        renderer.getTableCellRendererComponent((JTable)table, value, false, true, row, col);
                        maxWidth = Math.max(renderer.computePreferredSize((boolean)false).width + 10, maxWidth);
                    }
                    V8Utils.fixColumnWidth(maxWidth, column);
                }
                break block4;
            }
            if (sample == null) break block4;
            int width = Math.max(metrics.stringWidth(sample) + 3, 10);
            for (int i = 1; i < count; ++i) {
                V8Utils.fixColumnWidth(width, model.getColumn(i));
            }
        }
    }

    public static void fixColumnWidth(int width, TableColumn two) {
        two.setWidth(width);
        two.setMaxWidth(4 * width);
        two.setMinWidth(width);
    }

    public static void writeIntList(IntList list, ObjectOutput out) throws IOException {
        out.writeInt(list.size());
        for (int i = 0; i < list.size(); ++i) {
            out.writeInt(list.getInt(i));
        }
    }

    public static IntList readIntList(ObjectInput in) throws IOException {
        int size = in.readInt();
        IntArrayList list = new IntArrayList(size);
        for (int i = 0; i < size; ++i) {
            list.add(in.readInt());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void safeDraw(@NotNull Graphics2D graphics2D, Consumer<? super Graphics2D> consumer) {
        if (graphics2D == null) {
            V8Utils.$$$reportNull$$$0(6);
        }
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        Font font = graphics2D.getFont();
        Paint paint = graphics2D.getPaint();
        try {
            consumer.consume((Object)graphics2D);
        }
        finally {
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.setFont(font);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/V8Utils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics2D";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/V8Utils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatPercent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithActions";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installHeapPopupMenu";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTableRowX";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "safeDraw";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class WithToolbarWrapper {
        private final JPanel myMainPanel;
        private final ActionToolbar myToolbar;

        public WithToolbarWrapper(@NotNull JComponent pane, @NotNull DefaultActionGroup group) {
            if (pane == null) {
                WithToolbarWrapper.$$$reportNull$$$0(0);
            }
            if (group == null) {
                WithToolbarWrapper.$$$reportNull$$$0(1);
            }
            this.myMainPanel = new JPanel(new BorderLayout());
            this.myMainPanel.add((Component)pane, "Center");
            this.myToolbar = ActionManager.getInstance().createActionToolbar("V8 profiling", (ActionGroup)group, false);
            this.myToolbar.setTargetComponent(pane);
            this.myMainPanel.add((Component)this.myToolbar.getComponent(), "West");
        }

        public JPanel getMainPanel() {
            return this.myMainPanel;
        }

        public ActionToolbar getToolbar() {
            return this.myToolbar;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pane";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "group";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/nodejs/run/profile/V8Utils$WithToolbarWrapper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CollapseAllAction
    extends DumbAwareAction {
        private TreeTable myTable;

        public CollapseAllAction(TreeTable table) {
            super(IdeBundle.messagePointer((String)"action.CollapseAllAction.text.collapse.all", (Object[])new Object[0]), AllIcons.Actions.Collapseall);
            this.myTable = table;
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("CollapseAll").getShortcutSet(), (JComponent)this.myTable);
        }

        public void setTable(TreeTableWithTreeWidthController table) {
            this.myTable = table;
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExpandAll").getShortcutSet(), (JComponent)this.myTable);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                CollapseAllAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CollapseAllAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.myTable != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CollapseAllAction.$$$reportNull$$$0(2);
            }
            if (this.myTable == null) {
                return;
            }
            V8Utils.collapseAll(this.myTable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/nodejs/run/profile/V8Utils$CollapseAllAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/nodejs/run/profile/V8Utils$CollapseAllAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class ExpandAllAction
    extends DumbAwareAction {
        private TreeTableWithTreeWidthController myTable;

        public ExpandAllAction(TreeTableWithTreeWidthController table) {
            super(IdeBundle.messagePointer((String)"action.ExpandAllAction.text.expand.all", (Object[])new Object[0]), AllIcons.Actions.Expandall);
            this.myTable = table;
            if (this.myTable != null) {
                this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExpandAll").getShortcutSet(), (JComponent)((Object)this.myTable));
            }
        }

        public void setTable(TreeTableWithTreeWidthController table) {
            this.myTable = table;
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExpandAll").getShortcutSet(), (JComponent)((Object)this.myTable));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ExpandAllAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExpandAllAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.myTable != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExpandAllAction.$$$reportNull$$$0(2);
            }
            if (this.myTable == null) {
                return;
            }
            TreeTableWidthController controller = this.myTable.getWidthController();
            if (controller != null) {
                controller.startBatchExpand();
            }
            TreeUtil.expandAll((JTree)this.myTable.getTree());
            if (controller != null) {
                controller.stopBatchExpand();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/nodejs/run/profile/V8Utils$ExpandAllAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/nodejs/run/profile/V8Utils$ExpandAllAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class LightweightEditSourceAction
    extends EditSourceAction {
        public LightweightEditSourceAction(JComponent component) {
            this.getTemplatePresentation().setIcon(AllIcons.Actions.EditSource);
            this.getTemplatePresentation().setText(ActionsBundle.actionText((String)"EditSource").replace("_", ""));
            this.getTemplatePresentation().setDescription(ActionsBundle.actionDescription((String)"EditSource"));
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), component);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                LightweightEditSourceAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            Project project = e.getProject();
            boolean enabled = project != null && Boolean.TRUE.equals(e.getData(IS_NAVIGATABLE));
            e.getPresentation().setEnabled(enabled);
            if ("V8_CPU_PROFILING_POPUP".equals(e.getPlace())) {
                e.getPresentation().setVisible(enabled);
            }
        }

        protected Navigatable @Nullable [] getNavigatables(DataContext dataContext) {
            return ourEmptyNavigatables;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                LightweightEditSourceAction.$$$reportNull$$$0(1);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
                return;
            }
            Pair position = (Pair)e.getData(NAVIGATION_POSITION);
            Consumer consumer = item -> {
                if (item instanceof PsiFile && ((PsiFile)item).getVirtualFile() != null && position != null) {
                    new OpenFileDescriptor(project, ((PsiFile)item).getVirtualFile(), Math.max(0, (Integer)position.getFirst() - 1), Math.max(0, (Integer)position.getSecond() - 1)).navigate(true);
                    return;
                }
                item.navigate(true);
            };
            Navigatable[] navigatables = (Navigatable[])e.getData(NAVIGATABLE_ONLY_FOR_ACTION);
            if (navigatables == null || navigatables.length == 0) {
                NodeProfilingSettings.CPU_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.GoToSourceAction.notification.not_found.content", new Object[0]), MessageType.INFO).notify(project);
                return;
            }
            if (navigatables.length == 1) {
                navigatables[0].navigate(true);
                return;
            }
            HashMap<Navigatable, String> addText = position == null ? null : new HashMap<Navigatable, String>();
            Navigatable first = null;
            if (position != null) {
                for (Navigatable navigatable : navigatables) {
                    Document document;
                    if (navigatable instanceof PsiFile) {
                        addText.put(navigatable, ":" + String.valueOf(position.getFirst()) + ":" + String.valueOf(position.getSecond()));
                        continue;
                    }
                    if (!(navigatable instanceof PsiElement) || ((PsiElement)navigatable).getContainingFile() == null || (document = PsiDocumentManager.getInstance((Project)project).getDocument(((PsiElement)navigatable).getContainingFile())) == null) continue;
                    int elemOffset = ((PsiElement)navigatable).getTextOffset();
                    int lineNumber = document.getLineNumber(elemOffset);
                    int column = elemOffset - document.getLineStartOffset(lineNumber);
                    boolean exact = lineNumber + 1 == (Integer)position.getFirst();
                    String comment = ":" + lineNumber + ":" + column;
                    if (exact) {
                        comment = ":" + (lineNumber + 1) + ":" + String.valueOf(position.getSecond()) + " (exact match)";
                        first = navigatable;
                    }
                    addText.put(navigatable, comment);
                }
            }
            final Navigatable finalFirst = first;
            Arrays.sort(navigatables, new Comparator<Navigatable>(this){

                @Override
                public int compare(Navigatable o1, Navigatable o2) {
                    if (o1.equals((Object)finalFirst)) {
                        return -1;
                    }
                    if (o2.equals((Object)finalFirst)) {
                        return 1;
                    }
                    boolean isFile1 = o1 instanceof PsiFile;
                    boolean isFile2 = o2 instanceof PsiFile;
                    if (isFile1 != isFile2) {
                        return isFile1 ? 1 : -1;
                    }
                    return Comparing.compare((Comparable)((Object)1.getText(o1)), (Comparable)((Object)1.getText(o2)));
                }

                private static String getText(Object o) {
                    if (o instanceof JSNamedElementBase) {
                        return ((JSNamedElementBase)o).getName();
                    }
                    if (o instanceof PsiFile) {
                        return ((PsiFile)o).getName();
                    }
                    return o.toString();
                }
            });
            V8Utils.selectAndNavigate(e, Arrays.asList(navigatables), (Consumer<? super Navigatable>)consumer, addText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/V8Utils$LightweightEditSourceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

