/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.openapi.util.Pair;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.LongIntegerSerializer;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8LogIndexesWriter;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.io.IntegerRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.LongRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawWriter;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class V8OverviewScalesBuilder {
    public static final long TICK_STEP = 50000L;
    public static final int MAX_POINTS = 500;
    @NotNull
    private final File myTsFile;
    @NotNull
    private final File myStackSizeFile;
    private final long myNumTicks;
    private final long myLastTick;
    @NotNull
    private final IndexFiles<V8LogIndexesWriter.Category> myIndexFiles;
    private final long myTickStep;
    private final List<File> myOverviewFiles;

    /*
     * WARNING - void declaration
     */
    public V8OverviewScalesBuilder(@NotNull File tsFile, @NotNull File stackSizeFile, long numTicks, long lastTick, @NotNull IndexFiles<V8LogIndexesWriter.Category> indexFiles, long l) {
        void tickStep;
        void indexFiles2;
        if (tsFile == null) {
            V8OverviewScalesBuilder.$$$reportNull$$$0(0);
        }
        if (stackSizeFile == null) {
            V8OverviewScalesBuilder.$$$reportNull$$$0(1);
        }
        if (indexFiles == null) {
            V8OverviewScalesBuilder.$$$reportNull$$$0(2);
        }
        this.myTsFile = tsFile;
        this.myStackSizeFile = stackSizeFile;
        this.myNumTicks = numTicks;
        this.myLastTick = lastTick;
        this.myIndexFiles = indexFiles2;
        this.myTickStep = tickStep;
        this.myOverviewFiles = new ArrayList<File>();
    }

    public List<File> getOverviewFiles() {
        return this.myOverviewFiles;
    }

    public void execute() throws IOException {
        this.execute(false);
    }

    public void execute(boolean testMode) throws IOException {
        try (CompositeCloseable resources = new CompositeCloseable();){
            final ArrayList<ScaleWriter> scaleWriters = new ArrayList<ScaleWriter>();
            long step = this.myTickStep;
            LongIntegerSerializer serializer = new LongIntegerSerializer();
            while (this.myLastTick / step > 500L || testMode && this.myLastTick / step > 0L) {
                File file = this.myIndexFiles.generate(V8LogIndexesWriter.Category.overviewScale, "overviewScale");
                this.myOverviewFiles.add(file);
                SequentialRawWriter<Pair<Long, Integer>> writer = new SequentialRawWriter<Pair<Long, Integer>>(file, serializer);
                scaleWriters.add(resources.register(new ScaleWriter(step, writer)));
                step *= 4L;
            }
            SequentialRawReader<Long> tsReader = resources.register(new SequentialRawReader<Long>(this.myTsFile, new LongRawSerializer()));
            final SequentialRawReader<Integer> stackSizeReader = resources.register(new SequentialRawReader<Integer>(this.myStackSizeFile, new IntegerRawSerializer()));
            tsReader.iterate(new CloseableThrowableConsumer<Long, IOException>(this){

                @Override
                public void close() throws IOException {
                    for (ScaleWriter writer : scaleWriters) {
                        writer.finish();
                    }
                }

                public void consume(Long ts) throws IOException {
                    Integer size = (Integer)stackSizeReader.read();
                    for (ScaleWriter writer : scaleWriters) {
                        writer.tick(ts, size);
                    }
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tsFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "stackSizeFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "indexFiles";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8OverviewScalesBuilder";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ScaleWriter
    implements Closeable {
        private int myMax;
        private long myPrevTs;
        private long myLastTick;
        private final long myStep;
        private final SequentialRawWriter<Pair<Long, Integer>> myWriter;

        ScaleWriter(long step, SequentialRawWriter<Pair<Long, Integer>> writer) {
            this.myStep = step;
            this.myWriter = writer;
            this.myMax = 0;
            this.myPrevTs = 0L;
            this.myLastTick = 0L;
        }

        public void tick(long tick, int stackSize) throws IOException {
            if (tick < this.myLastTick) {
                return;
            }
            if (tick - this.myStep >= this.myPrevTs) {
                this.myWriter.write((Pair<Long, Integer>)Pair.create((Object)(this.myPrevTs + this.myStep / 2L), (Object)this.myMax));
                this.myMax = 0;
                this.myPrevTs += this.myStep;
                while (this.myPrevTs + this.myStep <= tick) {
                    this.myWriter.write((Pair<Long, Integer>)Pair.create((Object)(this.myPrevTs + this.myStep / 2L), (Object)0));
                    this.myPrevTs += this.myStep;
                }
            }
            this.myMax = Math.max(this.myMax, stackSize);
            this.myLastTick = tick;
        }

        public void finish() throws IOException {
            this.myWriter.write((Pair<Long, Integer>)Pair.create((Object)((this.myPrevTs + this.myLastTick) / 2L), (Object)this.myMax));
        }

        @Override
        public void close() throws IOException {
            this.myWriter.close();
        }
    }
}

