/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.BeforeAfter;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.TimeDistribution;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.ZoomFlameChartAnAction;
import icons.NodeJSIcons;
import java.io.IOException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class V8NavigateToFlameChartIntervalAction
extends DumbAwareAction {
    @NotNull
    private final Kind myKind;
    private final V8LogCachingReader myReader;
    private final Consumer<String> myNotificator;

    public V8NavigateToFlameChartIntervalAction(@NotNull Kind kind, V8LogCachingReader reader, Consumer<String> notificator) {
        if (kind == null) {
            V8NavigateToFlameChartIntervalAction.$$$reportNull$$$0(0);
        }
        super(V8NavigateToFlameChartIntervalAction.name(kind), V8NavigateToFlameChartIntervalAction.name(kind), NodeJSIcons.Navigate_inMainTree);
        this.myKind = kind;
        this.myReader = reader;
        this.myNotificator = notificator;
    }

    public static void addToGroup(DefaultActionGroup group, V8LogCachingReader reader, Consumer<String> notificator) {
        for (Kind kind : Kind.values()) {
            group.add((AnAction)new V8NavigateToFlameChartIntervalAction(kind, reader, notificator));
        }
    }

    @NotNull
    private static String name(@NotNull Kind kind) {
        if (kind == null) {
            V8NavigateToFlameChartIntervalAction.$$$reportNull$$$0(1);
        }
        String string = "Navigate To " + kind.getText() + " Time";
        if (string == null) {
            V8NavigateToFlameChartIntervalAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            V8NavigateToFlameChartIntervalAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            V8NavigateToFlameChartIntervalAction.$$$reportNull$$$0(4);
        }
        e.getPresentation().setEnabled(e.getData(V8Utils.SELECTED_CALL) != null && e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            V8NavigateToFlameChartIntervalAction.$$$reportNull$$$0(5);
        }
        V8CpuLogCall call = (V8CpuLogCall)e.getData(V8Utils.SELECTED_CALL);
        Project project = e.getProject();
        if (call == null || project == null) {
            return;
        }
        try {
            long start;
            long interval;
            boolean takeLongest;
            TimeDistribution distribution = this.myKind.mySelf ? this.myReader.getSelfTimesDistribution(call.getStringId()) : this.myReader.getTimesDistribution(call.getStringId());
            if (distribution == null || distribution.isEmpty()) {
                String message = NodeJSBundle.message("popup.content.cannot.navigate.to.flame.chart.details", this.myKind.mySelf ? 0 : 1);
                NodeUIUtil.balloonInfo((Project)project, (String)message, null, null);
                return;
            }
            boolean bl = takeLongest = this.myKind.myLongest || distribution.getTypicalIndex() == -1;
            if (takeLongest) {
                interval = distribution.getMax();
                start = distribution.getMaxStartTs();
            } else {
                int index = distribution.getTypicalIndex();
                interval = distribution.getEndTimes()[index];
                start = distribution.getSampleStartTs()[index];
            }
            long selectionStart = (long)Math.max(0.0, (double)start - (double)interval * 0.5);
            long selectionEnd = start + interval * 2L;
            long selected = selectionEnd - selectionStart;
            long showStart = Math.max(0L, selectionStart - selected * 4L);
            long showEnd = selectionStart + selected * 5L;
            ZoomFlameChartAnAction.ZoomTask task = new ZoomFlameChartAnAction.ZoomTask(project, this.myReader, this.myReader.getV8LogFile().getName(), this.myNotificator, (BeforeAfter<Long>)new BeforeAfter((Object)showStart, (Object)showEnd)).withDetailsPosition(start + interval / 4L).withStringId(call.getStringId()).withSelection(selectionStart, selectionEnd);
            ProgressManager.getInstance().run((Task)task);
        }
        catch (IOException e1) {
            NodeUIUtil.balloonInfo((Project)project, (String)NodeJSBundle.message("popup.content.can.not.navigate.to.flame.chart", e1.getMessage()), null, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/view/V8NavigateToFlameChartIntervalAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/V8NavigateToFlameChartIntervalAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "name";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    public static enum Kind {
        longestTotal("Longest", true, false),
        typicalTotal("Typical", false, false),
        longestSelf("Longest Self", true, true),
        typicalSelf("Typical Self", false, true);

        private final String myText;
        private final boolean myLongest;
        private final boolean mySelf;

        private Kind(String text, boolean longest, boolean self) {
            this.myText = text;
            this.myLongest = longest;
            this.mySelf = self;
        }

        public String getText() {
            return this.myText;
        }
    }
}

