/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssImportList;
import com.intellij.psi.css.CssNamespace;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.impl.CssCharsetImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssRulesetWrappingElement;
import com.intellij.psi.css.impl.stubs.CssImportStub;
import com.intellij.psi.css.impl.stubs.CssStub;
import com.intellij.psi.css.impl.stubs.base.CssStubElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssStubStylesheet
extends CssStubElement<CssStub>
implements CssStylesheet {
    public CssStubStylesheet(@NotNull CssStub stub, @NotNull IElementType nodeType) {
        if (stub == null) {
            CssStubStylesheet.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            CssStubStylesheet.$$$reportNull$$$0(1);
        }
        super(stub, nodeType);
    }

    public CssStubStylesheet(@NotNull ASTNode node) {
        if (node == null) {
            CssStubStylesheet.$$$reportNull$$$0(2);
        }
        super(node);
    }

    @NotNull
    public CssRulesetList getRulesetList() {
        CssRulesetList cssRulesetList = Objects.requireNonNull((CssRulesetList)PsiTreeUtil.getStubChildOfType((PsiElement)this, CssRulesetList.class));
        if (cssRulesetList == null) {
            CssStubStylesheet.$$$reportNull$$$0(3);
        }
        return cssRulesetList;
    }

    @Nullable
    public CssImportList getImportList() {
        return (CssImportList)PsiTreeUtil.getChildOfType((PsiElement)this, CssImportList.class);
    }

    public CssNamespace @NotNull [] getNamespaces() {
        CssNamespace[] cssNamespaceArray = (CssNamespace[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            for (PsiElement child = this.getFirstChild(); child != null && !(child instanceof CssRulesetList); child = child.getNextSibling()) {
                if (!(child instanceof TreeElement) || ((TreeElement)child).getElementType() != CssElementTypes.CSS_NAMESPACE_LIST) continue;
                return CachedValueProvider.Result.create((Object)((CssNamespace[])PsiTreeUtil.getChildrenOfType((PsiElement)child, CssNamespace.class)), (Object[])new Object[]{this});
            }
            return CachedValueProvider.Result.create((Object)CssNamespace.EMPTY_ARRAY, (Object[])new Object[]{this});
        });
        if (cssNamespaceArray == null) {
            CssStubStylesheet.$$$reportNull$$$0(4);
        }
        return cssNamespaceArray;
    }

    @Nullable
    public CssNamespace getNamespace(@Nullable String prefix) {
        for (CssNamespace namespace : this.getNamespaces()) {
            if (!(prefix == null ? namespace.getPrefix() == null : prefix.equals(namespace.getPrefix()))) continue;
            return namespace;
        }
        return null;
    }

    @NotNull
    public List<CssImport> getImports() {
        List<CssImport> list = this.getImports(true);
        if (list == null) {
            CssStubStylesheet.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<CssImport> getImports(boolean fromImportListOnly) {
        if (fromImportListOnly) {
            CssStub stub = (CssStub)this.getStub();
            if (stub != null) {
                SmartList result = new SmartList();
                for (Object o : stub.getChildrenStubs()) {
                    if (!(o instanceof CssImportStub) || !((CssImportStub)((Object)o)).isFromImportList()) continue;
                    result.add((CssImport)((CssImportStub)((Object)o)).getPsi());
                }
                SmartList smartList = result;
                if (smartList == null) {
                    CssStubStylesheet.$$$reportNull$$$0(6);
                }
                return smartList;
            }
            CssImportList importList = this.getImportList();
            List list = importList != null ? importList.getImports() : Collections.emptyList();
            if (list == null) {
                CssStubStylesheet.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            CssStub stub = (CssStub)this.getStub();
            if (stub != null) {
                SmartList result = new SmartList();
                CssStubStylesheet.collectAllStubImports((StubElement)stub, (List<CssImport>)result);
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{this});
            }
            return CachedValueProvider.Result.create(this.collectAllImports(), (Object[])new Object[]{this});
        });
        if (list == null) {
            CssStubStylesheet.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static void collectAllStubImports(@NotNull StubElement stub, @NotNull List<CssImport> result) {
        if (stub == null) {
            CssStubStylesheet.$$$reportNull$$$0(9);
        }
        if (result == null) {
            CssStubStylesheet.$$$reportNull$$$0(10);
        }
        for (Object o : stub.getChildrenStubs()) {
            if (o instanceof CssImportStub) {
                result.add((CssImport)((CssImportStub)((Object)o)).getPsi());
                continue;
            }
            if (!(o instanceof StubElement)) continue;
            CssStubStylesheet.collectAllStubImports((StubElement)o, result);
        }
    }

    private List<CssImport> collectAllImports() {
        final ArrayList<CssImport> result = new ArrayList<CssImport>();
        this.accept(new CssElementVisitor(this){

            @Override
            public void visitCssImport(CssImport _import) {
                result.add(_import);
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                element.acceptChildren((PsiElementVisitor)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/CssStubStylesheet$1", "visitElement"));
            }
        });
        return result;
    }

    public CssRuleset addRuleset(@NotNull CssRuleset ruleset) throws IncorrectOperationException {
        PsiElement psiElement;
        PsiElement wrapper;
        if (ruleset == null) {
            CssStubStylesheet.$$$reportNull$$$0(11);
        }
        if ((wrapper = ruleset.getParent()) instanceof CssRulesetWrappingElement && ((CssRulesetWrappingElement)wrapper).getRulesets().length == 1) {
            CssRulesetWrappingElement newWrapper = (CssRulesetWrappingElement)this.getRulesetList().add(wrapper);
            psiElement = (PsiElement)ArrayUtil.getFirstElement((Object[])newWrapper.getRulesets());
        } else {
            psiElement = this.getRulesetList().add((PsiElement)ruleset);
        }
        return (CssRuleset)psiElement;
    }

    @Nullable
    public CssCharset getCharset() {
        return (CssCharset)PsiTreeUtil.getChildOfType((PsiElement)this, CssCharsetImpl.class);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            CssStubStylesheet.$$$reportNull$$$0(12);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssStylesheet(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssStubStylesheet";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleset";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssStubStylesheet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRulesetList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaces";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectAllStubImports";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addRuleset";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

