/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.util.CssSuffixes;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CssTermTypeUtil {
    public static final Set<String> CUSTOM_VALUES = Set.of("rpx", "upx");

    private CssTermTypeUtil() {
    }

    @NotNull
    public static CssTermType getTypeBySuffix(@NotNull String suffixText) {
        if (suffixText == null) {
            CssTermTypeUtil.$$$reportNull$$$0(0);
        }
        if ("fr".equalsIgnoreCase(suffixText = StringUtil.toLowerCase((String)suffixText))) {
            CssTermType cssTermType = CssTermTypes.FLEX;
            if (cssTermType == null) {
                CssTermTypeUtil.$$$reportNull$$$0(1);
            }
            return cssTermType;
        }
        if (CssTermTypeUtil.contains(CssSuffixes.LENGTH_SUFFIXES, suffixText) || CUSTOM_VALUES.contains(suffixText)) {
            CssTermType cssTermType = CssTermTypes.LENGTH;
            if (cssTermType == null) {
                CssTermTypeUtil.$$$reportNull$$$0(2);
            }
            return cssTermType;
        }
        if (CssTermTypeUtil.contains(CssSuffixes.FREQUENCY_SUFFIXES, suffixText)) {
            CssTermType cssTermType = CssTermTypes.FREQUENCY;
            if (cssTermType == null) {
                CssTermTypeUtil.$$$reportNull$$$0(3);
            }
            return cssTermType;
        }
        if (CssTermTypeUtil.contains(CssSuffixes.TIME_SUFFIXES, suffixText)) {
            CssTermType cssTermType = CssTermTypes.TIME;
            if (cssTermType == null) {
                CssTermTypeUtil.$$$reportNull$$$0(4);
            }
            return cssTermType;
        }
        if (CssTermTypeUtil.contains(CssSuffixes.RESOLUTION_SUFFIXES, suffixText)) {
            CssTermType cssTermType = CssTermTypes.RESOLUTION;
            if (cssTermType == null) {
                CssTermTypeUtil.$$$reportNull$$$0(5);
            }
            return cssTermType;
        }
        if (CssTermTypeUtil.contains(CssSuffixes.ANGLE_SUFFIXES, suffixText)) {
            CssTermType cssTermType = CssTermTypes.ANGLE;
            if (cssTermType == null) {
                CssTermTypeUtil.$$$reportNull$$$0(6);
            }
            return cssTermType;
        }
        if ("dB".equalsIgnoreCase(suffixText)) {
            CssTermType cssTermType = CssTermTypes.DECIBEL;
            if (cssTermType == null) {
                CssTermTypeUtil.$$$reportNull$$$0(7);
            }
            return cssTermType;
        }
        if ("st".equalsIgnoreCase(suffixText)) {
            CssTermType cssTermType = CssTermTypes.SEMITONES;
            if (cssTermType == null) {
                CssTermTypeUtil.$$$reportNull$$$0(8);
            }
            return cssTermType;
        }
        if (StringUtil.startsWithIgnoreCase((String)suffixText, (String)"e") && StringUtil.parseInt((String)suffixText.substring(1), (int)0) != 0) {
            CssTermType cssTermType = CssTermTypes.NUMBER;
            if (cssTermType == null) {
                CssTermTypeUtil.$$$reportNull$$$0(9);
            }
            return cssTermType;
        }
        CssTermType cssTermType = CssTermType.UNKNOWN;
        if (cssTermType == null) {
            CssTermTypeUtil.$$$reportNull$$$0(10);
        }
        return cssTermType;
    }

    private static boolean contains(String[] array, String value) {
        for (String item : array) {
            if (!item.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTimeSuffix(@NotNull String s) {
        if (s == null) {
            CssTermTypeUtil.$$$reportNull$$$0(11);
        }
        return Arrays.asList(CssSuffixes.TIME_SUFFIXES).contains(s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffixText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/util/CssTermTypeUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/util/CssTermTypeUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeBySuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeBySuffix";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isTimeSuffix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

