/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.MultiRootJSLinterLanguageServiceManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierLanguageServiceImpl;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/intellij/prettierjs/PrettierLanguageServiceManager;", "Lcom/intellij/lang/javascript/linter/MultiRootJSLinterLanguageServiceManager;", "Lcom/intellij/prettierjs/PrettierLanguageServiceImpl;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getCs$intellij_prettierJS", "()Lkotlinx/coroutines/CoroutineScope;", "inactivityTimeoutMs", "", "getInactivityTimeoutMs", "()I", "createServiceInstance", "resolvedPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "workingDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.prettierJS"})
public final class PrettierLanguageServiceManager
extends MultiRootJSLinterLanguageServiceManager<PrettierLanguageServiceImpl> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;

    public PrettierLanguageServiceManager(final @NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        super(project, "prettier");
        this.cs = cs;
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkFileListener(){

            public void after(List<? extends VFileEvent> events) {
                boolean needReload;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block11: {
                    Intrinsics.checkNotNullParameter(events, (String)"events");
                    $this$any$iv = events;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v0 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl;
                            VFileEvent ev = (VFileEvent)element$iv;
                            boolean bl2 = false;
                            if (ev.getFile() == null) {
                                bl = false;
                            } else {
                                String name;
                                VirtualFile file;
                                Intrinsics.checkNotNullExpressionValue((Object)file.getName(), (String)"getName(...)");
                                bl = !(!(ev instanceof VFileContentChangeEvent) && !(ev instanceof VFileCreateEvent) && !(ev instanceof VFileDeleteEvent) && !(ev instanceof VFilePropertyChangeEvent) || !PrettierUtil.isConfigFileOrPackageJson(file) && !Intrinsics.areEqual((Object)name, (Object)".editorconfig"));
                            }
                            if (!bl) continue;
                            v0 = true;
                            break block11;
                        }
                        v0 = needReload = false;
                    }
                }
                if (needReload) {
                    this.terminateServices();
                    if (PrettierConfiguration.getInstance(project).getCodeStyleSettingsModifierEnabled()) {
                        boolean bl;
                        block12: {
                            $this$any$iv = events;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    VFileEvent it = (VFileEvent)element$iv;
                                    boolean bl3 = false;
                                    if (!it.isFromSave()) continue;
                                    bl = true;
                                    break block12;
                                }
                                bl = false;
                            }
                        }
                        if (bl) {
                            CodeStyleSettingsManager.getInstance((Project)project).notifyCodeStyleSettingsChanged();
                        }
                    }
                }
            }
        });
    }

    @NotNull
    public final CoroutineScope getCs$intellij_prettierJS() {
        return this.cs;
    }

    public final int getInactivityTimeoutMs() {
        return Registry.Companion.intValue("prettier.service.expiration.timeout.ms", (int)TimeUnit.MINUTES.toMillis(5L));
    }

    @NotNull
    protected PrettierLanguageServiceImpl createServiceInstance(@NotNull NodePackage resolvedPackage, @NotNull VirtualFile workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)resolvedPackage, (String)"resolvedPackage");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return new PrettierLanguageServiceImpl(project, workingDirectory);
    }

    @JvmStatic
    @NotNull
    public static final PrettierLanguageServiceManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/prettierjs/PrettierLanguageServiceManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/prettierjs/PrettierLanguageServiceManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.prettierJS"})
    @SourceDebugExtension(value={"SMAP\nPrettierLanguageServiceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierLanguageServiceManager.kt\ncom/intellij/prettierjs/PrettierLanguageServiceManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,69:1\n30#2,2:70\n*S KotlinDebug\n*F\n+ 1 PrettierLanguageServiceManager.kt\ncom/intellij/prettierjs/PrettierLanguageServiceManager$Companion\n*L\n66#1:70,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PrettierLanguageServiceManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PrettierLanguageServiceManager> serviceClass$iv = PrettierLanguageServiceManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PrettierLanguageServiceManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

