/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.el.impl.ElBundle;
import com.intellij.javaee.el.inspections.ELValidationInspection;
import com.intellij.javaee.el.psi.ELExpression;
import com.intellij.javaee.el.psi.ELMethodCallExpression;
import com.intellij.javaee.el.psi.ELParameterList;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.javaee.el.references.ELReference;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.spring.el.psi.SpringELExpression;
import com.intellij.spring.el.psi.SpringELGeneratedVisitor;
import com.intellij.spring.el.psi.SpringELLiteralExpression;
import com.intellij.spring.el.psi.SpringELMethodCallExpression;
import com.intellij.spring.el.psi.SpringELParameterList;
import com.intellij.spring.el.psi.SpringELQualifiedType;
import com.intellij.spring.el.psi.SpringELVariable;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.NotNull;

public final class SpringElInspection
extends ELValidationInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        Module module;
        if (holder == null) {
            SpringElInspection.$$$reportNull$$$0(0);
        }
        if (!SpringCommonUtils.isSpringConfigured((Module)(module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder.getFile())))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SpringElInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new SpringELGeneratedVisitor(){

            @Override
            public void visitELVariable(@NotNull SpringELVariable o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                SpringElInspection.this.visitVariable(o, isOnTheFly, holder);
            }

            @Override
            public void visitELLiteralExpression(@NotNull SpringELLiteralExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                SpringElInspection.this.visitLiteral(o, holder);
            }

            @Override
            public void visitELQualifiedType(@NotNull SpringELQualifiedType o) {
                PsiReference[] references;
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (PsiReference reference : references = o.getReferences()) {
                    if (reference.resolve() != null) continue;
                    holder.registerProblem(reference);
                }
            }

            @Override
            public void visitELExpression(@NotNull SpringELExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.visitOuterLanguageElement((OuterLanguageElement)o);
            }

            @Override
            public void visitELParameterList(@NotNull SpringELParameterList o) {
                if (o == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.visitOuterLanguageElement((OuterLanguageElement)o);
            }

            @Override
            public void visitELMethodCallExpression(@NotNull SpringELMethodCallExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(5);
                }
                super.visitELMethodCallExpression(o);
                SpringElInspection.validateMethodCallExpression(o, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/intellij/spring/el/inspections/SpringElInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELVariable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELLiteralExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELQualifiedType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELParameterList";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELMethodCallExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected void checkVariableReference(ELVariable variable, PsiReference reference, boolean isOnTheFly, ProblemsHolder holder) {
        super.checkVariableReference(variable, reference, isOnTheFly, holder);
        if (!(reference instanceof ELReference) && reference.resolve() == null && !variable.getTextRange().isEmpty()) {
            holder.registerProblem(reference);
        }
    }

    private static void validateMethodCallExpression(@NotNull ELMethodCallExpression methodCallExpression, @NotNull ProblemsHolder holder) {
        ELVariable elVariable;
        if (methodCallExpression == null) {
            SpringElInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            SpringElInspection.$$$reportNull$$$0(3);
        }
        if ((elVariable = methodCallExpression.getMethod()) == null) {
            return;
        }
        PsiReference[] references = elVariable.getReferences();
        if (references.length == 0) {
            return;
        }
        PsiElement element = references[0].resolve();
        if (element instanceof PsiMethod) {
            boolean vararg;
            PsiParameter[] psiParameters = ((PsiMethod)element).getParameterList().getParameters();
            ELParameterList parameterList = methodCallExpression.getParameterList();
            ELExpression[] parameters = parameterList != null ? parameterList.getParameters() : null;
            boolean bl = vararg = psiParameters.length > 0 && psiParameters[psiParameters.length - 1].isVarArgs();
            if (parameters != null && (!vararg && parameters.length != psiParameters.length || vararg && parameters.length < psiParameters.length - 1)) {
                holder.registerProblem((PsiElement)parameterList, ElBundle.message((String)"el.mismatched.parameters.count", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/el/inspections/SpringElInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/el/inspections/SpringElInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validateMethodCallExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

