/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.AlterProducerBase;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.base.generator.producers.TruncateProducer;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteAlterCheck;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteAlterForeignKey;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteAlterIndex;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteAlterKey;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteAlterModule;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteAlterRoutine;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteAlterSchema;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteAlterTable;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteAlterTableColumn;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteAlterTrigger;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteAlterView;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteAlterViewColumn;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteAlterVirtualTableColumn;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteCreateCheck;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteCreateForeignKey;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteCreateIndex;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteCreateKey;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteCreateModule;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteCreateRoutine;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteCreateTable;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteCreateTableColumn;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteCreateTrigger;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteCreateView;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteCreateViewColumn;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteCreateVirtualTable;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteCreateVirtualTableColumn;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteDropIndex;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteDropModule;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteDropRoutine;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteDropTable;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteDropTrigger;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteDropView;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteDropVirtualTable;
import com.intellij.database.dialects.sqlite.generator.producers.SqliteTruncateTable;
import com.intellij.database.dialects.sqlite.model.SqliteCheck;
import com.intellij.database.dialects.sqlite.model.SqliteCollation;
import com.intellij.database.dialects.sqlite.model.SqliteForeignKey;
import com.intellij.database.dialects.sqlite.model.SqliteIndex;
import com.intellij.database.dialects.sqlite.model.SqliteKey;
import com.intellij.database.dialects.sqlite.model.SqliteModule;
import com.intellij.database.dialects.sqlite.model.SqliteRoutine;
import com.intellij.database.dialects.sqlite.model.SqliteSchema;
import com.intellij.database.dialects.sqlite.model.SqliteTable;
import com.intellij.database.dialects.sqlite.model.SqliteTableColumn;
import com.intellij.database.dialects.sqlite.model.SqliteTrigger;
import com.intellij.database.dialects.sqlite.model.SqliteView;
import com.intellij.database.dialects.sqlite.model.SqliteViewColumn;
import com.intellij.database.dialects.sqlite.model.SqliteVirtualTable;
import com.intellij.database.dialects.sqlite.model.SqliteVirtualTableColumn;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptLocus;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingTask;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\"\u0010\u0012\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\u001c\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\b\u001a\u00020\t2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0016J\u001c\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010#\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030%\u0018\u00010$2\u0006\u0010&\u001a\u00020'H\u0016J\u0014\u0010(\u001a\u00020\f2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030%H\u0016\u00a8\u0006*"}, d2={"Lcom/intellij/database/dialects/sqlite/generator/SqliteScriptGeneratorHelper;", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "<init>", "()V", "script", "", "d", "Lcom/intellij/database/model/DataType;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "contextSchema", "canGenerateHere", "", "locus", "Lcom/intellij/database/script/generator/ScriptLocus;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "canGenerateElementRightNow", "isIndexExplicitFor", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "key", "Lcom/intellij/database/model/basic/BasicKey;", "shouldGenerateOutsideTable", "it", "createProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducer;", "createDropProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/DropProducer;", "createAlterProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducerBase;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "createTruncateProducer", "Lcom/intellij/database/dialects/base/generator/producers/TruncateProducer;", "availableOptions", "", "Lcom/intellij/database/script/generator/ScriptingOption;", "task", "Lcom/intellij/database/script/generator/ScriptingTask;", "isOptionSupported", "option", "intellij.database.dialects.sqlite"})
public final class SqliteScriptGeneratorHelper
extends ScriptGeneratorHelper {
    @NotNull
    public static final SqliteScriptGeneratorHelper INSTANCE = new SqliteScriptGeneratorHelper();

    private SqliteScriptGeneratorHelper() {
        Dbms dbms = Dbms.SQLITE;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"SQLITE");
        super(dbms);
    }

    @NotNull
    public String script(@NotNull DataType d, @Nullable ScriptingContext context, @Nullable String contextSchema) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        if (d == DataType.UNKNOWN) {
            return "";
        }
        return super.script(d, context, contextSchema);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canGenerateHere(@NotNull ScriptingContext context, @NotNull ScriptLocus locus, @Nullable BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)locus, (String)"locus");
        if (locus == ScriptLocus.IN_TABLE) {
            if (element instanceof SqliteCheck) return true;
        }
        if (!super.canGenerateHere(context, locus, element)) return false;
        if (WhenMappings.$EnumSwitchMapping$0[locus.ordinal()] != 1) return true;
        if (!(element instanceof SqliteKey)) return true;
        BasicIndex basicIndex = ((SqliteKey)element).getUnderlyingIndex();
        if (!(basicIndex instanceof SqliteIndex)) return true;
        SqliteIndex sqliteIndex = (SqliteIndex)basicIndex;
        if (sqliteIndex == null) return true;
        SqliteIndex it = sqliteIndex;
        boolean bl = false;
        if (!it.getReverseColNames().isEmpty() && !((SqliteKey)element).isPrimary()) {
            return false;
        }
        if (it.getColNames().size() != ((SqliteKey)element).getColNames().size()) {
            return true;
        }
        boolean bl2 = it.getColumnCollations().isEmpty();
        if (!bl2) return false;
        return true;
    }

    protected boolean canGenerateElementRightNow(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!super.canGenerateElementRightNow(context, element)) {
            return false;
        }
        if (!(element instanceof SqliteKey) || ((SqliteKey)element).getColNames().size() != 1) {
            return true;
        }
        SqliteIndex index = (SqliteIndex)((SqliteKey)element).getUnderlyingIndex();
        if (index == null || index.getColNames().size() != ((SqliteKey)element).getColNames().size()) {
            return true;
        }
        List<? extends SqliteCollation> list = index.getColumnCollations();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getColumnCollations(...)");
        List<? extends SqliteCollation> collations = list;
        return collations.isEmpty();
    }

    public boolean isIndexExplicitFor(@NotNull ScriptingContext context, @Nullable BasicIndex index, @NotNull BasicKey key) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return index != null && index.getNaturalName() != null && (index.getColNames().size() != key.getColNames().size() || !Intrinsics.areEqual((Object)index.getName(), (Object)key.getName()));
    }

    public boolean shouldGenerateOutsideTable(@NotNull ScriptingContext context, @NotNull BasicKey it) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    @NotNull
    public CreateProducer<?> createProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof SqliteVirtualTable ? (CreateProducer)new SqliteCreateVirtualTable(context, (SqliteVirtualTable)element) : (basicElement instanceof SqliteTable ? (CreateProducer)new SqliteCreateTable(context, (SqliteTable)element) : (basicElement instanceof SqliteIndex ? (CreateProducer)new SqliteCreateIndex(context, (SqliteIndex)element) : (basicElement instanceof SqliteRoutine ? (CreateProducer)new SqliteCreateRoutine(context, (SqliteRoutine)element) : (basicElement instanceof SqliteModule ? (CreateProducer)new SqliteCreateModule(context, (SqliteModule)element) : (basicElement instanceof SqliteForeignKey ? (CreateProducer)new SqliteCreateForeignKey(context, (SqliteForeignKey)element) : (basicElement instanceof SqliteViewColumn ? (CreateProducer)new SqliteCreateViewColumn(context, (SqliteViewColumn)element) : (basicElement instanceof SqliteVirtualTableColumn ? (CreateProducer)new SqliteCreateVirtualTableColumn(context, (SqliteVirtualTableColumn)element) : (basicElement instanceof SqliteTableColumn ? (CreateProducer)new SqliteCreateTableColumn(context, (SqliteTableColumn)element) : (basicElement instanceof SqliteKey ? (CreateProducer)new SqliteCreateKey(context, (SqliteKey)element) : (basicElement instanceof SqliteTrigger ? (CreateProducer)new SqliteCreateTrigger(context, (SqliteTrigger)element) : (basicElement instanceof SqliteCheck ? (CreateProducer)new SqliteCreateCheck(context, (SqliteCheck)element) : (basicElement instanceof SqliteView ? (CreateProducer)new SqliteCreateView(context, (SqliteView)element) : super.createProducerImpl(context, element)))))))))))));
    }

    @NotNull
    public DropProducer<?> createDropProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof SqliteVirtualTable ? (DropProducer)new SqliteDropVirtualTable(context, (SqliteVirtualTable)element) : (basicElement instanceof SqliteTable ? (DropProducer)new SqliteDropTable(context, (SqliteTable)element) : (basicElement instanceof SqliteView ? (DropProducer)new SqliteDropView(context, (SqliteView)element) : (basicElement instanceof SqliteTrigger ? (DropProducer)new SqliteDropTrigger(context, (SqliteTrigger)element) : (basicElement instanceof SqliteIndex ? (DropProducer)new SqliteDropIndex(context, (SqliteIndex)element) : (basicElement instanceof SqliteRoutine ? (DropProducer)new SqliteDropRoutine(context, (SqliteRoutine)element) : (basicElement instanceof SqliteModule ? (DropProducer)new SqliteDropModule(context, (SqliteModule)element) : super.createDropProducerImpl(context, element)))))));
    }

    @NotNull
    public AlterProducerBase<?> createAlterProducerImpl(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        BasicElement it = elements.getSourceElement();
        boolean bl = false;
        BasicElement basicElement = it;
        return basicElement instanceof SqliteSchema ? (AlterProducerBase)new SqliteAlterSchema(context, (ElementAlteration<? extends SqliteSchema>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof SqliteTable ? (AlterProducerBase)new SqliteAlterTable(context, (ElementAlteration<? extends SqliteTable>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof SqliteView ? (AlterProducerBase)new SqliteAlterView(context, (ElementAlteration<? extends SqliteView>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof SqliteViewColumn ? (AlterProducerBase)new SqliteAlterViewColumn(context, (ElementAlteration<? extends SqliteViewColumn>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof SqliteVirtualTableColumn ? (AlterProducerBase)new SqliteAlterVirtualTableColumn(context, (ElementAlteration<? extends SqliteVirtualTableColumn>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof SqliteTableColumn ? (AlterProducerBase)new SqliteAlterTableColumn(context, (ElementAlteration<? extends SqliteTableColumn>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof SqliteCheck ? (AlterProducerBase)new SqliteAlterCheck(context, (ElementAlteration<? extends SqliteCheck>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof SqliteKey ? (AlterProducerBase)new SqliteAlterKey(context, (ElementAlteration<? extends SqliteKey>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof SqliteForeignKey ? (AlterProducerBase)new SqliteAlterForeignKey(context, (ElementAlteration<? extends SqliteForeignKey>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof SqliteTrigger ? (AlterProducerBase)new SqliteAlterTrigger(context, (ElementAlteration<? extends SqliteTrigger>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof SqliteIndex ? (AlterProducerBase)new SqliteAlterIndex(context, (ElementAlteration<? extends SqliteIndex>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof SqliteRoutine ? (AlterProducerBase)new SqliteAlterRoutine(context, (ElementAlteration<? extends SqliteRoutine>)BaseProducersKt.cast(elements, (BasicElement)it)) : (basicElement instanceof SqliteModule ? (AlterProducerBase)new SqliteAlterModule(context, (ElementAlteration<? extends SqliteModule>)BaseProducersKt.cast(elements, (BasicElement)it)) : super.createAlterProducerImpl(context, elements)))))))))))));
    }

    @NotNull
    public TruncateProducer<?> createTruncateProducer(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof SqliteTable ? (TruncateProducer)new SqliteTruncateTable(context, (SqliteTable)element) : new TruncateProducer(context, element);
    }

    @Nullable
    public Set<ScriptingOption<?>> availableOptions(@NotNull ScriptingTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return WhenMappings.$EnumSwitchMapping$1[task.getCategory().ordinal()] == 1 ? SetsKt.emptySet() : super.availableOptions(task);
    }

    public boolean isOptionSupported(@NotNull ScriptingOption<?> option) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        return Intrinsics.areEqual(option, (Object)ScriptingOptionStatic.IF_EXISTS) ? true : super.isOptionSupported(option);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ScriptLocus.values().length];
            try {
                nArray[ScriptLocus.IN_COLUMN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ScriptCategory.values().length];
            try {
                nArray[ScriptCategory.TRUNCATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

