/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.google.common.collect.Maps;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonCodeStyleService;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstStatement;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.codeInsight.completion.OverwriteEqualsInsertHandler;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.mlcompletion.PyCompletionMlElementInfo;
import com.jetbrains.python.codeInsight.mlcompletion.PyCompletionMlElementKind;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyCustomPackageIdentifier;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyEllipsisLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyExpressionCodeFragmentImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.stubs.PyLiteralKind;
import com.jetbrains.python.psi.stubs.PySetuptoolsNamespaceIndex;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiStubSuppressor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class PyUtil {
    private static final boolean VERBOSE_MODE = System.getenv().get("_PYCHARM_VERBOSE_MODE") != null;

    private PyUtil() {
    }

    @NotNull
    public static List<PyExpression> flattenedParensAndTuples(PyExpression ... targets) {
        List list = PyUtilCore.flattenedParensAndTuples((PyAstExpression[])targets);
        if (list == null) {
            PyUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static List<PyExpression> flattenedParensAndLists(PyExpression ... targets) {
        List list = PyUtilCore.flattenedParensAndLists((PyAstExpression[])targets);
        if (list == null) {
            PyUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<PyExpression> flattenedParensAndStars(PyExpression ... targets) {
        List list = PyUtilCore.flattenedParensAndStars((PyAstExpression[])targets);
        if (list == null) {
            PyUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    @NlsSafe
    public static String getReadableRepr(PsiElement elt, boolean cutAtEOL) {
        if (elt == null) {
            return "null!";
        }
        ASTNode node = elt.getNode();
        if (node == null) {
            return "null";
        }
        String s = node.getText();
        int cut_pos = cutAtEOL ? s.indexOf(10) : -1;
        if (cut_pos < 0) {
            cut_pos = s.length();
        }
        String string = s.substring(0, Math.min(cut_pos, s.length()));
        if (string == null) {
            PyUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static PyClass getContainingClassOrSelf(PsiElement element) {
        PsiElement current;
        for (current = element; current != null && !(current instanceof PyClass); current = current.getParent()) {
        }
        return (PyClass)current;
    }

    @Nullable
    public static PyFile getContainingPyFile(PyElement element) {
        PsiFile containingFile = element.getContainingFile();
        return containingFile instanceof PyFile ? (PyFile)containingFile : null;
    }

    @NonNls
    public static String nvl(Object s) {
        if (s != null) {
            return "'" + s.toString() + "'";
        }
        return "null";
    }

    public static void addListNode(PsiElement parent, PsiElement newItem, ASTNode beforeThis, boolean isFirst, boolean isLast, boolean addWhitespace) {
        ASTNode node = parent.getNode();
        assert (node != null);
        ASTNode itemNode = newItem.getNode();
        assert (itemNode != null);
        Project project = parent.getProject();
        PyElementGenerator gen = PyElementGenerator.getInstance((Project)project);
        if (!isFirst) {
            node.addChild(gen.createComma(), beforeThis);
        }
        node.addChild(itemNode, beforeThis);
        if (!isLast) {
            node.addChild(gen.createComma(), beforeThis);
        }
        if (addWhitespace) {
            node.addChild((ASTNode)ASTFactory.whitespace((CharSequence)" "), beforeThis);
        }
    }

    @NotNull
    public static <T> T sure(T thing) {
        if (thing == null) {
            throw new IncorrectOperationException();
        }
        T t = thing;
        if (t == null) {
            PyUtil.$$$reportNull$$$0(4);
        }
        return t;
    }

    public static void sure(boolean thing) {
        if (!thing) {
            throw new IncorrectOperationException();
        }
    }

    public static boolean isAttribute(PyTargetExpression ex) {
        return PyUtil.isInstanceAttribute((PyExpression)ex) || PyUtil.isClassAttribute((PsiElement)ex);
    }

    public static boolean isInstanceAttribute(PyExpression target) {
        PyFunction method;
        if (!(target instanceof PyTargetExpression)) {
            return false;
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)target);
        if (owner instanceof PyFunction && (method = (PyFunction)owner).getContainingClass() != null) {
            if (method.getStub() != null) {
                return true;
            }
            PyParameter[] params = method.getParameterList().getParameters();
            if (params.length > 0) {
                PyTargetExpression targetExpr = (PyTargetExpression)target;
                PyExpression qualifier = targetExpr.getQualifier();
                return qualifier != null && qualifier.getText().equals(params[0].getName());
            }
        }
        return false;
    }

    public static boolean isClassAttribute(PsiElement element) {
        return element instanceof PyTargetExpression && ScopeUtil.getScopeOwner(element) instanceof PyClass;
    }

    public static boolean hasIfNameEqualsMain(@NotNull PyFile file) {
        PyIfStatement dunderMain;
        if (file == null) {
            PyUtil.$$$reportNull$$$0(5);
        }
        return (dunderMain = (PyIfStatement)SyntaxTraverser.psiApi().children((Object)file).filterMap(psi -> psi instanceof PyIfStatement ? (PyIfStatement)psi : null).find(ifStatement -> PyUtil.isIfNameEqualsMain(ifStatement))) != null;
    }

    public static boolean isIfNameEqualsMain(PyIfStatement ifStatement) {
        PyExpression condition = ifStatement.getIfPart().getCondition();
        return PyUtil.isNameEqualsMain(condition);
    }

    private static boolean isNameEqualsMain(PyExpression condition) {
        if (condition instanceof PyParenthesizedExpression) {
            return PyUtil.isNameEqualsMain(((PyParenthesizedExpression)condition).getContainedExpression());
        }
        if (condition instanceof PyBinaryExpression) {
            PyBinaryExpression binaryExpression = (PyBinaryExpression)condition;
            if (binaryExpression.getOperator() == PyTokenTypes.OR_KEYWORD) {
                return PyUtil.isNameEqualsMain(binaryExpression.getLeftExpression()) || PyUtil.isNameEqualsMain(binaryExpression.getRightExpression());
            }
            PyExpression pyExpression = binaryExpression.getRightExpression();
            if (pyExpression instanceof PyStringLiteralExpression) {
                PyStringLiteralExpression rhs = (PyStringLiteralExpression)pyExpression;
                return binaryExpression.getOperator() == PyTokenTypes.EQEQ && binaryExpression.getLeftExpression().getText().equals("__name__") && rhs.getStringValue().equals("__main__");
            }
        }
        return false;
    }

    @Nullable
    public static List<PsiElement> searchForWrappingMethod(PsiElement start, boolean deep) {
        PsiElement seeker = start;
        ArrayList<PsiElement> ret = new ArrayList<PsiElement>(2);
        while (seeker != null) {
            PyFunction func = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)seeker, PyFunction.class, (boolean)true, (Class[])new Class[]{PyClass.class});
            if (func != null) {
                PyClass cls = func.getContainingClass();
                if (cls != null) {
                    ret.add((PsiElement)func);
                    ret.add((PsiElement)cls);
                    return ret;
                }
                if (deep) {
                    ret.add((PsiElement)func);
                    seeker = func;
                    continue;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static boolean inSameFile(@NotNull PsiElement e1, @NotNull PsiElement e2) {
        if (e1 == null) {
            PyUtil.$$$reportNull$$$0(6);
        }
        if (e2 == null) {
            PyUtil.$$$reportNull$$$0(7);
        }
        PsiFile f1 = e1.getContainingFile();
        PsiFile f2 = e2.getContainingFile();
        if (f1 == null || f2 == null) {
            return false;
        }
        return f1 == f2;
    }

    public static boolean isTopLevel(@NotNull PsiElement element) {
        if (element == null) {
            PyUtil.$$$reportNull$$$0(8);
        }
        return PyUtilCore.isTopLevel((PsiElement)element);
    }

    public static void deletePycFiles(String pyFilePath) {
        if (pyFilePath.endsWith(".py")) {
            File file;
            File pycache;
            File pyo;
            ArrayList<File> filesToDelete = new ArrayList<File>();
            File pyc = new File(pyFilePath + "c");
            if (pyc.exists()) {
                filesToDelete.add(pyc);
            }
            if ((pyo = new File(pyFilePath + "o")).exists()) {
                filesToDelete.add(pyo);
            }
            if ((pycache = new File((file = new File(pyFilePath)).getParentFile(), "__pycache__")).isDirectory()) {
                String shortName = FileUtilRt.getNameWithoutExtension((String)file.getName());
                Collections.addAll(filesToDelete, pycache.listFiles(pathname -> {
                    if (!FileUtilRt.extensionEquals((String)pathname.getName(), (String)"pyc")) {
                        return false;
                    }
                    String nameWithMagic = FileUtilRt.getNameWithoutExtension((String)pathname.getName());
                    return FileUtilRt.getNameWithoutExtension((String)nameWithMagic).equals(shortName);
                }));
            }
            FileUtil.asyncDelete(filesToDelete);
        }
    }

    public static String getElementNameWithoutExtension(PsiNamedElement psiNamedElement) {
        return psiNamedElement instanceof PyFile ? FileUtilRt.getNameWithoutExtension((String)((PyFile)psiNamedElement).getName()) : psiNamedElement.getName();
    }

    public static boolean hasUnresolvedAncestors(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PyUtil.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PyUtil.$$$reportNull$$$0(10);
        }
        for (PyClassLikeType type : cls.getAncestorTypes(context)) {
            if (type != null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static AccessDirection getPropertyAccessDirection(@NotNull PyFunction function) {
        Property property;
        if (function == null) {
            PyUtil.$$$reportNull$$$0(11);
        }
        if ((property = function.getProperty()) != null) {
            if (property.getGetter().valueOrNull() == function) {
                AccessDirection accessDirection = AccessDirection.READ;
                if (accessDirection == null) {
                    PyUtil.$$$reportNull$$$0(12);
                }
                return accessDirection;
            }
            if (property.getSetter().valueOrNull() == function) {
                AccessDirection accessDirection = AccessDirection.WRITE;
                if (accessDirection == null) {
                    PyUtil.$$$reportNull$$$0(13);
                }
                return accessDirection;
            }
            if (property.getDeleter().valueOrNull() == function) {
                AccessDirection accessDirection = AccessDirection.DELETE;
                if (accessDirection == null) {
                    PyUtil.$$$reportNull$$$0(14);
                }
                return accessDirection;
            }
        }
        AccessDirection accessDirection = AccessDirection.READ;
        if (accessDirection == null) {
            PyUtil.$$$reportNull$$$0(15);
        }
        return accessDirection;
    }

    public static void removeQualifier(@NotNull PyReferenceExpression element) {
        PyExpression calleeQualifier;
        PyExpression callee;
        PyExpression qualifier;
        if (element == null) {
            PyUtil.$$$reportNull$$$0(16);
        }
        if ((qualifier = element.getQualifier()) == null) {
            return;
        }
        if (qualifier instanceof PyCallExpression && (callee = ((PyCallExpression)qualifier).getCallee()) instanceof PyReferenceExpression && (calleeQualifier = ((PyReferenceExpression)callee).getQualifier()) != null) {
            qualifier.replace((PsiElement)calleeQualifier);
            return;
        }
        PsiElement dot = PyPsiUtils.getNextNonWhitespaceSibling((PsiElement)qualifier);
        if (dot != null) {
            dot.delete();
        }
        qualifier.delete();
    }

    public static boolean isOwnScopeComprehension(@NotNull PyComprehensionElement comprehension) {
        if (comprehension == null) {
            PyUtil.$$$reportNull$$$0(17);
        }
        boolean isAtLeast30 = !LanguageLevel.forElement((PsiElement)comprehension).isPython2();
        boolean isListComprehension = comprehension instanceof PyListCompExpression;
        return !isListComprehension || isAtLeast30;
    }

    public static ASTNode createNewName(PyElement element, String name) {
        return PyElementGenerator.getInstance((Project)element.getProject()).createNameIdentifier(name, LanguageLevel.forElement((PsiElement)element));
    }

    @NotNull
    public static PsiElement resolveToTheTop(@NotNull PsiElement elementToResolve) {
        PsiElement resolve;
        PsiReference reference;
        if (elementToResolve == null) {
            PyUtil.$$$reportNull$$$0(18);
        }
        PsiElement currentElement = elementToResolve;
        HashSet<PsiElement> checkedElements = new HashSet<PsiElement>();
        while ((reference = currentElement.getReference()) != null && (resolve = reference.resolve()) != null && !checkedElements.contains(resolve) && !resolve.equals((Object)currentElement) && PyUtil.inSameFile(resolve, currentElement)) {
            currentElement = resolve;
            checkedElements.add(resolve);
        }
        PsiElement psiElement = currentElement;
        if (psiElement == null) {
            PyUtil.$$$reportNull$$$0(19);
        }
        return psiElement;
    }

    public static @NotNull List<@Nullable PsiElement> multiResolveTopPriority(@NotNull PsiElement element, @NotNull PyResolveContext resolveContext) {
        if (element == null) {
            PyUtil.$$$reportNull$$$0(20);
        }
        if (resolveContext == null) {
            PyUtil.$$$reportNull$$$0(21);
        }
        if (element instanceof PyReferenceOwner) {
            PyReferenceOwner referenceOwner = (PyReferenceOwner)element;
            return PyUtil.multiResolveTopPriority(referenceOwner.getReference(resolveContext));
        }
        PsiReference reference = element.getReference();
        List<PsiElement> list = reference != null ? Collections.singletonList(reference.resolve()) : Collections.emptyList();
        if (list == null) {
            PyUtil.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public static @NotNull List<@NotNull PsiElement> multiResolveTopPriority(@NotNull PsiPolyVariantReference reference) {
        if (reference == null) {
            PyUtil.$$$reportNull$$$0(23);
        }
        return PyUtil.filterTopPriorityElements(Arrays.asList(reference.multiResolve(false)));
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static List<PsiElement> filterTopPriorityResults(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            PyUtil.$$$reportNull$$$0(24);
        }
        if (resolveResults.length == 0) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PyUtil.$$$reportNull$$$0(25);
            }
            return list;
        }
        int maxRate = PyUtil.getMaxRate(Arrays.asList(resolveResults));
        List list = ((StreamEx)StreamEx.of((Object[])resolveResults).filter(resolveResult -> PyUtil.getRate(resolveResult) >= maxRate)).map(ResolveResult::getElement).nonNull().toList();
        if (list == null) {
            PyUtil.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    public static <E extends ResolveResult> List<E> filterTopPriorityResults(@NotNull List<? extends E> resolveResults) {
        if (resolveResults == null) {
            PyUtil.$$$reportNull$$$0(27);
        }
        if (resolveResults.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                PyUtil.$$$reportNull$$$0(28);
            }
            return list;
        }
        int maxRate = PyUtil.getMaxRate(resolveResults);
        List list = ContainerUtil.filter(resolveResults, resolveResult -> PyUtil.getRate(resolveResult) >= maxRate);
        if (list == null) {
            PyUtil.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    public static <E extends ResolveResult> List<PsiElement> filterTopPriorityElements(@NotNull List<? extends E> resolveResults) {
        if (resolveResults == null) {
            PyUtil.$$$reportNull$$$0(30);
        }
        List list = ContainerUtil.mapNotNull(PyUtil.filterTopPriorityResults(resolveResults), ResolveResult::getElement);
        if (list == null) {
            PyUtil.$$$reportNull$$$0(31);
        }
        return list;
    }

    private static int getMaxRate(@NotNull List<? extends ResolveResult> resolveResults) {
        if (resolveResults == null) {
            PyUtil.$$$reportNull$$$0(32);
        }
        return resolveResults.stream().mapToInt(PyUtil::getRate).max().orElse(Integer.MIN_VALUE);
    }

    private static int getRate(@NotNull ResolveResult resolveResult) {
        if (resolveResult == null) {
            PyUtil.$$$reportNull$$$0(33);
        }
        return resolveResult instanceof RatedResolveResult ? ((RatedResolveResult)resolveResult).getRate() : 0;
    }

    @Nullable
    public static PyFunction getInitMethod(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            PyUtil.$$$reportNull$$$0(34);
        }
        return pyClass.findMethodByName("__init__", false, null);
    }

    @Nullable
    public static <T> T as(@Nullable Object expression, @NotNull Class<T> clazz) {
        if (clazz == null) {
            PyUtil.$$$reportNull$$$0(35);
        }
        return (T)ObjectUtils.tryCast((Object)expression, clazz);
    }

    @Nullable
    public static <T extends PsiElement> T findReference(@NotNull PsiElement element, @NotNull Class<T> expectedClass) {
        if (element == null) {
            PyUtil.$$$reportNull$$$0(36);
        }
        if (expectedClass == null) {
            PyUtil.$$$reportNull$$$0(37);
        }
        for (PsiReference reference : element.getReferences()) {
            PsiElement result = (PsiElement)PyUtil.as(reference.resolve(), expectedClass);
            if (result == null) continue;
            return (T)result;
        }
        return null;
    }

    @NotNull
    public static <T> List<T> asList(@Nullable Collection<?> expression, @NotNull Class<? extends T> elementClass) {
        if (elementClass == null) {
            PyUtil.$$$reportNull$$$0(38);
        }
        if (expression == null || expression.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                PyUtil.$$$reportNull$$$0(39);
            }
            return list;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Object element : expression) {
            T toAdd = PyUtil.as(element, elementClass);
            if (toAdd == null) continue;
            result.add(toAdd);
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            PyUtil.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    @NotNull
    public static <T, P> T getParameterizedCachedValue(@NotNull PsiElement element, @Nullable P param, @NotNull @NotNull Function<P, @NotNull T> f) {
        if (element == null) {
            PyUtil.$$$reportNull$$$0(41);
        }
        if (f == null) {
            PyUtil.$$$reportNull$$$0(42);
        }
        T result = PyUtil.getNullableParameterizedCachedValue(element, param, f);
        assert (result != null);
        T t = result;
        if (t == null) {
            PyUtil.$$$reportNull$$$0(43);
        }
        return t;
    }

    @Nullable
    public static <T, P> T getNullableParameterizedCachedValue(@NotNull PsiElement element, @Nullable P param, @NotNull Function<P, @Nullable T> f) {
        Optional<P> wrappedParam;
        CachedValuesManager manager;
        Map cache;
        Optional<Object> value;
        if (element == null) {
            PyUtil.$$$reportNull$$$0(44);
        }
        if (f == null) {
            PyUtil.$$$reportNull$$$0(45);
        }
        if ((value = (Optional<Object>)(cache = (Map)CachedValuesManager.getCachedValue((PsiElement)element, (Key)(manager = CachedValuesManager.getManager((Project)element.getProject())).getKeyForClass(f.getClass()), () -> CachedValueProvider.Result.create((Object)Maps.newConcurrentMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}))).get(wrappedParam = Optional.ofNullable(param))) == null) {
            value = Optional.ofNullable(f.fun(param));
            cache.put(wrappedParam, value);
        }
        return value.orElse(null);
    }

    public static void runWithProgress(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, boolean modal, boolean canBeCancelled, final @NotNull Consumer<? super ProgressIndicator> function) {
        if (title == null) {
            PyUtil.$$$reportNull$$$0(46);
        }
        if (function == null) {
            PyUtil.$$$reportNull$$$0(47);
        }
        if (modal) {
            ProgressManager.getInstance().run((Task)new Task.Modal(project, title, canBeCancelled){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    function.consume((Object)indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/psi/PyUtil$1", "run"));
                }
            });
        } else {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title, canBeCancelled){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    function.consume((Object)indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/psi/PyUtil$2", "run"));
                }
            });
        }
    }

    public static void verboseOnly(@NotNull Runnable runnable) {
        if (runnable == null) {
            PyUtil.$$$reportNull$$$0(48);
        }
        if (VERBOSE_MODE) {
            runnable.run();
        }
    }

    public static boolean isPy2ReservedWord(@NotNull PyReferenceExpression node) {
        String name;
        if (node == null) {
            PyUtil.$$$reportNull$$$0(49);
        }
        return LanguageLevel.forElement((PsiElement)node).isPython2() && !node.isQualified() && ("None".equals(name = node.getName()) || "False".equals(name) || "True".equals(name));
    }

    public static void updateDocumentUnblockedAndCommitted(@NotNull PsiElement anchor, @NotNull Consumer<? super Document> consumer) {
        if (anchor == null) {
            PyUtil.$$$reportNull$$$0(50);
        }
        if (consumer == null) {
            PyUtil.$$$reportNull$$$0(51);
        }
        PyUtilCore.updateDocumentUnblockedAndCommitted((PsiElement)anchor, consumer);
    }

    @Nullable
    public static <T> T updateDocumentUnblockedAndCommitted(@NotNull PsiElement anchor, @NotNull Function<? super Document, ? extends T> func) {
        if (anchor == null) {
            PyUtil.$$$reportNull$$$0(52);
        }
        if (func == null) {
            PyUtil.$$$reportNull$$$0(53);
        }
        return (T)PyUtilCore.updateDocumentUnblockedAndCommitted((PsiElement)anchor, func);
    }

    @Nullable
    public static PyType getReturnTypeToAnalyzeAsCallType(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        PyClass cls;
        if (function == null) {
            PyUtil.$$$reportNull$$$0(54);
        }
        if (context == null) {
            PyUtil.$$$reportNull$$$0(55);
        }
        if (PyUtil.isInitMethod((PsiElement)function) && (cls = function.getContainingClass()) != null) {
            PyCollectionType providedClassType = PyTypeChecker.findGenericDefinitionType(cls, context);
            if (providedClassType != null) {
                return providedClassType;
            }
            PyInstantiableType classType = PyUtil.as(context.getType((PyTypedElement)cls), PyInstantiableType.class);
            if (classType != null) {
                return classType.toInstance();
            }
        }
        return context.getReturnType((PyCallable)function);
    }

    @Nullable
    public static PyExpression createExpressionFromFragment(@NotNull String expressionText, @NotNull PsiElement context) {
        if (expressionText == null) {
            PyUtil.$$$reportNull$$$0(56);
        }
        if (context == null) {
            PyUtil.$$$reportNull$$$0(57);
        }
        PyExpressionCodeFragmentImpl codeFragment = new PyExpressionCodeFragmentImpl(context.getProject(), "dummy.py", expressionText, false);
        codeFragment.setContext(context);
        PyExpressionStatement statement = PyUtil.as(codeFragment.getFirstChild(), PyExpressionStatement.class);
        return statement != null ? statement.getExpression() : null;
    }

    public static boolean isRoot(PsiFileSystemItem directory) {
        if (directory == null) {
            return true;
        }
        VirtualFile vFile = directory.getVirtualFile();
        if (vFile == null) {
            return true;
        }
        Project project = directory.getProject();
        return PyUtil.isRoot(vFile, project);
    }

    public static boolean isRoot(@NotNull VirtualFile directory, @NotNull Project project) {
        ProjectFileIndex fileIndex;
        if (directory == null) {
            PyUtil.$$$reportNull$$$0(58);
        }
        if (project == null) {
            PyUtil.$$$reportNull$$$0(59);
        }
        return Comparing.equal((Object)(fileIndex = ProjectFileIndex.getInstance((Project)project)).getClassRootForFile(directory), (Object)directory) || Comparing.equal((Object)fileIndex.getContentRootForFile(directory), (Object)directory) || Comparing.equal((Object)fileIndex.getSourceRootForFile(directory), (Object)directory);
    }

    public static boolean isImportable(PsiFile targetFile, @NotNull PsiFileSystemItem file) {
        PsiDirectory parent;
        if (file == null) {
            PyUtil.$$$reportNull$$$0(60);
        }
        return (parent = (PsiDirectory)file.getParent()) != null && file != targetFile && (PyUtil.isRoot((PsiFileSystemItem)parent) || parent == targetFile.getParent() || PyUtil.isPackage(parent, false, null));
    }

    @NotNull
    public static Collection<String> collectUsedNames(@Nullable PsiElement scope) {
        if (!(scope instanceof PyClass || scope instanceof PyFile || scope instanceof PyFunction)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PyUtil.$$$reportNull$$$0(61);
            }
            return list;
        }
        final HashSet<String> variables = new HashSet<String>(){

            @Override
            public boolean add(String s) {
                return s != null && super.add(s);
            }
        };
        scope.acceptChildren((PsiElementVisitor)new PyRecursiveElementVisitor(){

            public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
                if (node == null) {
                    4.$$$reportNull$$$0(0);
                }
                variables.add(node.getName());
            }

            public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
                if (node == null) {
                    4.$$$reportNull$$$0(1);
                }
                variables.add(node.getName());
            }

            public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
                if (node == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (!node.isQualified()) {
                    variables.add(node.getReferencedName());
                } else {
                    super.visitPyReferenceExpression(node);
                }
            }

            public void visitPyFunction(@NotNull PyFunction node) {
                if (node == null) {
                    4.$$$reportNull$$$0(3);
                }
                variables.add(node.getName());
            }

            public void visitPyClass(@NotNull PyClass node) {
                if (node == null) {
                    4.$$$reportNull$$$0(4);
                }
                variables.add(node.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/jetbrains/python/psi/PyUtil$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyTargetExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyNamedParameter";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyReferenceExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyFunction";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        HashSet<String> hashSet = variables;
        if (hashSet == null) {
            PyUtil.$$$reportNull$$$0(62);
        }
        return hashSet;
    }

    @Nullable
    public static PsiElement turnDirIntoInit(@Nullable PsiElement target) {
        if (target instanceof PsiDirectory) {
            PsiDirectory dir = (PsiDirectory)target;
            PsiFile initStub = dir.findFile("__init__.pyi");
            if (initStub != null && !PyiStubSuppressor.isIgnoredStub(initStub)) {
                return initStub;
            }
            PsiFile initFile = dir.findFile("__init__.py");
            if (initFile != null) {
                return initFile;
            }
            return null;
        }
        return target;
    }

    @Nullable
    public static PsiElement turnDirIntoInitPy(@Nullable PsiElement target) {
        if (!(target instanceof PsiDirectory)) {
            return target;
        }
        PsiDirectory psiDirectory = (PsiDirectory)target;
        return psiDirectory.findFile("__init__.py");
    }

    @Nullable
    public static PsiElement turnDirIntoInitPyi(@Nullable PsiElement target) {
        if (!(target instanceof PsiDirectory)) {
            return target;
        }
        PsiDirectory psiDirectory = (PsiDirectory)target;
        PsiFile initStub = psiDirectory.findFile("__init__.pyi");
        if (initStub != null && !PyiStubSuppressor.isIgnoredStub(initStub)) {
            return initStub;
        }
        return null;
    }

    @Nullable
    public static PsiElement getPackageElement(@NotNull PsiDirectory directory, @Nullable PsiElement anchor) {
        if (directory == null) {
            PyUtil.$$$reportNull$$$0(63);
        }
        if (PyUtil.isPackage(directory, anchor)) {
            PsiElement init = PyUtil.turnDirIntoInit((PsiElement)directory);
            if (init != null) {
                return init;
            }
            return directory;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiElement turnInitIntoDir(@Nullable PsiElement target) {
        if (target instanceof PyFile && PyUtil.isPackage((PsiFile)target)) {
            return ((PsiFile)target).getContainingDirectory();
        }
        return target;
    }

    public static boolean isPackage(@NotNull PsiDirectory directory, @Nullable PsiElement anchor) {
        if (directory == null) {
            PyUtil.$$$reportNull$$$0(64);
        }
        return PyUtil.isPackage(directory, true, anchor);
    }

    public static boolean isPackage(@NotNull PsiDirectory directory, boolean checkSetupToolsPackages, @Nullable PsiElement anchor) {
        if (directory == null) {
            PyUtil.$$$reportNull$$$0(65);
        }
        if (PyUtil.isExplicitPackage(directory)) {
            return true;
        }
        @NotNull Object element = anchor != null ? anchor : directory;
        LanguageLevel level = LanguageLevel.forElement((PsiElement)element);
        if (!level.isPython2()) {
            return true;
        }
        return checkSetupToolsPackages && PyUtil.isSetuptoolsNamespacePackage(directory);
    }

    public static boolean isPackage(@NotNull PsiFile file) {
        if (file == null) {
            PyUtil.$$$reportNull$$$0(66);
        }
        for (PyCustomPackageIdentifier customPackageIdentifier : (PyCustomPackageIdentifier[])PyCustomPackageIdentifier.EP_NAME.getExtensions()) {
            if (!customPackageIdentifier.isPackageFile(file)) continue;
            return true;
        }
        return "__init__.py".equals(file.getName());
    }

    public static boolean isPackage(@NotNull PsiFileSystemItem anchor, @Nullable PsiElement location) {
        if (anchor == null) {
            PyUtil.$$$reportNull$$$0(67);
        }
        return anchor instanceof PsiFile ? PyUtil.isPackage((PsiFile)anchor) : anchor instanceof PsiDirectory && PyUtil.isPackage((PsiDirectory)anchor, location);
    }

    public static boolean isCustomPackage(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PyUtil.$$$reportNull$$$0(68);
        }
        for (PyCustomPackageIdentifier customPackageIdentifier : (PyCustomPackageIdentifier[])PyCustomPackageIdentifier.EP_NAME.getExtensions()) {
            if (!customPackageIdentifier.isPackage(directory)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExplicitPackage(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PyUtil.$$$reportNull$$$0(69);
        }
        return PyUtil.isOrdinaryPackage(directory) || PyUtil.isCustomPackage(directory);
    }

    private static boolean isSetuptoolsNamespacePackage(@NotNull PsiDirectory directory) {
        String packagePath;
        if (directory == null) {
            PyUtil.$$$reportNull$$$0(70);
        }
        return (packagePath = PyUtil.getPackagePath(directory)) != null && !PySetuptoolsNamespaceIndex.find(packagePath, directory.getProject()).isEmpty();
    }

    @Nullable
    private static String getPackagePath(@NotNull PsiDirectory directory) {
        QualifiedName name;
        if (directory == null) {
            PyUtil.$$$reportNull$$$0(71);
        }
        return (name = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)directory)) != null ? name.toString() : null;
    }

    public static int getInitialUnderscores(@Nullable String name) {
        return PyUtilCore.getInitialUnderscores((String)name);
    }

    public static boolean isClassPrivateName(@NotNull String name) {
        if (name == null) {
            PyUtil.$$$reportNull$$$0(72);
        }
        return name.startsWith("__") && !name.endsWith("__");
    }

    @NotNull
    public static LookupElement createNamedParameterLookup(@NotNull String name, @NotNull PsiFile settingsAnchor, boolean addEquals) {
        if (name == null) {
            PyUtil.$$$reportNull$$$0(73);
        }
        if (settingsAnchor == null) {
            PyUtil.$$$reportNull$$$0(74);
        }
        String suffix = addEquals ? (PythonCodeStyleService.getInstance().isSpaceAroundEqInKeywordArgument(settingsAnchor) ? " = " : "=") : "";
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)(name + suffix)).withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Parameter));
        lookupElementBuilder = lookupElementBuilder.withInsertHandler((InsertHandler)OverwriteEqualsInsertHandler.INSTANCE);
        lookupElementBuilder.putUserData(PyCompletionMlElementInfo.Companion.getKey(), (Object)PyCompletionMlElementKind.NAMED_ARG.asInfo());
        LookupElement lookupElement = PrioritizedLookupElement.withGrouping((LookupElement)lookupElementBuilder, (int)1);
        if (lookupElement == null) {
            PyUtil.$$$reportNull$$$0(75);
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement createNamedParameterLookup(@NotNull String name, @NotNull PsiFile settingsAnchor) {
        if (name == null) {
            PyUtil.$$$reportNull$$$0(76);
        }
        if (settingsAnchor == null) {
            PyUtil.$$$reportNull$$$0(77);
        }
        return PyUtil.createNamedParameterLookup(name, settingsAnchor, true);
    }

    @Nullable
    public static PyExpression peelArgument(PyExpression expr) {
        while (expr instanceof PyParenthesizedExpression) {
            expr = ((PyParenthesizedExpression)expr).getContainedExpression();
        }
        if (expr instanceof PyKeywordArgument) {
            expr = ((PyKeywordArgument)expr).getValueExpression();
        }
        return expr;
    }

    public static String getFirstParameterName(PyFunction container) {
        PyNamedParameter named;
        PyParameter[] params;
        String selfName = "self";
        if (container != null && (params = container.getParameterList().getParameters()).length > 0 && (named = params[0].getAsNamed()) != null) {
            selfName = named.getName();
        }
        return selfName;
    }

    @RequiresEdt
    public static void addSourceRoots(@NotNull Module module, @NotNull Collection<VirtualFile> roots) {
        if (module == null) {
            PyUtil.$$$reportNull$$$0(78);
        }
        if (roots == null) {
            PyUtil.$$$reportNull$$$0(79);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (roots.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            for (VirtualFile root : roots) {
                for (ContentEntry entry : model.getContentEntries()) {
                    VirtualFile file = entry.getFile();
                    if (file == null || !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)root, (boolean)true)) continue;
                    entry.addSourceFolder(root.getUrl(), (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, true);
                }
            }
            model.commit();
        });
    }

    @RequiresEdt
    public static void addModuleDependencies(@NotNull Module module, @NotNull Collection<Module> dependencies) {
        if (module == null) {
            PyUtil.$$$reportNull$$$0(80);
        }
        if (dependencies == null) {
            PyUtil.$$$reportNull$$$0(81);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (dependencies.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            for (Module dependency : dependencies) {
                if (dependency == module || model.findModuleOrderEntry(dependency) != null) continue;
                model.addModuleOrderEntry(dependency);
            }
            model.commit();
        });
    }

    @RequiresEdt
    public static void removeSourceRoots(@NotNull Module module, @NotNull Collection<VirtualFile> roots) {
        if (module == null) {
            PyUtil.$$$reportNull$$$0(82);
        }
        if (roots == null) {
            PyUtil.$$$reportNull$$$0(83);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (roots.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            for (ContentEntry entry : model.getContentEntries()) {
                for (SourceFolder folder : entry.getSourceFolders()) {
                    if (!roots.contains(folder.getFile())) continue;
                    entry.removeSourceFolder(folder);
                }
            }
            model.commit();
        });
    }

    @RequiresEdt
    public static void removeModuleDependencies(@NotNull Module module, @NotNull Collection<Module> dependencies) {
        if (module == null) {
            PyUtil.$$$reportNull$$$0(84);
        }
        if (dependencies == null) {
            PyUtil.$$$reportNull$$$0(85);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (dependencies.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            for (Module dependency : dependencies) {
                ModuleOrderEntry moduleOrderEntry = model.findModuleOrderEntry(dependency);
                if (moduleOrderEntry == null) continue;
                model.removeOrderEntry((OrderEntry)moduleOrderEntry);
            }
            model.commit();
        });
    }

    @NotNull
    public static Collection<VirtualFile> getSourceRoots(@NotNull PsiElement foothold) {
        Module module;
        if (foothold == null) {
            PyUtil.$$$reportNull$$$0(86);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)foothold)) != null) {
            return PyUtil.getSourceRoots(module);
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            PyUtil.$$$reportNull$$$0(87);
        }
        return list;
    }

    @NotNull
    public static Collection<VirtualFile> getSourceRoots(@NotNull Module module) {
        if (module == null) {
            PyUtil.$$$reportNull$$$0(88);
        }
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        Collections.addAll(result, manager.getSourceRoots());
        Collections.addAll(result, manager.getContentRoots());
        LinkedHashSet<VirtualFile> linkedHashSet = result;
        if (linkedHashSet == null) {
            PyUtil.$$$reportNull$$$0(89);
        }
        return linkedHashSet;
    }

    @Nullable
    public static VirtualFile findInRoots(Module module, String path) {
        if (module != null) {
            for (VirtualFile root : PyUtil.getSourceRoots(module)) {
                VirtualFile file = root.findFileByRelativePath(path);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    public static @Nullable List<@NotNull String> strListValue(@Nullable PyExpression value) {
        return PyUtilCore.strListValue((PyAstExpression)value);
    }

    @NotNull
    public static Map<String, PyExpression> dictValue(@NotNull PyDictLiteralExpression dict) {
        if (dict == null) {
            PyUtil.$$$reportNull$$$0(90);
        }
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (PyKeyValueExpression keyValue : dict.getElements()) {
            PyExpression key = keyValue.getKey();
            PyExpression value = keyValue.getValue();
            if (!(key instanceof PyStringLiteralExpression)) continue;
            result.put(((PyStringLiteralExpression)key).getStringValue(), value);
        }
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            PyUtil.$$$reportNull$$$0(91);
        }
        return linkedHashMap;
    }

    public static <T> boolean among(@NotNull T what, T ... variants) {
        if (what == null) {
            PyUtil.$$$reportNull$$$0(92);
        }
        for (T s : variants) {
            if (!what.equals(s)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getKeywordArgumentString(PyCallExpression expr, String keyword) {
        return PyPsiUtils.strValue((PyExpression)expr.getKeywordArgument(keyword));
    }

    public static boolean isExceptionClass(PyClass pyClass) {
        if (PyUtil.isBaseException(pyClass.getQualifiedName())) {
            return true;
        }
        for (PyClassLikeType type : pyClass.getAncestorTypes(TypeEvalContext.codeInsightFallback((Project)pyClass.getProject()))) {
            if (type == null || !PyUtil.isBaseException(type.getClassQName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isBaseException(String name) {
        return name != null && (name.contains("BaseException") || name.startsWith("exceptions."));
    }

    @ApiStatus.Internal
    @Nullable
    public static PyType convertToType(@NotNull PyLiteralKind literalKind, @NotNull PyBuiltinCache builtinCache) {
        if (literalKind == null) {
            PyUtil.$$$reportNull$$$0(93);
        }
        if (builtinCache == null) {
            PyUtil.$$$reportNull$$$0(94);
        }
        switch (literalKind) {
            case INT: {
                return builtinCache.getIntType();
            }
            case FLOAT: {
                return builtinCache.getFloatType();
            }
            case STRING: {
                return builtinCache.getStrType();
            }
            case BOOL: {
                return builtinCache.getBoolType();
            }
            case NONE: {
                return builtinCache.getNoneType();
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean isSuperCall(@NotNull PyCallExpression node) {
        PyClass klass;
        if (node == null) {
            PyUtil.$$$reportNull$$$0(95);
        }
        if ((klass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class)) == null) {
            return false;
        }
        PyExpression callee = node.getCallee();
        if (callee == null) {
            return false;
        }
        String name = callee.getName();
        if ("super".equals(name)) {
            PsiReference reference = callee.getReference();
            if (reference == null) {
                return false;
            }
            PsiElement resolved = reference.resolve();
            PyBuiltinCache cache = PyBuiltinCache.getInstance((PsiElement)node);
            if (resolved != null && cache.isBuiltin(resolved)) {
                PyExpression[] args = node.getArguments();
                if (args.length > 0) {
                    String firstArg = args[0].getText();
                    if (firstArg.equals(klass.getName()) || firstArg.equals("self.__class__")) {
                        return true;
                    }
                    for (PyClass s : klass.getAncestorClasses(null)) {
                        if (!firstArg.equals(s.getName())) continue;
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static PsiElement findPrevAtOffset(PsiFile psiFile, int caretOffset, Class<? extends PsiElement> ... toSkip) {
        if (toSkip == null) {
            PyUtil.$$$reportNull$$$0(96);
        }
        return PyUtilCore.findPrevAtOffset((PsiFile)psiFile, (int)caretOffset, (Class[])toSkip);
    }

    @Nullable
    public static PsiElement findNonWhitespaceAtOffset(PsiFile psiFile, int caretOffset) {
        return PyUtilCore.findNonWhitespaceAtOffset((PsiFile)psiFile, (int)caretOffset);
    }

    @Nullable
    public static PsiElement findElementAtOffset(PsiFile psiFile, int caretOffset) {
        PsiElement element = PyUtil.findPrevAtOffset(psiFile, caretOffset, new Class[0]);
        if (element == null) {
            element = PyUtil.findNextAtOffset(psiFile, caretOffset, new Class[0]);
        }
        return element;
    }

    @Nullable
    public static PsiElement findNextAtOffset(@NotNull PsiFile psiFile, int caretOffset, Class<? extends PsiElement> ... toSkip) {
        if (psiFile == null) {
            PyUtil.$$$reportNull$$$0(97);
        }
        if (toSkip == null) {
            PyUtil.$$$reportNull$$$0(98);
        }
        return PyUtilCore.findNextAtOffset((PsiFile)psiFile, (int)caretOffset, (Class[])toSkip);
    }

    public static boolean isSignatureCompatibleTo(@NotNull PyCallable callable, @NotNull PyCallable otherCallable, @NotNull TypeEvalContext context) {
        if (callable == null) {
            PyUtil.$$$reportNull$$$0(99);
        }
        if (otherCallable == null) {
            PyUtil.$$$reportNull$$$0(100);
        }
        if (context == null) {
            PyUtil.$$$reportNull$$$0(101);
        }
        List parameters = callable.getParameters(context);
        List otherParameters = otherCallable.getParameters(context);
        int optionalCount = PyUtil.optionalParametersCount(parameters);
        int otherOptionalCount = PyUtil.optionalParametersCount(otherParameters);
        int requiredCount = PyUtil.requiredParametersCount(callable, parameters);
        int otherRequiredCount = PyUtil.requiredParametersCount(otherCallable, otherParameters);
        if ((PyUtil.hasPositionalContainer(otherParameters) || PyUtil.hasKeywordContainer(otherParameters)) && otherParameters.size() == PyUtil.specialParametersCount(otherCallable, otherParameters)) {
            return true;
        }
        if (PyUtil.hasPositionalContainer(parameters) || PyUtil.hasKeywordContainer(parameters)) {
            return requiredCount <= otherRequiredCount;
        }
        return requiredCount <= otherRequiredCount && optionalCount >= otherOptionalCount && PyUtil.namedParametersCount(parameters) >= PyUtil.namedParametersCount(otherParameters);
    }

    private static int optionalParametersCount(@NotNull List<PyCallableParameter> parameters) {
        if (parameters == null) {
            PyUtil.$$$reportNull$$$0(102);
        }
        int n = 0;
        for (PyCallableParameter parameter : parameters) {
            if (!parameter.hasDefaultValue()) continue;
            ++n;
        }
        return n;
    }

    private static int requiredParametersCount(@NotNull PyCallable callable, @NotNull List<PyCallableParameter> parameters) {
        if (callable == null) {
            PyUtil.$$$reportNull$$$0(103);
        }
        if (parameters == null) {
            PyUtil.$$$reportNull$$$0(104);
        }
        return PyUtil.namedParametersCount(parameters) - PyUtil.optionalParametersCount(parameters) - PyUtil.specialParametersCount(callable, parameters);
    }

    private static int specialParametersCount(@NotNull PyCallable callable, @NotNull List<PyCallableParameter> parameters) {
        if (callable == null) {
            PyUtil.$$$reportNull$$$0(105);
        }
        if (parameters == null) {
            PyUtil.$$$reportNull$$$0(106);
        }
        int n = 0;
        if (PyUtil.hasPositionalContainer(parameters)) {
            ++n;
        }
        if (PyUtil.hasKeywordContainer(parameters)) {
            ++n;
        }
        if (PyUtil.isFirstParameterSpecial(callable, parameters)) {
            ++n;
        }
        return n;
    }

    private static boolean hasPositionalContainer(@NotNull List<PyCallableParameter> parameters) {
        if (parameters == null) {
            PyUtil.$$$reportNull$$$0(107);
        }
        for (PyCallableParameter parameter : parameters) {
            if (!parameter.isPositionalContainer()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasKeywordContainer(@NotNull List<PyCallableParameter> parameters) {
        if (parameters == null) {
            PyUtil.$$$reportNull$$$0(108);
        }
        for (PyCallableParameter parameter : parameters) {
            if (!parameter.isKeywordContainer()) continue;
            return true;
        }
        return false;
    }

    private static int namedParametersCount(@NotNull List<PyCallableParameter> parameters) {
        if (parameters == null) {
            PyUtil.$$$reportNull$$$0(109);
        }
        return ContainerUtil.count(parameters, p -> p.getParameter() instanceof PyNamedParameter);
    }

    private static boolean isFirstParameterSpecial(@NotNull PyCallable callable, @NotNull List<PyCallableParameter> parameters) {
        PyFunction method;
        if (callable == null) {
            PyUtil.$$$reportNull$$$0(110);
        }
        if (parameters == null) {
            PyUtil.$$$reportNull$$$0(111);
        }
        if ((method = callable.asMethod()) != null) {
            return PyUtil.isNewMethod((PsiElement)method) || method.getModifier() != PyAstFunction.Modifier.STATICMETHOD;
        }
        PyCallableParameter first = (PyCallableParameter)ContainerUtil.getFirstItem(parameters);
        return first != null && "self".equals(first.getName());
    }

    @Contract(value="null -> false")
    public static boolean isInitMethod(@Nullable PsiElement element) {
        PyFunction function = PyUtil.as(element, PyFunction.class);
        return function != null && "__init__".equals(function.getName()) && function.getContainingClass() != null;
    }

    @Contract(value="null -> false")
    public static boolean isNewMethod(@Nullable PsiElement element) {
        return PyUtilCore.isNewMethod((PsiElement)element);
    }

    @Contract(value="null -> false")
    public static boolean isInitOrNewMethod(@Nullable PsiElement element) {
        return PyUtilCore.isInitOrNewMethod((PsiElement)element);
    }

    @Contract(value="null -> false")
    public static boolean isConstructorLikeMethod(@Nullable PsiElement element) {
        return PyUtilCore.isConstructorLikeMethod((PsiElement)element);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PyClass turnConstructorIntoClass(@Nullable PyFunction function) {
        return PyUtil.isInitOrNewMethod((PsiElement)function) ? function.getContainingClass() : null;
    }

    public static boolean isStarImportableFrom(@NotNull String name, @NotNull PyFile file) {
        List dunderAll;
        if (name == null) {
            PyUtil.$$$reportNull$$$0(112);
        }
        if (file == null) {
            PyUtil.$$$reportNull$$$0(113);
        }
        return (dunderAll = file.getDunderAll()) != null ? dunderAll.contains(name) : !name.startsWith("_");
    }

    public static boolean isObjectClass(@NotNull PyClass cls) {
        String qualifiedName;
        if (cls == null) {
            PyUtil.$$$reportNull$$$0(114);
        }
        return "object".equals(qualifiedName = cls.getQualifiedName()) || qualifiedName == null && "object".equals(cls.getName());
    }

    @Nullable
    public static PyType getReturnTypeOfMember(@NotNull PyType type, @NotNull String memberName, @Nullable PyExpression location, @NotNull TypeEvalContext context) {
        PyResolveContext resolveContext;
        List resolveResults;
        if (type == null) {
            PyUtil.$$$reportNull$$$0(115);
        }
        if (memberName == null) {
            PyUtil.$$$reportNull$$$0(116);
        }
        if (context == null) {
            PyUtil.$$$reportNull$$$0(117);
        }
        if ((resolveResults = type.resolveMember(memberName, location, AccessDirection.READ, resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context))) != null) {
            ArrayList<PyType> types = new ArrayList<PyType>();
            for (RatedResolveResult resolveResult : resolveResults) {
                PyType returnType = PyUtil.getReturnType(resolveResult.getElement(), context);
                if (returnType == null) continue;
                types.add(returnType);
            }
            return PyUnionType.union(types);
        }
        return null;
    }

    @Nullable
    private static PyType getReturnType(@Nullable PsiElement element, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyUtil.$$$reportNull$$$0(118);
        }
        if (element instanceof PyTypedElement) {
            PyType type = context.getType((PyTypedElement)element);
            return PyUtil.getReturnType(type, context);
        }
        return null;
    }

    @Nullable
    private static PyType getReturnType(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyUtil.$$$reportNull$$$0(119);
        }
        if (type instanceof PyCallableType) {
            return ((PyCallableType)type).getReturnType(context);
        }
        if (type instanceof PyUnionType) {
            return PyUnionType.toNonWeakType(((PyUnionType)type).map(member -> PyUtil.getReturnType(member, context)));
        }
        return null;
    }

    public static boolean isEmptyFunction(@NotNull PyFunction function) {
        PyStatementList statementList;
        PyStatement[] statements;
        if (function == null) {
            PyUtil.$$$reportNull$$$0(120);
        }
        if ((statements = (statementList = function.getStatementList()).getStatements()).length == 0) {
            return true;
        }
        return statements.length == 1 ? PyUtil.isStringLiteral(statements[0]) || PyUtil.isPassOrRaiseOrEmptyReturnOrEllipsis(statements[0]) : statements.length == 2 && PyUtil.isStringLiteral(statements[0]) && PyUtil.isPassOrRaiseOrEmptyReturnOrEllipsis(statements[1]);
    }

    private static boolean isPassOrRaiseOrEmptyReturnOrEllipsis(PyStatement stmt) {
        PyExpression expression;
        if (stmt instanceof PyPassStatement || stmt instanceof PyRaiseStatement) {
            return true;
        }
        if (stmt instanceof PyReturnStatement && ((PyReturnStatement)stmt).getExpression() == null) {
            return true;
        }
        return stmt instanceof PyExpressionStatement && (expression = ((PyExpressionStatement)stmt).getExpression()) instanceof PyEllipsisLiteralExpression;
    }

    public static boolean isStringLiteral(@Nullable PyStatement stmt) {
        return PyUtilCore.isStringLiteral((PyAstStatement)stmt);
    }

    @Nullable
    public static PyLoopStatement getCorrespondingLoop(@NotNull PsiElement breakOrContinue) {
        if (breakOrContinue == null) {
            PyUtil.$$$reportNull$$$0(121);
        }
        return (PyLoopStatement)PyUtilCore.getCorrespondingLoop((PsiElement)breakOrContinue);
    }

    public static boolean isForbiddenMutableDefault(@Nullable PyTypedElement value, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyUtil.$$$reportNull$$$0(122);
        }
        if (value == null) {
            return false;
        }
        Set pyClasses = ((StreamEx)PyTypeUtil.toStream(context.getType(value)).select(PyClassType.class).filter(clsType -> !clsType.isDefinition())).map(PyClassType::getPyClass).toSet();
        if (!pyClasses.isEmpty()) {
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)value);
            Set forbiddenClasses = StreamEx.of((Object[])new PyClassType[]{builtinCache.getListType(), builtinCache.getSetType(), builtinCache.getDictType()}).nonNull().map(PyClassType::getPyClass).toSet();
            return StreamEx.of((Collection)pyClasses).flatMap(pyClass -> StreamEx.of((Object)pyClass).append((Collection)pyClass.getAncestorClasses(context))).anyMatch(forbiddenClasses::contains);
        }
        return false;
    }

    public static void addDecorator(@NotNull PyFunction function, @NotNull String decorator) {
        if (function == null) {
            PyUtil.$$$reportNull$$$0(123);
        }
        if (decorator == null) {
            PyUtil.$$$reportNull$$$0(124);
        }
        PyDecoratorList currentDecorators = function.getDecoratorList();
        ArrayList<String> decoTexts = new ArrayList<String>();
        decoTexts.add(decorator);
        if (currentDecorators != null) {
            for (PyDecorator deco : currentDecorators.getDecorators()) {
                decoTexts.add(deco.getText());
            }
        }
        PyElementGenerator generator = PyElementGenerator.getInstance((Project)function.getProject());
        PyDecoratorList newDecorators = generator.createDecoratorList(ArrayUtilRt.toStringArray(decoTexts));
        if (currentDecorators != null) {
            currentDecorators.replace((PsiElement)newDecorators);
        } else {
            function.addBefore((PsiElement)newDecorators, function.getFirstChild());
        }
    }

    public static boolean isOrdinaryPackage(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PyUtil.$$$reportNull$$$0(125);
        }
        return directory.findFile("__init__.py") != null;
    }

    public static boolean isNoinspectionComment(@NotNull PsiComment comment) {
        if (comment == null) {
            PyUtil.$$$reportNull$$$0(126);
        }
        Pattern suppressPattern = Pattern.compile("\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");
        return suppressPattern.matcher(comment.getText()).find();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6, 7, 8, 9, 10, 11, 16, 17, 18, 20, 21, 23, 24, 27, 30, 32, 33, 34, 35, 36, 37, 38, 41, 42, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 88, 90, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyUtil";
                break;
            }
            case 5: 
            case 60: 
            case 66: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 8: 
            case 16: 
            case 20: 
            case 36: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 10: 
            case 55: 
            case 57: 
            case 101: 
            case 117: 
            case 118: 
            case 119: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 47: 
            case 54: 
            case 120: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comprehension";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToResolve";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 24: 
            case 27: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedClass";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 49: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 50: 
            case 52: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionText";
                break;
            }
            case 58: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 72: 
            case 73: 
            case 76: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 74: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsAnchor";
                break;
            }
            case 78: 
            case 80: 
            case 82: 
            case 84: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 79: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 81: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foothold";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dict";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalKind";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtinCache";
                break;
            }
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSkip";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 99: 
            case 103: 
            case 105: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherCallable";
                break;
            }
            case 102: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakOrContinue";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenedParensAndTuples";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenedParensAndLists";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenedParensAndStars";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableRepr";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sure";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyUtil";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyAccessDirection";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToTheTop";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveTopPriority";
                break;
            }
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "filterTopPriorityResults";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "filterTopPriorityElements";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "asList";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterizedCachedValue";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUsedNames";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedParameterLookup";
                break;
            }
            case 87: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "dictValue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasIfNameEqualsMain";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "inSameFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevel";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedAncestors";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyAccessDirection";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeQualifier";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isOwnScopeComprehension";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveToTheTop";
                break;
            }
            case 20: 
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveTopPriority";
                break;
            }
            case 24: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "filterTopPriorityResults";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "filterTopPriorityElements";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getMaxRate";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getRate";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getInitMethod";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "as";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findReference";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "asList";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getParameterizedCachedValue";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getNullableParameterizedCachedValue";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "runWithProgress";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "verboseOnly";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isPy2ReservedWord";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "updateDocumentUnblockedAndCommitted";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeToAnalyzeAsCallType";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionFromFragment";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isRoot";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isImportable";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getPackageElement";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isPackage";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isCustomPackage";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isExplicitPackage";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isSetuptoolsNamespacePackage";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getPackagePath";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isClassPrivateName";
                break;
            }
            case 73: 
            case 74: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "createNamedParameterLookup";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "addSourceRoots";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addModuleDependencies";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceRoots";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "removeModuleDependencies";
                break;
            }
            case 86: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoots";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "dictValue";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "among";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "convertToType";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "isSuperCall";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "findPrevAtOffset";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "findNextAtOffset";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "isSignatureCompatibleTo";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "optionalParametersCount";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "requiredParametersCount";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "specialParametersCount";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "hasPositionalContainer";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "hasKeywordContainer";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "namedParametersCount";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "isFirstParameterSpecial";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "isStarImportableFrom";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "isObjectClass";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeOfMember";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyFunction";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingLoop";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "isForbiddenMutableDefault";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "addDecorator";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "isOrdinaryPackage";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "isNoinspectionComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6, 7, 8, 9, 10, 11, 16, 17, 18, 20, 21, 23, 24, 27, 30, 32, 33, 34, 35, 36, 37, 38, 41, 42, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 88, 90, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126 -> new IllegalArgumentException(string);
        };
    }

    public static final class IterHelper {
        private IterHelper() {
        }

        @Nullable
        public static PsiNamedElement findName(Iterable<? extends PsiNamedElement> it, String name) {
            PsiNamedElement ret = null;
            for (PsiNamedElement psiNamedElement : it) {
                if (psiNamedElement == null || psiNamedElement instanceof PyQualifiedExpression && ((PyQualifiedExpression)psiNamedElement).isQualified() || !name.equals(psiNamedElement.getName())) continue;
                ret = psiNamedElement;
                break;
            }
            return ret;
        }
    }

    public static final class StringNodeInfo {
        private final ASTNode myNode;
        private final String myPrefix;
        private final String myQuote;
        private final TextRange myContentRange;

        public StringNodeInfo(@NotNull ASTNode node) {
            if (node == null) {
                StringNodeInfo.$$$reportNull$$$0(0);
            }
            IElementType nodeType = node.getElementType();
            if (!PyTokenTypes.STRING_NODES.contains(nodeType) && nodeType != PyElementTypes.FSTRING_NODE) {
                throw new IllegalArgumentException("Node must be valid Python string literal token, but " + String.valueOf(nodeType) + " was given");
            }
            this.myNode = node;
            String nodeText = node.getText();
            int prefixLength = PyStringLiteralUtil.getPrefixLength((String)nodeText);
            this.myPrefix = nodeText.substring(0, prefixLength);
            this.myContentRange = PyStringLiteralUtil.getContentRange((String)nodeText);
            this.myQuote = nodeText.substring(prefixLength, this.myContentRange.getStartOffset());
        }

        public StringNodeInfo(@NotNull PsiElement element) {
            if (element == null) {
                StringNodeInfo.$$$reportNull$$$0(1);
            }
            this(element.getNode());
        }

        @NotNull
        public ASTNode getNode() {
            ASTNode aSTNode = this.myNode;
            if (aSTNode == null) {
                StringNodeInfo.$$$reportNull$$$0(2);
            }
            return aSTNode;
        }

        @NotNull
        public String getPrefix() {
            String string = this.myPrefix;
            if (string == null) {
                StringNodeInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getContent() {
            String string = this.myContentRange.substring(this.myNode.getText());
            if (string == null) {
                StringNodeInfo.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public TextRange getContentRange() {
            TextRange textRange = this.myContentRange;
            if (textRange == null) {
                StringNodeInfo.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        @NotNull
        public TextRange getAbsoluteContentRange() {
            TextRange textRange = this.getContentRange().shiftRight(this.myNode.getStartOffset());
            if (textRange == null) {
                StringNodeInfo.$$$reportNull$$$0(6);
            }
            return textRange;
        }

        public char getSingleQuote() {
            return this.myQuote.charAt(0);
        }

        @NotNull
        public String getQuote() {
            String string = this.myQuote;
            if (string == null) {
                StringNodeInfo.$$$reportNull$$$0(7);
            }
            return string;
        }

        public boolean isTripleQuoted() {
            return this.myQuote.length() == 3;
        }

        public boolean isTerminated() {
            String text = this.myNode.getText();
            return text.length() - this.myPrefix.length() >= this.myQuote.length() * 2 && text.endsWith(this.myQuote);
        }

        public boolean isUnicode() {
            return PyStringLiteralUtil.isUnicodePrefix((String)this.myPrefix);
        }

        public boolean isRaw() {
            return PyStringLiteralUtil.isRawPrefix((String)this.myPrefix);
        }

        public boolean isBytes() {
            return PyStringLiteralUtil.isBytesPrefix((String)this.myPrefix);
        }

        public boolean isFormatted() {
            return PyStringLiteralUtil.isFormattedPrefix((String)this.myPrefix);
        }

        public boolean isTemplate() {
            return PyStringLiteralUtil.isTemplatePrefix((String)this.myPrefix);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringNodeInfo info = (StringNodeInfo)o;
            return this.getQuote().equals(info.getQuote()) && this.isRaw() == info.isRaw() && this.isUnicode() == info.isUnicode() && this.isBytes() == info.isBytes();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/PyUtil$StringNodeInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/PyUtil$StringNodeInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentRange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAbsoluteContentRange";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuote";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    public static final class MethodFlags {
        private final boolean myIsStaticMethod;
        private final boolean myIsMetaclassMethod;
        private final boolean myIsSpecialMetaclassMethod;
        private final boolean myIsClassMethod;

        public boolean isMetaclassMethod() {
            return this.myIsMetaclassMethod;
        }

        public boolean isSpecialMetaclassMethod() {
            return this.myIsSpecialMetaclassMethod;
        }

        public boolean isStaticMethod() {
            return this.myIsStaticMethod;
        }

        public boolean isClassMethod() {
            return this.myIsClassMethod;
        }

        private MethodFlags(boolean isClassMethod, boolean isStaticMethod, boolean isMetaclassMethod, boolean isSpecialMetaclassMethod) {
            this.myIsClassMethod = isClassMethod;
            this.myIsStaticMethod = isStaticMethod;
            this.myIsMetaclassMethod = isMetaclassMethod;
            this.myIsSpecialMetaclassMethod = isSpecialMetaclassMethod;
        }

        @Nullable
        public static MethodFlags of(@NotNull PyFunction node) {
            PyClass cls;
            if (node == null) {
                MethodFlags.$$$reportNull$$$0(0);
            }
            if ((cls = node.getContainingClass()) != null) {
                PyAstFunction.Modifier modifier = node.getModifier();
                boolean isMetaclassMethod = false;
                PyClass type_cls = PyBuiltinCache.getInstance((PsiElement)node).getClass("type");
                for (PyClass ancestor_cls : cls.getAncestorClasses(null)) {
                    if (ancestor_cls != type_cls) continue;
                    isMetaclassMethod = true;
                    break;
                }
                String method_name = node.getName();
                boolean isSpecialMetaclassMethod = isMetaclassMethod && method_name != null && PyUtil.among(method_name, "__init__", "__call__");
                return new MethodFlags(modifier == PyAstFunction.Modifier.CLASSMETHOD, modifier == PyAstFunction.Modifier.STATICMETHOD, isMetaclassMethod, isSpecialMetaclassMethod);
            }
            return null;
        }

        public boolean isInstanceMethod() {
            return !this.myIsClassMethod && !this.myIsStaticMethod;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/psi/PyUtil$MethodFlags", "of"));
        }
    }
}

