/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.extractmethod;

import com.intellij.refactoring.extractMethod.ExtractMethodSettings;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.refactoring.extractmethod.PyVariableData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;

@NotNullByDefault
public class PyExtractMethodSettings
implements ExtractMethodSettings<Object> {
    private final String myMethodName;
    private final PyVariableData[] myVariableData;
    @Nullable
    private final String myReturnTypeName;
    private final Set<PyType> myReturnTypes;
    private final boolean myUseTypeAnnotations;

    public PyExtractMethodSettings(String methodName, PyVariableData[] variableData, @Nullable String returnTypeName, Set<PyType> returnTypes, boolean useTypeAnnotations) {
        this.myMethodName = methodName;
        this.myVariableData = variableData;
        this.myReturnTypeName = returnTypeName;
        this.myReturnTypes = returnTypes;
        this.myUseTypeAnnotations = useTypeAnnotations;
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    public PyVariableData[] getAbstractVariableData() {
        return this.myVariableData;
    }

    @Nullable
    public String getReturnTypeName() {
        return this.myReturnTypeName;
    }

    public Set<PyType> getReturnTypeFqns() {
        return this.myReturnTypes;
    }

    public boolean isUseTypeAnnotations() {
        return this.myUseTypeAnnotations;
    }

    @Nullable
    public Object getVisibility() {
        return null;
    }

    List<PyType> getAllTypes() {
        ArrayList<PyType> result = new ArrayList<PyType>();
        for (PyVariableData variableData : this.myVariableData) {
            if (variableData.type == null) continue;
            result.add(variableData.type);
        }
        result.addAll(this.myReturnTypes);
        return result;
    }
}

