/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev.transport;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.transport.DebuggerTransport;
import java.io.IOException;
import java.net.SocketException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDebuggerTransport
implements DebuggerTransport {
    private static final Logger LOG = Logger.getInstance(BaseDebuggerTransport.class);
    protected final Object mySocketObject;
    @NotNull
    protected final RemoteDebugger myDebugger;

    protected BaseDebuggerTransport(@NotNull RemoteDebugger debugger) {
        if (debugger == null) {
            BaseDebuggerTransport.$$$reportNull$$$0(0);
        }
        this.mySocketObject = new Object();
        this.myDebugger = debugger;
    }

    @Override
    public boolean sendFrame(@NotNull ProtocolFrame frame) {
        if (frame == null) {
            BaseDebuggerTransport.$$$reportNull$$$0(1);
        }
        BaseDebuggerTransport.logFrame(frame, true);
        try {
            byte[] packed = frame.pack();
            return this.sendMessageImpl(packed);
        }
        catch (SocketException se) {
            this.onSocketException();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
        return false;
    }

    protected abstract boolean sendMessageImpl(byte[] var1) throws IOException;

    protected abstract void onSocketException();

    public static void logFrame(ProtocolFrame frame, boolean out) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("%1$tH:%1$tM:%1$tS.%1$tL %2$s %3$s\n", new Date(), out ? "<<<" : ">>>", frame));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/pydev/transport/BaseDebuggerTransport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "sendFrame";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

