/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.git.link.platform;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.co.ben_gibson.git.link.platform.Custom;
import uk.co.ben_gibson.git.link.platform.Platform;
import uk.co.ben_gibson.git.link.platform.PlatformRepositoryKt;
import uk.co.ben_gibson.git.link.settings.ApplicationSettings;
import uk.co.ben_gibson.git.link.ui.Icons;
import uk.co.ben_gibson.url.Host;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a8\u0006\u000e"}, d2={"Luk/co/ben_gibson/git/link/platform/PlatformRepository;", "", "()V", "getAll", "", "Luk/co/ben_gibson/git/link/platform/Platform;", "getByDomain", "domain", "Luk/co/ben_gibson/url/Host;", "getById", "id", "Ljava/util/UUID;", "", "load", "GitLink"})
@SourceDebugExtension(value={"SMAP\nPlatformRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformRepository.kt\nuk/co/ben_gibson/git/link/platform/PlatformRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,49:1\n288#2,2:50\n288#2,2:52\n1549#2:57\n1620#2,3:58\n43#3,3:54\n*S KotlinDebug\n*F\n+ 1 PlatformRepository.kt\nuk/co/ben_gibson/git/link/platform/PlatformRepository\n*L\n27#1:50,2\n30#1:52,2\n37#1:57\n37#1:58,3\n35#1:54,3\n*E\n"})
public final class PlatformRepository {
    @Nullable
    public final Platform getById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        UUID uUID = UUID.fromString(id);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        return this.getById(uUID);
    }

    @Nullable
    public final Platform getById(@NotNull UUID id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable $this$firstOrNull$iv = this.load();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Platform it = (Platform)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Platform getByDomain(@NotNull Host domain) {
        Platform platform;
        Object v0;
        Platform it;
        boolean $i$f$firstOrNull;
        Iterable $this$firstOrNull$iv;
        Set<Platform> platforms;
        block3: {
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            platforms = this.load();
            $this$firstOrNull$iv = platforms;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (Platform)element$iv;
                boolean bl = false;
                if (!it.getDomains().contains(domain)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((platform = (Platform)v0) == null) {
            Object v4;
            block4: {
                $this$firstOrNull$iv = platforms;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (Platform)element$iv;
                    boolean bl = false;
                    Object object = it.getDomainPattern();
                    boolean bl2 = object != null && (object = ((Pattern)object).matcher(domain.toString())) != null ? ((Matcher)object).matches() : false;
                    if (!bl2) continue;
                    v4 = element$iv;
                    break block4;
                }
                v4 = null;
            }
            platform = v4;
        }
        return platform;
    }

    @NotNull
    public final Set<Platform> getAll() {
        return this.load();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Platform> load() {
        void $this$mapTo$iv$iv;
        boolean $i$f$service = false;
        Class<ApplicationSettings> serviceClass$iv = ApplicationSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        ApplicationSettings settings2 = (ApplicationSettings)object;
        Iterable $this$map$iv = settings2.getCustomHosts();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ApplicationSettings.CustomHostSettings customHostSettings = (ApplicationSettings.CustomHostSettings)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UUID uUID = UUID.fromString(it.getId());
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
            collection.add(new Custom(uUID, it.getDisplayName(), Icons.INSTANCE.getGIT(), SetsKt.setOf((Object)Host.Companion.invoke(it.getBaseUrl()))));
        }
        List customPlatforms = (List)destination$iv$iv;
        return SetsKt.plus((Set)PlatformRepositoryKt.access$getEXISTING_PLATFORMS$p(), (Iterable)customPlatforms);
    }
}

