/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.git.link.ui.notification;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.co.ben_gibson.git.link.GitLinkBundle;
import uk.co.ben_gibson.git.link.platform.Platform;
import uk.co.ben_gibson.git.link.settings.ProjectSettings;
import uk.co.ben_gibson.git.link.ui.notification.Notification;
import uk.co.ben_gibson.git.link.ui.notification.NotificationAction;
import uk.co.ben_gibson.url.URL;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB3\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\tH\u00c6\u0003J9\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Luk/co/ben_gibson/git/link/ui/notification/Notification;", "", "title", "", "message", "actions", "", "Luk/co/ben_gibson/git/link/ui/notification/NotificationAction;", "type", "Luk/co/ben_gibson/git/link/ui/notification/Notification$Type;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Luk/co/ben_gibson/git/link/ui/notification/Notification$Type;)V", "getActions", "()Ljava/util/Set;", "getMessage", "()Ljava/lang/String;", "getTitle", "getType", "()Luk/co/ben_gibson/git/link/ui/notification/Notification$Type;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "Type", "GitLink"})
public final class Notification {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String title;
    @NotNull
    private final String message;
    @NotNull
    private final Set<NotificationAction> actions;
    @NotNull
    private final Type type;
    @NotNull
    private static final String DEFAULT_TITLE = GitLinkBundle.message("name", new Object[0]);

    public Notification(@Nullable String title, @NotNull String message, @NotNull Set<NotificationAction> actions, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.title = title;
        this.message = message;
        this.actions = actions;
        this.type = type;
    }

    public /* synthetic */ Notification(String string, String string2, Set set, Type type, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 8) != 0) {
            type = Type.PERSISTENT;
        }
        this(string, string2, set, type);
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final Set<NotificationAction> getActions() {
        return this.actions;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @Nullable
    public final String component1() {
        return this.title;
    }

    @NotNull
    public final String component2() {
        return this.message;
    }

    @NotNull
    public final Set<NotificationAction> component3() {
        return this.actions;
    }

    @NotNull
    public final Type component4() {
        return this.type;
    }

    @NotNull
    public final Notification copy(@Nullable String title, @NotNull String message, @NotNull Set<NotificationAction> actions, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new Notification(title, message, actions, type);
    }

    public static /* synthetic */ Notification copy$default(Notification notification, String string, String string2, Set set, Type type, int n, Object object) {
        if ((n & 1) != 0) {
            string = notification.title;
        }
        if ((n & 2) != 0) {
            string2 = notification.message;
        }
        if ((n & 4) != 0) {
            set = notification.actions;
        }
        if ((n & 8) != 0) {
            type = notification.type;
        }
        return notification.copy(string, string2, set, type);
    }

    @NotNull
    public String toString() {
        return "Notification(title=" + this.title + ", message=" + this.message + ", actions=" + this.actions + ", type=" + this.type + ")";
    }

    public int hashCode() {
        int result = this.title == null ? 0 : this.title.hashCode();
        result = result * 31 + this.message.hashCode();
        result = result * 31 + ((Object)this.actions).hashCode();
        result = result * 31 + this.type.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Notification)) {
            return false;
        }
        Notification notification = (Notification)other;
        if (!Intrinsics.areEqual((Object)this.title, (Object)notification.title)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)notification.message)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.actions, notification.actions)) {
            return false;
        }
        return this.type == notification.type;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0004R\u0018\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Luk/co/ben_gibson/git/link/ui/notification/Notification$Companion;", "", "()V", "DEFAULT_TITLE", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "couldNotDetectPlatform", "Luk/co/ben_gibson/git/link/ui/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "hostNotSet", "linkCopied", "link", "Luk/co/ben_gibson/url/URL;", "performanceTips", "platformAutoDetected", "remotePlatform", "Luk/co/ben_gibson/git/link/platform/Platform;", "remoteNotFound", "repositoryNotFound", "star", "welcome", "version", "GitLink"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Notification hostNotSet(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new Notification(DEFAULT_TITLE, GitLinkBundle.message("notifications.platform-not-set", new Object[0]), SetsKt.setOf((Object)NotificationAction.Companion.settings$default(NotificationAction.Companion, project, null, 2, null)), null, 8, null);
        }

        @NotNull
        public final Notification repositoryNotFound() {
            return new Notification(DEFAULT_TITLE, GitLinkBundle.message("notifications.repository-not-found", new Object[0]), null, null, 12, null);
        }

        @NotNull
        public final Notification remoteNotFound() {
            return new Notification(DEFAULT_TITLE, GitLinkBundle.message("notifications.remote-not-found", new Object[0]), null, null, 12, null);
        }

        @NotNull
        public final Notification welcome(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Object[] objectArray = new Object[]{version};
            return new Notification(null, GitLinkBundle.message("notifications.welcome", objectArray), null, null, 13, null);
        }

        @NotNull
        public final Notification star() {
            Object[] objectArray = new NotificationAction[]{NotificationAction.Companion.openRepository((Function0<Unit>)((Function0)star.1.INSTANCE)), NotificationAction.Companion.doNotAskAgain((Function0<Unit>)((Function0)star.2.INSTANCE))};
            return new Notification(null, "Finding GitLink useful? Show your support \ud83d\udc96 and \u2b50 the repository \ud83d\ude4f.", SetsKt.setOf((Object[])objectArray), null, 9, null);
        }

        @NotNull
        public final Notification performanceTips(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object[] objectArray = new NotificationAction[]{NotificationAction.Companion.disableRemoteCheck(project), NotificationAction.Companion.doNotAskAgain((Function0<Unit>)((Function0)new Function0<Unit>(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    ComponentManager $this$service$iv = (ComponentManager)this.$project;
                    boolean $i$f$service = false;
                    Class<ProjectSettings> serviceClass$iv = ProjectSettings.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                    }
                    ((ProjectSettings)object).setShowPerformanceTip(false);
                }
            }))};
            return new Notification(null, GitLinkBundle.message("notifications.performance", new Object[0]), SetsKt.setOf((Object[])objectArray), null, 9, null);
        }

        @NotNull
        public final Notification couldNotDetectPlatform(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new Notification(null, GitLinkBundle.message("notifications.could-not-detect-platform", new Object[0]), SetsKt.setOf((Object)NotificationAction.Companion.settings(project, GitLinkBundle.message("actions.configure-manually", new Object[0]))), null, 9, null);
        }

        @NotNull
        public final Notification platformAutoDetected(@NotNull Platform remotePlatform, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)remotePlatform, (String)"remotePlatform");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object[] objectArray = new Object[]{remotePlatform.getName()};
            return new Notification(null, GitLinkBundle.message("notifications.platform-detected.message", objectArray), SetsKt.setOf((Object)NotificationAction.Companion.settings(project, GitLinkBundle.message("notifications.platform-detected.action", new Object[0]))), null, 9, null);
        }

        @NotNull
        public final Notification linkCopied(@NotNull URL link) {
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            return new Notification(DEFAULT_TITLE, GitLinkBundle.message("notifications.copied-to-clipboard", new Object[0]), SetsKt.setOf((Object)NotificationAction.Companion.openUrl$default(NotificationAction.Companion, link, null, 2, null)), Type.TRANSIENT);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Luk/co/ben_gibson/git/link/ui/notification/Notification$Type;", "", "(Ljava/lang/String;I)V", "PERSISTENT", "TRANSIENT", "GitLink"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type PERSISTENT = new Type();
        public static final /* enum */ Type TRANSIENT = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.PERSISTENT, Type.TRANSIENT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

