/*
 * Decompiled with CFR 0.152.
 */
package mobi.hsz.idea.gitignore.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mobi.hsz.idea.gitignore.file.type.IgnoreFileType;
import mobi.hsz.idea.gitignore.lang.IgnoreLanguage;
import mobi.hsz.idea.gitignore.lexer.IgnoreLexerAdapter;
import mobi.hsz.idea.gitignore.parser.IgnoreParser;
import mobi.hsz.idea.gitignore.psi.IgnoreFile;
import mobi.hsz.idea.gitignore.psi.IgnoreTypes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\r\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\r\u0010\u0017\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0016\u00a8\u0006\u001d"}, d2={"Lmobi/hsz/idea/gitignore/lang/IgnoreParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "()V", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "createFile", "Lmobi/hsz/idea/gitignore/psi/IgnoreFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "createLexer", "Lmobi/hsz/idea/gitignore/lexer/IgnoreLexerAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "createParser", "Lmobi/hsz/idea/gitignore/parser/IgnoreParser;", "getCommentTokens", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getFileNodeType", "Lcom/intellij/psi/tree/IFileElementType;", "getStringLiteralElements", "getWhitespaceTokens", "spaceExistenceTypeBetweenTokens", "Lcom/intellij/lang/ParserDefinition$SpaceRequirements;", "left", "right", "Companion", "idea-gitignore"})
public final class IgnoreParserDefinition
implements ParserDefinition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final TokenSet WHITE_SPACES;
    @NotNull
    private static final TokenSet COMMENTS;
    @NotNull
    private static final TokenSet SECTIONS;
    @NotNull
    private static final TokenSet HEADERS;
    @NotNull
    private static final TokenSet NEGATIONS;
    @NotNull
    private static final TokenSet BRACKETS;
    @NotNull
    private static final TokenSet SLASHES;
    @NotNull
    private static final TokenSet SYNTAXES;
    @NotNull
    private static final TokenSet VALUES;
    @NotNull
    private static final IFileElementType FILE;

    @NotNull
    public IgnoreLexerAdapter createLexer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new IgnoreLexerAdapter(null);
    }

    @NotNull
    public IgnoreParser createParser(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new IgnoreParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return WHITE_SPACES;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"EMPTY");
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiElement psiElement = IgnoreTypes.Factory.createElement(node);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createElement(...)");
        return psiElement;
    }

    @NotNull
    public IgnoreFile createFile(@NotNull FileViewProvider viewProvider) {
        IgnoreFile ignoreFile;
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        if (viewProvider.getBaseLanguage() instanceof IgnoreLanguage) {
            Language language = viewProvider.getBaseLanguage();
            Intrinsics.checkNotNull((Object)language, (String)"null cannot be cast to non-null type mobi.hsz.idea.gitignore.lang.IgnoreLanguage");
            ignoreFile = ((IgnoreLanguage)language).createFile(viewProvider);
        } else {
            ignoreFile = new IgnoreFile(viewProvider, IgnoreFileType.Companion.getINSTANCE());
        }
        return ignoreFile;
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(@NotNull ASTNode left, @NotNull ASTNode right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return ParserDefinition.SpaceRequirements.MAY;
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{TokenType.WHITE_SPACE};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        WHITE_SPACES = tokenSet;
        iElementTypeArray = new IElementType[]{IgnoreTypes.COMMENT};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        COMMENTS = tokenSet2;
        iElementTypeArray = new IElementType[]{IgnoreTypes.SECTION};
        TokenSet tokenSet3 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"create(...)");
        SECTIONS = tokenSet3;
        iElementTypeArray = new IElementType[]{IgnoreTypes.HEADER};
        TokenSet tokenSet4 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet4, (String)"create(...)");
        HEADERS = tokenSet4;
        iElementTypeArray = new IElementType[]{IgnoreTypes.NEGATION};
        TokenSet tokenSet5 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet5, (String)"create(...)");
        NEGATIONS = tokenSet5;
        iElementTypeArray = new IElementType[]{IgnoreTypes.BRACKET_LEFT, IgnoreTypes.BRACKET_RIGHT};
        TokenSet tokenSet6 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet6, (String)"create(...)");
        BRACKETS = tokenSet6;
        iElementTypeArray = new IElementType[]{IgnoreTypes.SLASH};
        TokenSet tokenSet7 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet7, (String)"create(...)");
        SLASHES = tokenSet7;
        iElementTypeArray = new IElementType[]{IgnoreTypes.SYNTAX_KEY};
        TokenSet tokenSet8 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet8, (String)"create(...)");
        SYNTAXES = tokenSet8;
        iElementTypeArray = new IElementType[]{IgnoreTypes.VALUE};
        TokenSet tokenSet9 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet9, (String)"create(...)");
        VALUES = tokenSet9;
        FILE = new IFileElementType(Language.findInstance(IgnoreLanguage.class));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0016\u0010\u0010\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0016\u0010\u0012\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0016\u0010\u0014\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0016\u0010\u0016\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0016\u0010\u0018\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0016\u0010\u001a\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lmobi/hsz/idea/gitignore/lang/IgnoreParserDefinition$Companion;", "", "()V", "BRACKETS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getBRACKETS", "()Lcom/intellij/psi/tree/TokenSet;", "COMMENTS", "getCOMMENTS", "FILE", "Lcom/intellij/psi/tree/IFileElementType;", "getFILE", "()Lcom/intellij/psi/tree/IFileElementType;", "HEADERS", "getHEADERS", "NEGATIONS", "getNEGATIONS", "SECTIONS", "getSECTIONS", "SLASHES", "getSLASHES", "SYNTAXES", "getSYNTAXES", "VALUES", "getVALUES", "WHITE_SPACES", "getWHITE_SPACES", "idea-gitignore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TokenSet getWHITE_SPACES() {
            return WHITE_SPACES;
        }

        @NotNull
        public final TokenSet getCOMMENTS() {
            return COMMENTS;
        }

        @NotNull
        public final TokenSet getSECTIONS() {
            return SECTIONS;
        }

        @NotNull
        public final TokenSet getHEADERS() {
            return HEADERS;
        }

        @NotNull
        public final TokenSet getNEGATIONS() {
            return NEGATIONS;
        }

        @NotNull
        public final TokenSet getBRACKETS() {
            return BRACKETS;
        }

        @NotNull
        public final TokenSet getSLASHES() {
            return SLASHES;
        }

        @NotNull
        public final TokenSet getSYNTAXES() {
            return SYNTAXES;
        }

        @NotNull
        public final TokenSet getVALUES() {
            return VALUES;
        }

        @NotNull
        public final IFileElementType getFILE() {
            return FILE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

