/*
 * Decompiled with CFR 0.152.
 */
package mobi.hsz.idea.gitignore.ui.template;

import com.intellij.codeWithMe.ClientId;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mobi.hsz.idea.gitignore.IgnoreBundle;
import mobi.hsz.idea.gitignore.settings.IgnoreSettings;
import mobi.hsz.idea.gitignore.util.Notify;
import mobi.hsz.idea.gitignore.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lmobi/hsz/idea/gitignore/ui/template/UserTemplateDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "content", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "name", "Lcom/intellij/ui/components/JBTextField;", "preview", "Lcom/intellij/openapi/editor/Editor;", "previewDocument", "Lcom/intellij/openapi/editor/Document;", "settings", "Lmobi/hsz/idea/gitignore/settings/IgnoreSettings;", "createCenterPanel", "Ljavax/swing/JComponent;", "dispose", "", "doOKAction", "getPreferredFocusedComponent", "performCreateAction", "idea-gitignore"})
@SourceDebugExtension(value={"SMAP\nUserTemplateDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserTemplateDialog.kt\nmobi/hsz/idea/gitignore/ui/template/UserTemplateDialog\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,88:1\n43#2,3:89\n*S KotlinDebug\n*F\n+ 1 UserTemplateDialog.kt\nmobi/hsz/idea/gitignore/ui/template/UserTemplateDialog\n*L\n30#1:89,3\n*E\n"})
public final class UserTemplateDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final String content;
    @NotNull
    private final IgnoreSettings settings;
    @Nullable
    private Editor preview;
    @Nullable
    private Document previewDocument;
    @Nullable
    private JBTextField name;

    public UserTemplateDialog(@NotNull Project project, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        super(project, false);
        this.project = project;
        this.content = content;
        boolean $i$f$service = false;
        Class<IgnoreSettings> serviceClass$iv = IgnoreSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        this.settings = (IgnoreSettings)object;
        this.setTitle(IgnoreBundle.INSTANCE.message("dialog.userTemplate.title", new Object[0]));
        this.setOKButtonText(IgnoreBundle.INSTANCE.message("global.create", new Object[0]));
        this.setCancelButtonText(IgnoreBundle.INSTANCE.message("global.cancel", new Object[0]));
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setPreferredSize(new Dimension(600, 300));
        Document document = this.previewDocument = EditorFactory.getInstance().createDocument((CharSequence)this.content);
        Intrinsics.checkNotNull((Object)document);
        this.preview = Utils.INSTANCE.createPreviewEditor(document, this.project, false);
        this.name = new JBTextField(IgnoreBundle.INSTANCE.message("dialog.userTemplate.name.value", new Object[0]));
        JLabel nameLabel = new JLabel(IgnoreBundle.INSTANCE.message("dialog.userTemplate.name", new Object[0]));
        nameLabel.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.add((Component)nameLabel, "West");
        namePanel.add((Component)this.name, "Center");
        Editor editor = this.preview;
        Intrinsics.checkNotNull((Object)editor);
        JComponent jComponent = editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent previewComponent = jComponent;
        previewComponent.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        centerPanel.add((Component)namePanel, "North");
        centerPanel.add((Component)previewComponent, "Center");
        return centerPanel;
    }

    @Nullable
    public JBTextField getPreferredFocusedComponent() {
        return this.name;
    }

    protected void dispose() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Editor editor = this.preview;
        Intrinsics.checkNotNull((Object)editor);
        editorFactory.releaseEditor(editor);
        super.dispose();
    }

    protected void doOKAction() {
        if (this.isOKActionEnabled()) {
            this.performCreateAction();
        }
    }

    private final void performCreateAction() {
        JBTextField jBTextField = this.name;
        Intrinsics.checkNotNull((Object)jBTextField);
        String string = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Document document = this.previewDocument;
        Intrinsics.checkNotNull((Object)document);
        String string2 = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        IgnoreSettings.UserTemplate template = new IgnoreSettings.UserTemplate(string, string2);
        this.settings.getUserTemplates().add(template);
        Object[] objectArray = new Object[]{template.getName()};
        Notify.show$default(Notify.INSTANCE, this.project, IgnoreBundle.INSTANCE.message("dialog.userTemplate.added", new Object[0]), IgnoreBundle.INSTANCE.message("dialog.userTemplate.added.description", objectArray), NotificationType.INFORMATION, null, 16, null);
        super.doOKAction();
    }
}

