/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.ml.llm.editor.common.progress.AICaretAttributeKeys;
import com.intellij.ml.llm.inlinePromptDetector.GenerateCodeIntention;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptFusCollector;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptKillSwitchIntention;
import com.intellij.ml.llm.inlinePromptDetector.PromptInfo;
import com.intellij.ml.llm.inlinePromptDetector.ui.InlinePromptHintsManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.util.ApplicationKt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bJ0\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R-\u0010\u001d\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0017  *\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001f0\u001f0\u001e\u00a2\u0006\u0002\b!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptHighlightingUtil;", "", "<init>", "()V", "processInlinePromptHighlighting", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "document", "Lcom/intellij/openapi/editor/Document;", "promptRange", "Lcom/intellij/openapi/util/TextRange;", "onInlinePromptNotFound", "", "reportFus", "promptInfo", "Lcom/intellij/ml/llm/inlinePromptDetector/PromptInfo;", "highlightInfo", "packData", "", "createHighlightInfo", "killSwitch", "Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptKillSwitchIntention;", "intention", "Lcom/intellij/ml/llm/inlinePromptDetector/GenerateCodeIntention;", "SUBMITTED_EVENTS_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.ml.llm.inlinePromptDetector"})
@SourceDebugExtension(value={"SMAP\nInlinePromptHighlightingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlinePromptHighlightingUtil.kt\ncom/intellij/ml/llm/inlinePromptDetector/InlinePromptHighlightingUtil\n+ 2 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n*L\n1#1,94:1\n68#2,6:95\n*S KotlinDebug\n*F\n+ 1 InlinePromptHighlightingUtil.kt\ncom/intellij/ml/llm/inlinePromptDetector/InlinePromptHighlightingUtil\n*L\n56#1:95,6\n*E\n"})
public final class InlinePromptHighlightingUtil {
    @NotNull
    public static final InlinePromptHighlightingUtil INSTANCE = new InlinePromptHighlightingUtil();
    @NotNull
    private static final Key<Set<Long>> SUBMITTED_EVENTS_KEY;

    private InlinePromptHighlightingUtil() {
    }

    @NotNull
    public final HighlightInfo processInlinePromptHighlighting(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor, @NotNull Document document, @NotNull TextRange promptRange) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)promptRange, (String)"promptRange");
        PromptInfo promptInfo = new PromptInfo(promptRange, document.getLineNumber(promptRange.getStartOffset()));
        SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)project).createSmartPsiFileRangePointer(file, promptRange);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
        SmartPsiFileRange smartPointerRange = smartPsiFileRange;
        GenerateCodeIntention intention = new GenerateCodeIntention(smartPointerRange);
        InlinePromptKillSwitchIntention killSwitch = new InlinePromptKillSwitchIntention();
        HighlightInfo highlightInfo = this.createHighlightInfo(promptInfo.getPromptRange(), killSwitch, intention);
        this.reportFus(promptInfo, file, editor, document, highlightInfo);
        ApplicationKt.getApplication().invokeLater(() -> InlinePromptHighlightingUtil.processInlinePromptHighlighting$lambda$0(intention, document, editor));
        return highlightInfo;
    }

    public final void onInlinePromptNotFound(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        InlinePromptHintsManager.INSTANCE.onInlinePromptNotFound$intellij_ml_llm_inlinePromptDetector(editor);
    }

    /*
     * WARNING - void declaration
     */
    private final void reportFus(PromptInfo promptInfo, PsiFile file, Editor editor, Document document, HighlightInfo highlightInfo) {
        long packedData;
        Set submittedFusEvents;
        void $this$getOrCreateUserDataUnsafe$iv;
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        UserDataHolder userDataHolder = (UserDataHolder)markupModel;
        Key<Set<Long>> key$iv = SUBMITTED_EVENTS_KEY;
        boolean $i$f$getOrCreateUserDataUnsafe = false;
        Object existing$iv = $this$getOrCreateUserDataUnsafe$iv.getUserData(key$iv);
        Object object = existing$iv;
        if (object == null) {
            boolean bl = false;
            Set value$iv = ConcurrentHashMap.newKeySet();
            $this$getOrCreateUserDataUnsafe$iv.putUserData(key$iv, (Object)value$iv);
            object = value$iv;
        }
        if ((submittedFusEvents = (Set)object).add(packedData = this.packData(promptInfo, document, highlightInfo))) {
            Language language = file.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            InlinePromptFusCollector.INSTANCE.logInlinePromptShown(language, promptInfo.getPromptRange().getLength());
        }
    }

    private final long packData(PromptInfo promptInfo, Document document, HighlightInfo highlightInfo) {
        TextRange textRange = new TextRange(highlightInfo.startOffset, highlightInfo.endOffset);
        long lineNum = (long)promptInfo.getLineNum() << 32;
        long rangeSubstringHashCode = document.getText(textRange).hashCode();
        long packedData = lineNum | rangeSubstringHashCode;
        return packedData;
    }

    private final HighlightInfo createHighlightInfo(TextRange promptRange, InlinePromptKillSwitchIntention killSwitch, GenerateCodeIntention intention) {
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(promptRange);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"range(...)");
        HighlightInfo.Builder builder2 = builder;
        builder2.textAttributes(AICaretAttributeKeys.INLINE_PROMPT_ATTRS);
        builder2.registerFix((IntentionAction)intention, null, null, null, null);
        builder2.registerFix((IntentionAction)killSwitch, null, null, null, null);
        HighlightInfo highlightInfo = builder2.createUnconditionally();
        Intrinsics.checkNotNullExpressionValue((Object)highlightInfo, (String)"createUnconditionally(...)");
        return highlightInfo;
    }

    private static final void processInlinePromptHighlighting$lambda$0(GenerateCodeIntention $intention, Document $document, Editor $editor) {
        TextRange textRange = $intention.getPromptRange();
        if (textRange == null) {
            return;
        }
        TextRange segment = textRange;
        int lineNumber = $document.getLineNumber(segment.getStartOffset());
        InlinePromptHintsManager.INSTANCE.onInlinePromptDetected$intellij_ml_llm_inlinePromptDetector($editor, $intention, lineNumber, segment.getStartOffset());
    }

    static {
        Key key = Key.create((String)"submitted.events.key");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SUBMITTED_EVENTS_KEY = key;
    }
}

