/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector.promo;

import com.intellij.codeInsight.inline.completion.InlineCompletionEvent;
import com.intellij.codeInsight.inline.completion.InlineCompletionEventAdapter;
import com.intellij.codeInsight.inline.completion.InlineCompletionEventType;
import com.intellij.codeInsight.inline.completion.TypingEvent;
import com.intellij.lang.Language;
import com.intellij.ml.llm.inlinePromptDetector.promo.AICodeGenerationPromoEditorSnapshot;
import com.intellij.ml.llm.inlinePromptDetector.promo.AICodeGenerationPromoInstallerKt;
import com.intellij.ml.llm.inlinePromptDetector.promo.AICodeGenerationPromoService;
import com.intellij.ml.llm.inlinePromptDetector.promo.AICodeGenerationPromoState;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/promo/InlineCompletionNewLineListener;", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventAdapter;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "state", "Lcom/intellij/ml/llm/inlinePromptDetector/promo/InlineCompletionNewLineListener$State;", "onRequest", "", "event", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Request;", "onNoVariants", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$NoVariants;", "onHide", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Hide;", "isApplicable", "", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEvent;", "State", "intellij.ml.llm.inlinePromptDetector"})
final class InlineCompletionNewLineListener
implements InlineCompletionEventAdapter {
    @NotNull
    private final Editor editor;
    @Nullable
    private State state;

    public InlineCompletionNewLineListener(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    public void onRequest(@NotNull InlineCompletionEventType.Request event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!AICodeGenerationPromoState.Companion.getInstance().shouldShowPromo(this.editor) || !this.isApplicable(event.getRequest().getEvent())) {
            this.state = null;
            AICodeGenerationPromoInstallerKt.access$cancelPromo(this.editor);
            return;
        }
        long l = System.currentTimeMillis();
        AICodeGenerationPromoEditorSnapshot aICodeGenerationPromoEditorSnapshot = (AICodeGenerationPromoEditorSnapshot)ActionsKt.runReadAction(() -> InlineCompletionNewLineListener.onRequest$lambda$0(this));
        Language language = event.getRequest().getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        this.state = new State(l, false, aICodeGenerationPromoEditorSnapshot, language);
    }

    public void onNoVariants(@NotNull InlineCompletionEventType.NoVariants event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        State state = this.state;
        this.state = state != null ? State.copy$default(state, 0L, true, null, null, 13, null) : null;
    }

    public void onHide(@NotNull InlineCompletionEventType.Hide event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        State state = this.state;
        if (state == null) {
            return;
        }
        State currentState = state;
        this.state = null;
        if (!currentState.getShouldShowPromo()) {
            return;
        }
        AICodeGenerationPromoEditorSnapshot editorState = (AICodeGenerationPromoEditorSnapshot)ActionsKt.runReadAction(() -> InlineCompletionNewLineListener.onHide$lambda$0(this));
        if (Intrinsics.areEqual((Object)editorState, (Object)currentState.getInitialEditorState())) {
            AICodeGenerationPromoService.Companion.getInstance().schedulePromo(this.editor, currentState.getLanguage(), System.currentTimeMillis() - currentState.getStartTime());
        }
    }

    private final boolean isApplicable(InlineCompletionEvent $this$isApplicable) {
        return $this$isApplicable instanceof InlineCompletionEvent.DocumentChange && ((InlineCompletionEvent.DocumentChange)$this$isApplicable).getTyping() instanceof TypingEvent.NewLine;
    }

    private static final AICodeGenerationPromoEditorSnapshot onRequest$lambda$0(InlineCompletionNewLineListener this$0) {
        return AICodeGenerationPromoEditorSnapshot.Companion.of(this$0.editor);
    }

    private static final AICodeGenerationPromoEditorSnapshot onHide$lambda$0(InlineCompletionNewLineListener this$0) {
        return AICodeGenerationPromoEditorSnapshot.Companion.of(this$0.editor);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/promo/InlineCompletionNewLineListener$State;", "", "startTime", "", "shouldShowPromo", "", "initialEditorState", "Lcom/intellij/ml/llm/inlinePromptDetector/promo/AICodeGenerationPromoEditorSnapshot;", "language", "Lcom/intellij/lang/Language;", "<init>", "(JZLcom/intellij/ml/llm/inlinePromptDetector/promo/AICodeGenerationPromoEditorSnapshot;Lcom/intellij/lang/Language;)V", "getStartTime", "()J", "getShouldShowPromo", "()Z", "getInitialEditorState", "()Lcom/intellij/ml/llm/inlinePromptDetector/promo/AICodeGenerationPromoEditorSnapshot;", "getLanguage", "()Lcom/intellij/lang/Language;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.ml.llm.inlinePromptDetector"})
    private static final class State {
        private final long startTime;
        private final boolean shouldShowPromo;
        @NotNull
        private final AICodeGenerationPromoEditorSnapshot initialEditorState;
        @NotNull
        private final Language language;

        public State(long startTime, boolean shouldShowPromo, @NotNull AICodeGenerationPromoEditorSnapshot initialEditorState, @NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)initialEditorState, (String)"initialEditorState");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            this.startTime = startTime;
            this.shouldShowPromo = shouldShowPromo;
            this.initialEditorState = initialEditorState;
            this.language = language;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        public final boolean getShouldShowPromo() {
            return this.shouldShowPromo;
        }

        @NotNull
        public final AICodeGenerationPromoEditorSnapshot getInitialEditorState() {
            return this.initialEditorState;
        }

        @NotNull
        public final Language getLanguage() {
            return this.language;
        }

        public final long component1() {
            return this.startTime;
        }

        public final boolean component2() {
            return this.shouldShowPromo;
        }

        @NotNull
        public final AICodeGenerationPromoEditorSnapshot component3() {
            return this.initialEditorState;
        }

        @NotNull
        public final Language component4() {
            return this.language;
        }

        @NotNull
        public final State copy(long startTime, boolean shouldShowPromo, @NotNull AICodeGenerationPromoEditorSnapshot initialEditorState, @NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)initialEditorState, (String)"initialEditorState");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            return new State(startTime, shouldShowPromo, initialEditorState, language);
        }

        public static /* synthetic */ State copy$default(State state, long l, boolean bl, AICodeGenerationPromoEditorSnapshot aICodeGenerationPromoEditorSnapshot, Language language, int n, Object object) {
            if ((n & 1) != 0) {
                l = state.startTime;
            }
            if ((n & 2) != 0) {
                bl = state.shouldShowPromo;
            }
            if ((n & 4) != 0) {
                aICodeGenerationPromoEditorSnapshot = state.initialEditorState;
            }
            if ((n & 8) != 0) {
                language = state.language;
            }
            return state.copy(l, bl, aICodeGenerationPromoEditorSnapshot, language);
        }

        @NotNull
        public String toString() {
            return "State(startTime=" + this.startTime + ", shouldShowPromo=" + this.shouldShowPromo + ", initialEditorState=" + this.initialEditorState + ", language=" + this.language + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.startTime);
            result = result * 31 + Boolean.hashCode(this.shouldShowPromo);
            result = result * 31 + this.initialEditorState.hashCode();
            result = result * 31 + this.language.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (this.startTime != state.startTime) {
                return false;
            }
            if (this.shouldShowPromo != state.shouldShowPromo) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.initialEditorState, (Object)state.initialEditorState)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.language, (Object)state.language);
        }
    }
}

