/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaProgressBarUI;
import com.intellij.ml.llm.editor.common.progress.AICaretAttributeKeys;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Segment;
import com.intellij.ui.components.ProgressBarLoadingDecorator;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;
import javax.swing.plaf.ProgressBarUI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\b\u0010\b\u001a\u00020\tH\u0002\u001a\b\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"createProgressBarComponent", "Lcom/intellij/openapi/ui/LoadingDecorator;", "disposable", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "promptSegment", "Lcom/intellij/openapi/util/Segment;", "getProgressStartColor", "Ljava/awt/Color;", "getProgressEndColor", "intellij.ml.llm.inlinePromptDetector"})
public final class ProgressKt {
    @NotNull
    public static final LoadingDecorator createProgressBarComponent(@NotNull Disposable disposable, @NotNull Editor editor, @NotNull Segment promptSegment) {
        int supposedEndOffset;
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)promptSegment, (String)"promptSegment");
        JPanel panel = new JPanel();
        Point point = editor.offsetToXY(promptSegment.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
        Point startPoint = point;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence documentText = charSequence;
        int lineNumber = document2.getLineNumber(promptSegment.getStartOffset());
        for (supposedEndOffset = Math.min(document2.getLineEndOffset(lineNumber), promptSegment.getEndOffset()) - 1; supposedEndOffset > promptSegment.getStartOffset() && CharsKt.isWhitespace((char)documentText.charAt(supposedEndOffset)); --supposedEndOffset) {
        }
        int end = editor.offsetToXY((int)(supposedEndOffset + 1)).x;
        panel.setPreferredSize(new Dimension(end, JBUI.scale((int)2)));
        ProgressBarLoadingDecorator loadingPanel = new ProgressBarLoadingDecorator(panel, disposable, 0);
        loadingPanel.getComponent().remove(panel);
        loadingPanel.getComponent().setBounds(startPoint.x, startPoint.y + editor.getLineHeight() - 2, end - startPoint.x, JBUI.scale((int)4));
        JProgressBar jProgressBar = loadingPanel.getProgressBar();
        Intrinsics.checkNotNullExpressionValue((Object)jProgressBar, (String)"getProgressBar(...)");
        JProgressBar progressBar = jProgressBar;
        progressBar.setUI((ProgressBarUI)new DarculaProgressBarUI());
        Container loadingLayer = progressBar.getParent().getParent();
        Intrinsics.checkNotNull((Object)loadingLayer, (String)"null cannot be cast to non-null type javax.swing.JPanel");
        JPanel cfr_ignored_0 = (JPanel)loadingLayer;
        ((JPanel)loadingLayer).setBorder((Border)JBUI.Borders.empty());
        JProgressBar $this$createProgressBarComponent_u24lambda_u240 = loadingPanel.getProgressBar();
        boolean bl = false;
        $this$createProgressBarComponent_u24lambda_u240.putClientProperty("ProgressBar.indeterminateStartColor", ProgressKt.getProgressStartColor());
        $this$createProgressBarComponent_u24lambda_u240.putClientProperty("ProgressBar.indeterminateEndColor", ProgressKt.getProgressEndColor());
        $this$createProgressBarComponent_u24lambda_u240.putClientProperty("ProgressBar.flatEnds", false);
        $this$createProgressBarComponent_u24lambda_u240.putClientProperty("ProgressBar.stripeWidth", 2);
        loadingPanel.startLoading(false);
        return (LoadingDecorator)loadingPanel;
    }

    private static final Color getProgressStartColor() {
        TextAttributesKey attributes = AICaretAttributeKeys.INLINE_PROGRESS_DARK_ATTRS;
        Color color = attributes.getDefaultAttributes().getForegroundColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getForegroundColor(...)");
        return color;
    }

    private static final Color getProgressEndColor() {
        TextAttributesKey attributes = AICaretAttributeKeys.INLINE_PROGRESS_LIGHT_ATTRS;
        Color color = attributes.getDefaultAttributes().getForegroundColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getForegroundColor(...)");
        return color;
    }
}

