/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.embeddings.external.client.listeners;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0006J\u0016\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/embeddings/external/client/listeners/ServerDiagnosticsListener;", "Lcom/intellij/execution/process/ProcessListener;", "<init>", "()V", "logsHistory", "Ljava/util/concurrent/LinkedBlockingQueue;", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "startNotified", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "processTerminated", "processWillTerminate", "willBeDestroyed", "", "onTextAvailable", "outputType", "Lcom/intellij/openapi/util/Key;", "grpcChannelStateChanged", "state", "connectionAddress", "hostname", "port", "", "getLogsAttachment", "Lcom/intellij/openapi/diagnostic/Attachment;", "updateHistory", "message", "Companion", "intellij.ml.llm.embeddings"})
@SourceDebugExtension(value={"SMAP\nServerDiagnosticsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerDiagnosticsListener.kt\ncom/intellij/ml/llm/embeddings/external/client/listeners/ServerDiagnosticsListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 -JvmPlatform.kt\nokio/_JvmPlatformKt\n*L\n1#1,73:1\n23#2:74\n23#2:75\n23#2:76\n23#2:77\n23#2:78\n23#2:79\n23#2:80\n33#3:81\n*S KotlinDebug\n*F\n+ 1 ServerDiagnosticsListener.kt\ncom/intellij/ml/llm/embeddings/external/client/listeners/ServerDiagnosticsListener\n*L\n20#1:74\n26#1:75\n32#1:76\n39#1:77\n42#1:78\n50#1:79\n56#1:80\n63#1:81\n*E\n"})
public final class ServerDiagnosticsListener
implements ProcessListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedBlockingQueue<String> logsHistory = new LinkedBlockingQueue();
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();
    public static final int MAX_HISTORY_SIZE = 1000;

    public void startNotified(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Embeddings native server started";
        ServerDiagnosticsListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ServerDiagnosticsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug(message);
        this.updateHistory(message);
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Embeddings native server terminated with status code " + event.getExitCode() + ", text: " + event.getText();
        ServerDiagnosticsListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ServerDiagnosticsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug(message);
        this.updateHistory(message);
    }

    public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Embeddings native server will terminate (destroyed: " + willBeDestroyed + ")";
        ServerDiagnosticsListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ServerDiagnosticsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug(message);
        this.updateHistory(message);
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        String string = event.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        char[] cArray = new char[]{'\n'};
        String message = StringsKt.trimEnd((String)string, (char[])cArray);
        if (ProcessOutputType.isStderr(outputType)) {
            $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ServerDiagnosticsListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(message);
        } else if (!StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)message)).toString(), (String)"[BENCHMARK]", (boolean)false, (int)2, null)) {
            $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ServerDiagnosticsListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug(message);
        }
        this.updateHistory(message);
    }

    public final void grpcChannelStateChanged(@NotNull String state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String message = "gRPC channel state is not " + state;
        ServerDiagnosticsListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ServerDiagnosticsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug(message);
        this.updateHistory(message);
    }

    public final void connectionAddress(@NotNull String hostname, int port2) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        String message = "Embeddings native server address is " + hostname + ":" + port2;
        ServerDiagnosticsListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ServerDiagnosticsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug(message);
        this.updateHistory(message);
    }

    @NotNull
    public final Attachment getLogsAttachment() {
        return new Attachment("inference_service.log", CollectionsKt.joinToString$default((Iterable)this.logsHistory, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateHistory(String message) {
        ReentrantLock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        Lock lock = $this$withLock$iv;
        lock.lock();
        try {
            boolean bl = false;
            while (this.logsHistory.size() > 1000) {
                this.logsHistory.poll();
            }
            this.logsHistory.put(message);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/embeddings/external/client/listeners/ServerDiagnosticsListener$Companion;", "", "<init>", "()V", "MAX_HISTORY_SIZE", "", "intellij.ml.llm.embeddings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

