/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.embeddings.indexer;

import com.intellij.ml.llm.embeddings.indexer.EmbeddingIndexesKt;
import com.intellij.ml.llm.embeddings.indexer.EmbeddingStorageLayout;
import com.intellij.ml.llm.embeddings.indexer.FileBasedEmbeddingIndex;
import com.intellij.ml.llm.embeddings.indexer.FileBasedEmbeddingIndexId;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.storage.FileBasedIndexLayoutProvider;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JG\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\t2\u0011\u0010\n\u001a\r\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\u0002\b\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/embeddings/indexer/EmbeddingIndexStorageLayoutProvider;", "Lcom/intellij/util/indexing/storage/FileBasedIndexLayoutProvider;", "<init>", "()V", "getLayout", "Lcom/intellij/util/indexing/storage/VfsAwareIndexStorageLayout;", "K", "V", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "otherApplicableProviders", "", "Lorg/jetbrains/annotations/Unmodifiable;", "isApplicable", "", "intellij.ml.llm.embeddings"})
public final class EmbeddingIndexStorageLayoutProvider
implements FileBasedIndexLayoutProvider {
    @NotNull
    public <K, V> VfsAwareIndexStorageLayout<K, V> getLayout(@NotNull FileBasedIndexExtension<K, V> extension, @NotNull Iterable<? extends FileBasedIndexLayoutProvider> otherApplicableProviders) {
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        Intrinsics.checkNotNullParameter(otherApplicableProviders, (String)"otherApplicableProviders");
        FileBasedEmbeddingIndexId indexId = ((FileBasedEmbeddingIndex)extension).getEmbeddingIndexId();
        FileBasedIndexLayoutProvider fileBasedIndexLayoutProvider = (FileBasedIndexLayoutProvider)CollectionsKt.firstOrNull(otherApplicableProviders);
        if (fileBasedIndexLayoutProvider == null) {
            throw new IllegalArgumentException("No applicable delegate provider found");
        }
        FileBasedIndexLayoutProvider delegateProvider = fileBasedIndexLayoutProvider;
        VfsAwareIndexStorageLayout vfsAwareIndexStorageLayout = delegateProvider.getLayout(extension, (Iterable)CollectionsKt.drop(otherApplicableProviders, (int)1));
        Intrinsics.checkNotNullExpressionValue((Object)vfsAwareIndexStorageLayout, (String)"getLayout(...)");
        return new EmbeddingStorageLayout(vfsAwareIndexStorageLayout, indexId, extension.dependsOnFileContent());
    }

    public boolean isApplicable(@NotNull FileBasedIndexExtension<?, ?> extension) {
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        return EmbeddingIndexesKt.isEmbeddingIndex(extension);
    }
}

