/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.embeddings.indexer;

import com.intellij.ml.llm.embeddings.indexer.BaseFileBasedEmbeddingIndex;
import com.intellij.ml.llm.embeddings.indexer.EmbeddingDataExternalizerWrapper;
import com.intellij.ml.llm.embeddings.indexer.EmbeddingIndexEntitiesProvider;
import com.intellij.ml.llm.embeddings.indexer.EmbeddingIndexId;
import com.intellij.ml.llm.embeddings.indexer.FilesInContentPropertyPusherKt;
import com.intellij.ml.llm.embeddings.indexer.entities.FileBasedIndexableEntity;
import com.intellij.ml.llm.embeddings.indexer.entities.FileTypeIndexableEntityWrapper;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.io.DataExternalizer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u0015H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/embeddings/indexer/FileContentEmbeddingIndex;", "T", "Lcom/intellij/ml/llm/embeddings/indexer/entities/FileBasedIndexableEntity;", "Lcom/intellij/ml/llm/embeddings/indexer/BaseFileBasedEmbeddingIndex;", "Lcom/intellij/ml/llm/embeddings/indexer/entities/FileTypeIndexableEntityWrapper;", "<init>", "()V", "fileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "getFileTypes", "()[Lcom/intellij/openapi/fileTypes/FileType;", "index", "Lkotlin/sequences/Sequence;", "context", "Lcom/intellij/util/indexing/FileContent;", "getInputFilter", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "dependsOnFileContent", "", "getValueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "intellij.ml.llm.embeddings"})
public abstract class FileContentEmbeddingIndex<T extends FileBasedIndexableEntity>
extends BaseFileBasedEmbeddingIndex<FileTypeIndexableEntityWrapper<T>> {
    @NotNull
    public FileType[] getFileTypes() {
        return EmbeddingIndexEntitiesProvider.Companion.getSupportedFileTypes(this.getEmbeddingIndexId());
    }

    @Override
    @NotNull
    public Sequence<FileTypeIndexableEntityWrapper<T>> index(@NotNull FileContent context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.getEmbeddingIndexId().isEnabled(context.getProject())) {
            return SequencesKt.emptySequence();
        }
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)EmbeddingIndexEntitiesProvider.Companion.parseFile(this.getEmbeddingIndexId(), context)), arg_0 -> FileContentEmbeddingIndex.index$lambda$0(context, arg_0));
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileType[] fileTypeArray = this.getFileTypes();
        Object[] objectArray = Arrays.copyOf(fileTypeArray, fileTypeArray.length);
        return (FileBasedIndex.InputFilter)new DefaultFileTypeSpecificInputFilter(this, objectArray){
            final /* synthetic */ FileContentEmbeddingIndex<T> this$0;
            {
                this.this$0 = $receiver;
                super((FileType[])$super_call_param$1);
            }

            public boolean acceptInput(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return EmbeddingIndexId.isEnabled$default(this.this$0.getEmbeddingIndexId(), null, 1, null) && FilesInContentPropertyPusherKt.isInContent(file);
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public DataExternalizer<FileTypeIndexableEntityWrapper<T>> getValueExternalizer() {
        return new EmbeddingDataExternalizerWrapper(this.getEmbeddingIndexId());
    }

    private static final FileTypeIndexableEntityWrapper index$lambda$0(FileContent $context, FileBasedIndexableEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FileType fileType = $context.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        return new FileTypeIndexableEntityWrapper<FileBasedIndexableEntity>(it, fileType);
    }
}

