/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.embeddings.indexer;

import com.intellij.ml.llm.embeddings.indexer.EmbeddingIndexId;
import com.intellij.ml.llm.embeddings.indexer.SemanticSearchWidgetKt;
import com.intellij.ml.llm.embeddings.indexer.configuration.EmbeddingsConfiguration;
import com.intellij.ml.llm.embeddings.indexer.storage.LocalIndexLocalModelEmbeddingsStorageManager;
import com.intellij.ml.llm.embeddings.indexer.storage.StorageStats;
import com.intellij.ml.llm.embeddings.indexer.storage.TextEmbeddingsStorageManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/embeddings/indexer/IndexStatusInfoAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "indexId", "Lcom/intellij/ml/llm/embeddings/indexer/EmbeddingIndexId;", "storageManager", "Lcom/intellij/ml/llm/embeddings/indexer/storage/TextEmbeddingsStorageManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/embeddings/indexer/EmbeddingIndexId;Lcom/intellij/ml/llm/embeddings/indexer/storage/TextEmbeddingsStorageManager;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getIndexId", "()Lcom/intellij/ml/llm/embeddings/indexer/EmbeddingIndexId;", "getStorageManager", "()Lcom/intellij/ml/llm/embeddings/indexer/storage/TextEmbeddingsStorageManager;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.ml.llm.embeddings"})
final class IndexStatusInfoAction
extends AnAction {
    @NotNull
    private final Project project;
    @NotNull
    private final EmbeddingIndexId indexId;
    @NotNull
    private final TextEmbeddingsStorageManager<?> storageManager;

    public IndexStatusInfoAction(@NotNull Project project, @NotNull EmbeddingIndexId indexId, @NotNull TextEmbeddingsStorageManager<?> storageManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indexId, (String)"indexId");
        Intrinsics.checkNotNullParameter(storageManager, (String)"storageManager");
        this.project = project;
        this.indexId = indexId;
        this.storageManager = storageManager;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final EmbeddingIndexId getIndexId() {
        return this.indexId;
    }

    @NotNull
    public final TextEmbeddingsStorageManager<?> getStorageManager() {
        return this.storageManager;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String enabled = this.indexId.isEnabled(this.project) ? "enabled" : "disabled";
        EmbeddingsConfiguration<?> configuration = EmbeddingsConfiguration.Companion.getConfiguration(this.indexId);
        String server = configuration.getStorageManager() instanceof LocalIndexLocalModelEmbeddingsStorageManager ? "native" : "in-memory";
        e.getPresentation().setEnabled(false);
        String prefix = SemanticSearchWidgetKt.access$presentableName(this.indexId) + ": " + enabled + ", " + server + " server";
        try {
            StorageStats stats2 = (StorageStats)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super StorageStats>, Object>(this, null){
                int label;
                final /* synthetic */ IndexStatusInfoAction this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super StorageStats>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ IndexStatusInfoAction this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = this.this$0.getStorageManager().getStorageStats(this.this$0.getProject(), this.this$0.getIndexId(), (Continuation<StorageStats>)((Continuation)this));
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super StorageStats> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super StorageStats> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            e.getPresentation().setText(prefix + ", " + stats2.getSize() + " keys, " + StringUtil.formatFileSize((long)stats2.getBytes()));
        }
        catch (ProcessCanceledException exception) {
            Presentation presentation = e.getPresentation();
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            presentation.setText(prefix + ", could not fetch stats from server (" + StringUtil.trimMiddle((String)string, (int)100) + ")");
            throw exception;
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }
}

