/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.embeddings.indexer.entities;

import com.intellij.ml.llm.embeddings.indexer.entities.FileBasedIndexableEntity;
import com.intellij.ml.llm.embeddings.indexer.entities.IndexableName;
import com.intellij.ml.llm.embeddings.utils.IndexingUtilsKt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\nR\u001b\u0010\u0010\u001a\u00020\u00048VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/embeddings/indexer/entities/IndexableFileName;", "Lcom/intellij/ml/llm/embeddings/indexer/entities/IndexableName;", "Lcom/intellij/ml/llm/embeddings/indexer/entities/FileBasedIndexableEntity;", "name", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "file", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getName", "()Ljava/lang/String;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setVirtualFile", "indexableRepresentation", "getIndexableRepresentation", "indexableRepresentation$delegate", "Lkotlin/Lazy;", "intellij.ml.llm.embeddings"})
public final class IndexableFileName
extends IndexableName
implements FileBasedIndexableEntity {
    @NotNull
    private final String name;
    @Nullable
    private VirtualFile virtualFile;
    @NotNull
    private final Lazy indexableRepresentation$delegate;

    public IndexableFileName(@NotNull String name, @Nullable VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.virtualFile = virtualFile;
        this.indexableRepresentation$delegate = LazyKt.lazy(() -> IndexableFileName.indexableRepresentation_delegate$lambda$0(this));
    }

    public /* synthetic */ IndexableFileName(String string, VirtualFile virtualFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            virtualFile = null;
        }
        this(string, virtualFile);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Override
    public void setVirtualFile(@Nullable VirtualFile virtualFile) {
        this.virtualFile = virtualFile;
    }

    public IndexableFileName(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this(string, file);
    }

    @Override
    @NotNull
    public String getIndexableRepresentation() {
        Lazy lazy = this.indexableRepresentation$delegate;
        return (String)lazy.getValue();
    }

    private static final String indexableRepresentation_delegate$lambda$0(IndexableFileName this$0) {
        String string = FileUtilRt.getNameWithoutExtension((String)this$0.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        return IndexingUtilsKt.splitIdentifierIntoTokens$default(string, false, 2, null);
    }
}

