/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.embeddings.indexer.entities.provider;

import com.intellij.ml.llm.embeddings.indexer.EmbeddingIndexEntitiesProvider;
import com.intellij.ml.llm.embeddings.indexer.FileBasedEmbeddingIndexId;
import com.intellij.ml.llm.embeddings.indexer.TextChunksEmbeddingIndexId;
import com.intellij.ml.llm.embeddings.indexer.entities.FileTypeIndexableEntityWrapper;
import com.intellij.ml.llm.embeddings.indexer.entities.IndexableTextChunk;
import com.intellij.ml.llm.embeddings.indexer.entities.provider.TextSplitUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R*\u0010\u0005\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0002`\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/embeddings/indexer/entities/provider/EmbeddingMarkdownChunksProvider;", "Lcom/intellij/ml/llm/embeddings/indexer/EmbeddingIndexEntitiesProvider;", "Lcom/intellij/ml/llm/embeddings/indexer/entities/IndexableTextChunk;", "<init>", "()V", "indexId", "Lcom/intellij/ml/llm/embeddings/indexer/FileBasedEmbeddingIndexId;", "Lcom/intellij/ml/llm/embeddings/indexer/entities/FileTypeIndexableEntityWrapper;", "Lcom/intellij/ml/llm/embeddings/indexer/FileContentEmbeddingId;", "getIndexId", "()Lcom/intellij/ml/llm/embeddings/indexer/FileBasedEmbeddingIndexId;", "entityExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "getEntityExternalizer", "()Lcom/intellij/util/io/DataExternalizer;", "parseFile", "", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "intellij.ml.llm.embeddings"})
public final class EmbeddingMarkdownChunksProvider
implements EmbeddingIndexEntitiesProvider<IndexableTextChunk> {
    @NotNull
    private final FileBasedEmbeddingIndexId<FileTypeIndexableEntityWrapper<IndexableTextChunk>> indexId = TextChunksEmbeddingIndexId.INSTANCE;
    @NotNull
    private final DataExternalizer<IndexableTextChunk> entityExternalizer = (DataExternalizer)new DataExternalizer<IndexableTextChunk>(){

        public void save(DataOutput dst, IndexableTextChunk value) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            dst.writeUTF(value.getName());
            DataInputOutputUtil.writeINT((DataOutput)dst, (int)value.getTextRange().getStartOffset());
            DataInputOutputUtil.writeINT((DataOutput)dst, (int)value.getTextRange().getEndOffset());
        }

        public IndexableTextChunk read(DataInput src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            String name = src.readUTF();
            int startOffset = DataInputOutputUtil.readINT((DataInput)src);
            int endOffset = DataInputOutputUtil.readINT((DataInput)src);
            Intrinsics.checkNotNull((Object)name);
            return new IndexableTextChunk(name, new TextRange(startOffset, endOffset), null, 4, null);
        }
    };

    @Override
    @NotNull
    public FileBasedEmbeddingIndexId<FileTypeIndexableEntityWrapper<IndexableTextChunk>> getIndexId() {
        return this.indexId;
    }

    @Override
    @NotNull
    public DataExternalizer<IndexableTextChunk> getEntityExternalizer() {
        return this.entityExternalizer;
    }

    @Override
    @NotNull
    public List<IndexableTextChunk> parseFile(@NotNull FileContent fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        Project project = fileContent.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = fileContent.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        CharSequence charSequence = fileContent.getContentAsText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getContentAsText(...)");
        return TextSplitUtilsKt.splitIntoChunksByNewlines$default(project, virtualFile, charSequence, 0, 8, null);
    }
}

