/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.core.operators.activations;

import io.kinference.attribute.Attribute;
import io.kinference.core.operators.activations.Activation;
import io.kinference.core.operators.activations.ReluVer6;
import io.kinference.ndarray.arrays.ByteMap;
import io.kinference.ndarray.arrays.DoubleMap;
import io.kinference.ndarray.arrays.FloatMap;
import io.kinference.ndarray.arrays.IntMap;
import io.kinference.ndarray.arrays.LongMap;
import io.kinference.ndarray.arrays.ShortMap;
import io.kinference.ndarray.extensions.constants.ByteConstants;
import io.kinference.ndarray.extensions.constants.ShortConstants;
import io.kinference.operator.OperatorInfo;
import io.kinference.operator.VersionInfo;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fBO\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\u0004\b\r\u0010\u000e\u0082\u0001\u0001\u0010\u00a8\u0006\u0011"}, d2={"Lio/kinference/core/operators/activations/Relu;", "Lio/kinference/core/operators/activations/Activation;", "name", "", "info", "Lio/kinference/operator/OperatorInfo;", "attributes", "", "Lio/kinference/attribute/Attribute;", "", "inputs", "", "outputs", "<init>", "(Ljava/lang/String;Lio/kinference/operator/OperatorInfo;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "Companion", "Lio/kinference/core/operators/activations/ReluVer6;", "inference-core"})
public abstract class Relu
extends Activation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FloatMap activateFloat = new FloatMap(){

        public float apply(float value) {
            return Math.max(0.0f, value);
        }
    };
    @NotNull
    private static final DoubleMap activateDouble = new DoubleMap(){

        public double apply(double value) {
            return Math.max(0.0, value);
        }
    };
    @NotNull
    private static final IntMap activateInt = new IntMap(){

        public int apply(int value) {
            return Math.max(0, value);
        }
    };
    @NotNull
    private static final LongMap activateLong = new LongMap(){

        public long apply(long value) {
            return Math.max(0L, value);
        }
    };
    @NotNull
    private static final ByteMap activateByte = new ByteMap(){

        public byte apply(byte value) {
            return (byte)Math.max(ByteConstants.INSTANCE.getZERO(), value);
        }
    };
    @NotNull
    private static final ShortMap activateShort = new ShortMap(){

        public short apply(short value) {
            return (short)Math.max(ShortConstants.INSTANCE.getZERO(), value);
        }
    };
    @NotNull
    private static final VersionInfo DEFAULT_VERSION = new VersionInfo(6, 0, 2, null);

    private Relu(String name, OperatorInfo info, Map<String, Attribute<Object>> attributes, List<String> inputs, List<String> outputs) {
        super(name, info, attributes, inputs, outputs);
    }

    public /* synthetic */ Relu(String name, OperatorInfo info, Map attributes, List inputs, List outputs, DefaultConstructorMarker $constructor_marker) {
        this(name, info, attributes, inputs, outputs);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JV\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010&0%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020!0(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020!0(H\u0086\u0002\u00a2\u0006\u0002\u0010*R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/kinference/core/operators/activations/Relu$Companion;", "", "<init>", "()V", "activateFloat", "Lio/kinference/ndarray/arrays/FloatMap;", "getActivateFloat", "()Lio/kinference/ndarray/arrays/FloatMap;", "activateDouble", "Lio/kinference/ndarray/arrays/DoubleMap;", "getActivateDouble", "()Lio/kinference/ndarray/arrays/DoubleMap;", "activateInt", "Lio/kinference/ndarray/arrays/IntMap;", "getActivateInt", "()Lio/kinference/ndarray/arrays/IntMap;", "activateLong", "Lio/kinference/ndarray/arrays/LongMap;", "getActivateLong", "()Lio/kinference/ndarray/arrays/LongMap;", "activateByte", "Lio/kinference/ndarray/arrays/ByteMap;", "getActivateByte", "()Lio/kinference/ndarray/arrays/ByteMap;", "activateShort", "Lio/kinference/ndarray/arrays/ShortMap;", "getActivateShort", "()Lio/kinference/ndarray/arrays/ShortMap;", "DEFAULT_VERSION", "Lio/kinference/operator/VersionInfo;", "invoke", "Lio/kinference/core/operators/activations/Relu;", "name", "", "version", "", "attributes", "", "Lio/kinference/attribute/Attribute;", "inputs", "", "outputs", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)Lio/kinference/core/operators/activations/Relu;", "inference-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FloatMap getActivateFloat() {
            return activateFloat;
        }

        @NotNull
        public final DoubleMap getActivateDouble() {
            return activateDouble;
        }

        @NotNull
        public final IntMap getActivateInt() {
            return activateInt;
        }

        @NotNull
        public final LongMap getActivateLong() {
            return activateLong;
        }

        @NotNull
        public final ByteMap getActivateByte() {
            return activateByte;
        }

        @NotNull
        public final ShortMap getActivateShort() {
            return activateShort;
        }

        @NotNull
        public final Relu invoke(@NotNull String name, @Nullable Integer version, @NotNull Map<String, Attribute<Object>> attributes, @NotNull List<String> inputs, @NotNull List<String> outputs) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
            Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
            Integer n = version;
            int n2 = n != null ? n.intValue() : DEFAULT_VERSION.getSinceVersion();
            IntRange intRange = ReluVer6.Companion.getVERSION$inference_core().asRange();
            int n3 = intRange.getFirst();
            if (!(n2 <= intRange.getLast() ? n3 <= n2 : false)) {
                throw new IllegalStateException(("Unsupported version of Relu operator: " + version).toString());
            }
            return new ReluVer6(name, attributes, inputs, outputs);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

