/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.memory.storage;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.MutableNDArrayCore;
import io.kinference.ndarray.arrays.MutableUIntNDArray;
import io.kinference.ndarray.arrays.NDArrayCore;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.UIntNDArray;
import io.kinference.ndarray.arrays.memory.MemoryManager;
import io.kinference.ndarray.arrays.memory.storage.TypedManualHandlingStorage;
import io.kinference.ndarray.arrays.memory.storage.UIntGetBlockFunctionsExtensionKt;
import io.kinference.ndarray.arrays.tiled.UIntTiledArray;
import io.kinference.ndarray.extensions.constants.UIntConstants;
import io.kinference.primitives.types.DataType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UIntArray;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.unsigned.UArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/kinference/ndarray/arrays/memory/storage/UIntManualHandlingArrayStorage;", "Lio/kinference/ndarray/arrays/memory/storage/TypedManualHandlingStorage;", "<init>", "()V", "storage", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lkotlin/collections/ArrayDeque;", "Lkotlin/UIntArray;", "getNDArray", "Lio/kinference/ndarray/arrays/MutableNDArrayCore;", "strides", "Lio/kinference/ndarray/arrays/Strides;", "fillZeros", "", "limiter", "Lio/kinference/ndarray/arrays/memory/MemoryManager;", "returnNDArray", "", "ndarray", "Lio/kinference/ndarray/arrays/NDArrayCore;", "clear", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nUIntManualHandlingArrayStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UIntManualHandlingArrayStorage.kt\nio/kinference/ndarray/arrays/memory/storage/UIntManualHandlingArrayStorage\n+ 2 Utils.kt\nio/kinference/ndarray/extensions/utils/UtilsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,56:1\n57#2,7:57\n57#2,7:64\n216#3,2:71\n*S KotlinDebug\n*F\n+ 1 UIntManualHandlingArrayStorage.kt\nio/kinference/ndarray/arrays/memory/storage/UIntManualHandlingArrayStorage\n*L\n26#1:57,7\n46#1:64,7\n52#1:71,2\n*E\n"})
public final class UIntManualHandlingArrayStorage
implements TypedManualHandlingStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Int2ObjectOpenHashMap<ArrayDeque<UIntArray>> storage = new Int2ObjectOpenHashMap(64);
    @NotNull
    private static final DataType type = DataType.UINT;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNDArrayCore getNDArray(@NotNull Strides strides, boolean fillZeros, @NotNull MemoryManager limiter2) {
        UIntArray[] uIntArrayArray;
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        Intrinsics.checkNotNullParameter((Object)limiter2, (String)"limiter");
        int blockSize = UtilsKt.blockSizeByStrides(strides);
        int blocksNum = strides.getLinearSize() / blockSize;
        if (limiter2.checkMemoryLimitAndAdd(UIntGetBlockFunctionsExtensionKt.getUIntArraySizeInBytes(blockSize * blocksNum))) {
            ArrayDeque arrayDeque;
            Int2ObjectOpenHashMap<ArrayDeque<UIntArray>> $this$getOrPut$iv = this.storage;
            boolean $i$f$getOrPut = false;
            ArrayDeque existingValue$iv = $this$getOrPut$iv.get(blockSize);
            if (existingValue$iv != null) {
                arrayDeque = existingValue$iv;
            } else {
                boolean bl = false;
                ArrayDeque value$iv = new ArrayDeque(blocksNum);
                $this$getOrPut$iv.put(blockSize, (ArrayDeque<UIntArray>)value$iv);
                arrayDeque = value$iv;
            }
            ArrayDeque queue = arrayDeque;
            UIntArray[] uIntArrayArray2 = new UIntArray[blocksNum];
            for (int i = 0; i < blocksNum; ++i) {
                int[] nArray;
                int n = i;
                UIntArray[] uIntArrayArray3 = uIntArrayArray2;
                int n2 = n;
                UIntArray uIntArray = (UIntArray)queue.removeFirstOrNull();
                Object object = uIntArray != null ? uIntArray.unbox-impl() : null;
                if (object != null) {
                    void $this$getNDArray_u24lambda_u241;
                    int[] nArray2;
                    int[] nArray3 = nArray2 = object;
                    int n3 = n2;
                    UIntArray[] uIntArrayArray4 = uIntArrayArray3;
                    boolean bl = false;
                    UArraysKt.fill-2fe2U9s$default((int[])$this$getNDArray_u24lambda_u241, (int)UIntConstants.INSTANCE.getZERO-pVg5ArA(), (int)0, (int)0, (int)6, null);
                    Unit unit = Unit.INSTANCE;
                    uIntArrayArray3 = uIntArrayArray4;
                    n2 = n3;
                    nArray = nArray2;
                } else {
                    nArray = UIntArray.constructor-impl((int)blockSize);
                }
                uIntArrayArray3[n2] = UIntArray.box-impl((int[])nArray);
            }
            uIntArrayArray = uIntArrayArray2;
        } else {
            int queue = 0;
            UIntArray[] uIntArrayArray5 = new UIntArray[blocksNum];
            while (queue < blocksNum) {
                int n = queue++;
                uIntArrayArray5[n] = UIntArray.box-impl((int[])UIntArray.constructor-impl((int)blockSize));
            }
            uIntArrayArray = uIntArrayArray5;
        }
        UIntArray[] blocks = uIntArrayArray;
        UIntTiledArray tiled = new UIntTiledArray(blocks);
        return new MutableUIntNDArray(tiled, strides);
    }

    @Override
    public void returnNDArray(@NotNull NDArrayCore ndarray) {
        ArrayDeque arrayDeque;
        Intrinsics.checkNotNullParameter((Object)ndarray, (String)"ndarray");
        if (!(ndarray instanceof UIntNDArray)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int blockSize = ((UIntNDArray)ndarray).getArray().getBlockSize();
        int blocksNum = ((UIntNDArray)ndarray).getArray().getBlocksNum();
        Int2ObjectOpenHashMap<ArrayDeque<UIntArray>> $this$getOrPut$iv = this.storage;
        boolean $i$f$getOrPut = false;
        ArrayDeque existingValue$iv = $this$getOrPut$iv.get(blockSize);
        if (existingValue$iv != null) {
            arrayDeque = existingValue$iv;
        } else {
            boolean bl = false;
            ArrayDeque value$iv = new ArrayDeque(blocksNum);
            $this$getOrPut$iv.put(blockSize, (ArrayDeque<UIntArray>)value$iv);
            arrayDeque = value$iv;
        }
        ArrayDeque queue = arrayDeque;
        CollectionsKt.addAll((Collection)((Collection)queue), (Object[])((UIntNDArray)ndarray).getArray().getBlocks());
    }

    @Override
    public void clear() {
        Map $this$forEach$iv = this.storage;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            ArrayDeque queue = (ArrayDeque)entry.getValue();
            queue.clear();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/kinference/ndarray/arrays/memory/storage/UIntManualHandlingArrayStorage$Companion;", "", "<init>", "()V", "type", "Lio/kinference/primitives/types/DataType;", "ndarray-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

