/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.tiled;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.memory.contexts.AutoAllocatorContext;
import io.kinference.ndarray.arrays.memory.storage.PrimitiveGetBlockFunctionsExtensionKt;
import io.kinference.ndarray.arrays.pointers.PrimitivePointer;
import io.kinference.ndarray.arrays.pointers.PrimitivePointerKt;
import io.kinference.ndarray.arrays.tiled.PrimitiveTiledArray;
import io.kinference.primitives.annotations.FilterPrimitives;
import io.kinference.primitives.annotations.GenerateNameFromPrimitives;
import io.kinference.primitives.annotations.MakePublic;
import io.kinference.primitives.types.DataType;
import io.kinference.primitives.types.PrimitiveArray;
import io.kinference.primitives.types.PrimitiveType;
import io.kinference.utils.inlines.InlineInt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GenerateNameFromPrimitives
@MakePublic
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0011\b\u0001\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u000bJ\u0006\u0010\u0015\u001a\u00020\u0004J\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0018\u001a\u00020\u000bJ\u0011\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0086\u0002J\u0019\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001aH\u0086\u0002J\u0006\u0010\u001e\u001a\u00020\u0000J,\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00002\b\b\u0002\u0010!\u001a\u00020\u000b2\b\b\u0002\u0010\"\u001a\u00020\u000b2\b\b\u0002\u0010#\u001a\u00020\u000bJ\u0010\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0007J\u0016\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bJ\"\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\b\b\u0002\u0010*\u001a\u00020\u000b2\b\b\u0002\u0010+\u001a\u00020\u000bR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006-"}, d2={"Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;", "", "blocks", "", "Lio/kinference/primitives/types/PrimitiveArray;", "<init>", "([Lio/kinference/primitives/types/PrimitiveArray;)V", "getBlocks", "()[Lio/kinference/primitives/types/PrimitiveArray;", "[Lio/kinference/primitives/types/PrimitiveArray;", "size", "", "getSize", "()I", "blockSize", "getBlockSize", "blocksNum", "getBlocksNum", "pointer", "Lio/kinference/ndarray/arrays/pointers/PrimitivePointer;", "startIndex", "toArray", "indexFor", "Lkotlin/Pair;", "i", "get", "Lio/kinference/primitives/types/PrimitiveType;", "set", "", "value", "copyOf", "copyInto", "dest", "destOffset", "srcStart", "srcEnd", "plus", "other", "copyOfRange", "fromIndex", "toIndex", "fill", "from", "to", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nPrimitiveTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitiveTiledArray.kt\nio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray\n+ 2 PrimitivePointer.kt\nio/kinference/ndarray/arrays/pointers/PrimitivePointerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n259#2:192\n261#2,30:194\n259#2:224\n261#2,30:226\n1#3:193\n1#3:225\n*S KotlinDebug\n*F\n+ 1 PrimitiveTiledArray.kt\nio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray\n*L\n150#1:192\n150#1:194,30\n157#1:224\n157#1:226,30\n150#1:193\n157#1:225\n*E\n"})
public final class PrimitiveTiledArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrimitiveArray[] blocks;
    private final int size;
    private final int blockSize;
    private final int blocksNum;
    @NotNull
    private static final DataType type = DataType.Companion.getCurrentPrimitive();

    public PrimitiveTiledArray(@NotNull PrimitiveArray[] blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        this.blocks = blocks;
        this.blockSize = this.blocks.length == 0 ? 0 : ((PrimitiveArray)ArraysKt.first((Object[])this.blocks)).getSize();
        this.blocksNum = this.blocks.length;
        this.size = this.blocksNum * this.blockSize;
    }

    @NotNull
    public final PrimitiveArray[] getBlocks() {
        return this.blocks;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final int getBlocksNum() {
        return this.blocksNum;
    }

    @NotNull
    public final PrimitivePointer pointer(int startIndex) {
        return new PrimitivePointer(this, startIndex);
    }

    public static /* synthetic */ PrimitivePointer pointer$default(PrimitiveTiledArray primitiveTiledArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return primitiveTiledArray.pointer(n);
    }

    @NotNull
    public final PrimitiveArray toArray() {
        if (this.size == 0) {
            return new PrimitiveArray(0);
        }
        PrimitiveArray array = new PrimitiveArray(this.size);
        int offset = 0;
        for (PrimitiveArray block : this.blocks) {
            PrimitiveArray.copyInto$default(block, array, offset, 0, 0, 12, null);
            offset += this.blockSize;
        }
        return array;
    }

    @NotNull
    public final Pair<Integer, Integer> indexFor(int i) {
        int blockIdx = i / this.blockSize;
        int blockOff = i % this.blockSize;
        return TuplesKt.to((Object)blockIdx, (Object)blockOff);
    }

    @NotNull
    public final PrimitiveType get(int i) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        return this.blocks[blockIdx].get(blockOff);
    }

    public final void set(int i, @NotNull PrimitiveType value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        this.blocks[blockIdx].set(blockOff, value);
    }

    @NotNull
    public final PrimitiveTiledArray copyOf() {
        int n = 0;
        int n2 = this.blocksNum;
        PrimitiveArray[] primitiveArrayArray = new PrimitiveArray[n2];
        while (n < n2) {
            int n3 = n++;
            primitiveArrayArray[n3] = new PrimitiveArray(this.blockSize);
        }
        PrimitiveArray[] copyBlocks = primitiveArrayArray;
        n2 = this.blocksNum;
        for (int blockNum = 0; blockNum < n2; ++blockNum) {
            PrimitiveArray thisBlock = this.blocks[blockNum];
            PrimitiveArray destBlock = copyBlocks[blockNum];
            PrimitiveArray.copyInto$default(thisBlock, destBlock, 0, 0, 0, 14, null);
        }
        return new PrimitiveTiledArray(copyBlocks);
    }

    /*
     * WARNING - void declaration
     */
    public final void copyInto(@NotNull PrimitiveTiledArray dest, int destOffset, int srcStart, int srcEnd) {
        void $this$accept$iv;
        PrimitivePointer destPtr;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (srcStart == srcEnd) {
            return;
        }
        PrimitivePointer thisPtr = new PrimitivePointer(this, srcStart);
        PrimitivePointer primitivePointer = destPtr = new PrimitivePointer(dest, destOffset);
        int count$iv = srcEnd - srcStart;
        boolean $i$f$accept = false;
        if (!PrimitivePointerKt.isCompatibleBySize((PrimitivePointer)$this$accept$iv, thisPtr, count$iv)) {
            boolean $i$a$-require-PrimitivePointerKt$accept$1$iv22 = false;
            String $i$a$-require-PrimitivePointerKt$accept$1$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$accept$1$iv22.toString());
        }
        if (PrimitivePointerKt.isCompatibleWith((PrimitivePointer)$this$accept$iv, thisPtr)) {
            int dstOffset$iv;
            PrimitiveArray dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                PrimitiveArray srcBlock$iv = thisPtr.getCurrentBlock();
                if (dstBlock$iv.getSize() <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    thisPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    thisPtr.setIndexInBlock(thisPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.getSize(), dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void src;
                    dstBlock$iv.get(index$iv);
                    PrimitiveType primitiveType = srcBlock$iv.get(index$iv);
                    int n2 = index$iv++;
                    PrimitiveArray primitiveArray = dstBlock$iv;
                    boolean bl = false;
                    void var20_25 = src;
                    primitiveArray.set(n2, (PrimitiveType)var20_25);
                }
            }
        } else {
            while (end$iv > 0) {
                $this$accept$iv.get();
                PrimitiveType src = thisPtr.getAndIncrement();
                void var18_23 = $this$accept$iv;
                boolean bl = false;
                var18_23.set(src);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
    }

    public static /* synthetic */ void copyInto$default(PrimitiveTiledArray primitiveTiledArray, PrimitiveTiledArray primitiveTiledArray2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = primitiveTiledArray.size;
        }
        primitiveTiledArray.copyInto(primitiveTiledArray2, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @FilterPrimitives(exclude={DataType.BOOLEAN})
    @NotNull
    public final PrimitiveTiledArray plus(@NotNull PrimitiveTiledArray other) {
        void $this$accept$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        PrimitivePointer thisPtr = new PrimitivePointer(this, 0, 2, null);
        PrimitivePointer destPtr = new PrimitivePointer(other, 0, 2, null);
        PrimitivePointer primitivePointer = thisPtr;
        int count$iv = this.size;
        boolean $i$f$accept = false;
        if (!PrimitivePointerKt.isCompatibleBySize((PrimitivePointer)$this$accept$iv, destPtr, count$iv)) {
            boolean $i$a$-require-PrimitivePointerKt$accept$1$iv22 = false;
            String $i$a$-require-PrimitivePointerKt$accept$1$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$accept$1$iv22.toString());
        }
        if (PrimitivePointerKt.isCompatibleWith((PrimitivePointer)$this$accept$iv, destPtr)) {
            int dstOffset$iv;
            PrimitiveArray dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                PrimitiveArray srcBlock$iv = destPtr.getCurrentBlock();
                if (dstBlock$iv.getSize() <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    destPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    destPtr.setIndexInBlock(destPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.getSize(), dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void dst;
                    void src;
                    PrimitiveType primitiveType = srcBlock$iv.get(index$iv);
                    PrimitiveType primitiveType2 = dstBlock$iv.get(index$iv);
                    int n2 = index$iv++;
                    PrimitiveArray primitiveArray = dstBlock$iv;
                    boolean bl = false;
                    PrimitiveType primitiveType3 = src.plus((PrimitiveType)dst).toPrimitive();
                    primitiveArray.set(n2, primitiveType3);
                }
            }
        } else {
            while (end$iv > 0) {
                PrimitiveType dst = destPtr.getAndIncrement();
                PrimitiveType src = $this$accept$iv.get();
                void var16_22 = $this$accept$iv;
                boolean bl = false;
                var16_22.set(src.plus(dst).toPrimitive());
                $this$accept$iv.increment();
                --end$iv;
            }
        }
        return this;
    }

    @NotNull
    public final PrimitiveArray copyOfRange(int fromIndex, int toIndex) {
        int n;
        PrimitiveArray array = new PrimitiveArray(toIndex - fromIndex);
        PrimitivePointer pointer = new PrimitivePointer(this, fromIndex);
        IntRange intRange = array.getIndices();
        int i = intRange.getFirst();
        if (i <= (n = intRange.getLast())) {
            while (true) {
                array.set(i, pointer.getAndIncrement());
                if (i == n) break;
                ++i;
            }
        }
        return array;
    }

    public final void fill(@NotNull PrimitiveType value, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (from == to) {
            return;
        }
        PrimitivePointer pointer = new PrimitivePointer(this, from);
        for (int count = to - from; count > 0; count -= this.blockSize) {
            PrimitiveArray block = pointer.getCurrentBlock();
            int offset = pointer.getIndexInBlock();
            pointer.blockIncrement();
            block.fill(value, offset, Math.min(this.blockSize, count + offset));
        }
    }

    public static /* synthetic */ void fill$default(PrimitiveTiledArray primitiveTiledArray, PrimitiveType primitiveType, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = primitiveTiledArray.size;
        }
        primitiveTiledArray.fill(primitiveType, n, n2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086B\u00a2\u0006\u0002\u0010\fJ*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0086B\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0086B\u00a2\u0006\u0002\u0010\u0014J*\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0086B\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0086B\u00a2\u0006\u0002\u0010\u001bJ2\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0086B\u00a2\u0006\u0002\u0010\u001cJ\"\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00100\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray$Companion;", "", "<init>", "()V", "type", "Lio/kinference/primitives/types/DataType;", "getType", "()Lio/kinference/primitives/types/DataType;", "invoke", "Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;", "strides", "Lio/kinference/ndarray/arrays/Strides;", "(Lio/kinference/ndarray/arrays/Strides;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "init", "Lkotlin/Function1;", "Lio/kinference/utils/inlines/InlineInt;", "Lio/kinference/primitives/types/PrimitiveType;", "(Lio/kinference/ndarray/arrays/Strides;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shape", "", "([ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "([ILkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "array", "Lio/kinference/primitives/types/PrimitiveArray;", "size", "", "blockSize", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(IILkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "matrixLike", "ndarray-core"})
    @SourceDebugExtension(value={"SMAP\nPrimitiveTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitiveTiledArray.kt\nio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1#2:192\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataType getType() {
            return type;
        }

        @Nullable
        public final Object invoke(@NotNull Strides strides, @NotNull Continuation<? super PrimitiveTiledArray> $completion) {
            int blockSize = UtilsKt.blockSizeByStrides(strides);
            return Companion.invoke(strides.getLinearSize(), blockSize, $completion);
        }

        @Nullable
        public final Object invoke(@NotNull Strides strides, @NotNull Function1<? super InlineInt, ? extends PrimitiveType> init, @NotNull Continuation<? super PrimitiveTiledArray> $completion) {
            int blockSize = UtilsKt.blockSizeByStrides(strides);
            return Companion.invoke(strides.getLinearSize(), blockSize, init, $completion);
        }

        @Nullable
        public final Object invoke(@NotNull int[] shape, @NotNull Continuation<? super PrimitiveTiledArray> $completion) {
            return this.invoke(new Strides(shape), $completion);
        }

        @Nullable
        public final Object invoke(@NotNull int[] shape, @NotNull Function1<? super InlineInt, ? extends PrimitiveType> init, @NotNull Continuation<? super PrimitiveTiledArray> $completion) {
            return this.invoke(new Strides(shape), init, $completion);
        }

        @NotNull
        public final PrimitiveTiledArray invoke(@NotNull Strides strides, @NotNull PrimitiveArray array) {
            Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int blockSize = UtilsKt.blockSizeByStrides(strides);
            int countBlocks = array.getSize() / blockSize;
            int n = 0;
            PrimitiveArray[] primitiveArrayArray = new PrimitiveArray[countBlocks];
            while (n < countBlocks) {
                int n2 = n++;
                primitiveArrayArray[n2] = new PrimitiveArray(blockSize);
            }
            PrimitiveArray[] blocksArray = primitiveArrayArray;
            n = 0;
            while (n < countBlocks) {
                int blockNum = n++;
                boolean bl = false;
                PrimitiveArray.copyInto$default(array, blocksArray[blockNum], 0, blockNum * blockSize, (blockNum + 1) * blockSize, 2, null);
            }
            return new PrimitiveTiledArray(blocksArray);
        }

        @Nullable
        public final Object invoke(int size, int blockSize, @NotNull Continuation<? super PrimitiveTiledArray> $completion) {
            if (blockSize != 0 && !(size % blockSize == 0)) {
                boolean $i$a$-require-PrimitiveTiledArray$Companion$invoke$82 = false;
                String $i$a$-require-PrimitiveTiledArray$Companion$invoke$82 = "Size must divide blockSize";
                throw new IllegalArgumentException($i$a$-require-PrimitiveTiledArray$Companion$invoke$82.toString());
            }
            int blocksNum = blockSize == 0 ? 0 : size / blockSize;
            PrimitiveArray[] primitiveArrayArray = (PrimitiveArray[])$completion.getContext().get((CoroutineContext.Key)AutoAllocatorContext.Key);
            if (primitiveArrayArray == null || (primitiveArrayArray = PrimitiveGetBlockFunctionsExtensionKt.getPrimitiveBlock((AutoAllocatorContext)primitiveArrayArray, blocksNum, blockSize)) == null) {
                int n = 0;
                PrimitiveArray[] primitiveArrayArray2 = new PrimitiveArray[blocksNum];
                while (n < blocksNum) {
                    int n2 = n++;
                    primitiveArrayArray2[n2] = new PrimitiveArray(blockSize);
                }
                primitiveArrayArray = primitiveArrayArray2;
            }
            PrimitiveArray[] blocks = primitiveArrayArray;
            return new PrimitiveTiledArray(blocks);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object invoke(int var1_1, int var2_2, @NotNull Function1<? super InlineInt, ? extends PrimitiveType> var3_3, @NotNull Continuation<? super PrimitiveTiledArray> $completion) {
            if (!($completion instanceof invoke.8)) ** GOTO lbl-1000
            var13_5 = $completion;
            if ((var13_5.label & -2147483648) != 0) {
                var13_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    int I$0;
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.invoke(0, 0, null, (Continuation<? super PrimitiveTiledArray>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var14_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = init;
                    $continuation.I$0 = blockSize;
                    $continuation.label = 1;
                    v0 = PrimitiveTiledArray.Companion.invoke((int)size, blockSize, (Continuation<? super PrimitiveTiledArray>)$continuation);
                    if (v0 == var14_7) {
                        return var14_7;
                    }
                    ** GOTO lbl24
                }
                case 1: {
                    blockSize = $continuation.I$0;
                    init = (Function1)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    tiledArray = (PrimitiveTiledArray)v0;
                    count = 0;
                    for (PrimitiveArray block : tiledArray.getBlocks()) {
                        for (idx = 0; idx < blockSize; ++idx) {
                            block.set(idx, (PrimitiveType)init.invoke((Object)InlineInt.box-impl(InlineInt.constructor-impl(count++))));
                        }
                    }
                    return tiledArray;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @NotNull
        public final PrimitiveTiledArray matrixLike(@NotNull int[] shape, @NotNull Function1<? super Integer, ? extends PrimitiveType> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            if (!(shape.length == 1 || shape.length == 2)) {
                boolean $i$a$-require-PrimitiveTiledArray$Companion$matrixLike$22 = false;
                String $i$a$-require-PrimitiveTiledArray$Companion$matrixLike$22 = "NDArray should be of rank <= 2. Got rank=" + shape.length;
                throw new IllegalArgumentException($i$a$-require-PrimitiveTiledArray$Companion$matrixLike$22.toString());
            }
            int count = 0;
            int blockSize = ArraysKt.last((int[])shape);
            int blocksNum = shape.length == 1 ? 1 : shape[0];
            int n = 0;
            PrimitiveArray[] primitiveArrayArray = new PrimitiveArray[blocksNum];
            while (n < blocksNum) {
                int n2 = n++;
                primitiveArrayArray[n2] = new PrimitiveArray(blockSize);
            }
            PrimitiveArray[] blocks = primitiveArrayArray;
            int n3 = blocks.length;
            for (n = 0; n < n3; ++n) {
                PrimitiveArray block = blocks[n];
                for (int idx = 0; idx < blockSize; ++idx) {
                    block.set(idx, (PrimitiveType)init.invoke((Object)count++));
                }
            }
            return new PrimitiveTiledArray(blocks);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

