/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions.broadcasting;

import io.kinference.ndarray.arrays.MutableUIntNDArray;
import io.kinference.ndarray.arrays.UIntBinaryOperation;
import io.kinference.ndarray.arrays.UIntNDArray;
import io.kinference.ndarray.extensions.broadcasting.BroadcastingInfo;
import io.kinference.ndarray.extensions.broadcasting.ReshapeViewKt;
import io.kinference.ndarray.extensions.broadcasting.ScalarBroadcastFun;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UIntArray;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a(\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"broadcastTwoTensorsUInt", "Lio/kinference/ndarray/arrays/MutableUIntNDArray;", "left", "Lio/kinference/ndarray/arrays/UIntNDArray;", "right", "dest", "op", "Lio/kinference/ndarray/arrays/UIntBinaryOperation;", "executeWithoutBroadcasting", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nBroadcastTwoArgumentsUInt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BroadcastTwoArgumentsUInt.kt\nio/kinference/ndarray/extensions/broadcasting/BroadcastTwoArgumentsUIntKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class BroadcastTwoArgumentsUIntKt {
    @NotNull
    public static final MutableUIntNDArray broadcastTwoTensorsUInt(@NotNull UIntNDArray left, @NotNull UIntNDArray right, @NotNull MutableUIntNDArray dest, @NotNull UIntBinaryOperation op) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Object[] objectArray = new UIntNDArray[]{left, right};
        BroadcastingInfo broadcastingInfo = BroadcastingInfo.Companion.create(CollectionsKt.listOf((Object[])objectArray));
        if (!Arrays.equals(dest.getShape(), broadcastingInfo.getDestShape())) {
            boolean bl = false;
            String string = "Destination has incorrect shape, expected: " + ArraysKt.joinToString$default((int[])broadcastingInfo.getDestShape(), null, null, null, (int)0, null, null, (int)63, null) + ", actual " + ArraysKt.joinToString$default((int[])dest.getShape(), null, null, null, (int)0, null, null, (int)63, null);
            throw new IllegalArgumentException(string.toString());
        }
        if (broadcastingInfo.getBroadcastingAxes().isEmpty()) {
            return BroadcastTwoArgumentsUIntKt.executeWithoutBroadcasting(left, right, dest, op);
        }
        int totalAxesToBroadcast = broadcastingInfo.getBroadcastAlongLastAxis() ? broadcastingInfo.getBroadcastingAxes().size() - 1 : broadcastingInfo.getBroadcastingAxes().size();
        int[][] nArray = broadcastingInfo.getBroadcastingShapes();
        int[] leftBroadcastingShape = (int[])((Object[])nArray)[0];
        int[] rightBroadcastingShape = (int[])((Object[])nArray)[1];
        int[] destBroadcastingShape = broadcastingInfo.getBroadcastingDestShape();
        int destBlocksInRow = ArraysKt.last((int[])destBroadcastingShape) / dest.getArray().getBlockSize();
        int[] leftOffsets = ReshapeViewKt.makeOffsets(leftBroadcastingShape, ArraysKt.last((int[])leftBroadcastingShape) / left.getArray().getBlockSize());
        int[] rightOffsets = ReshapeViewKt.makeOffsets(rightBroadcastingShape, ArraysKt.last((int[])rightBroadcastingShape) / right.getArray().getBlockSize());
        int[] destOffsets = ReshapeViewKt.makeOffsets(destBroadcastingShape, destBlocksInRow);
        boolean leftIsScalar = broadcastingInfo.getBroadcastAlongLastAxis() && ArraysKt.last((int[])leftBroadcastingShape) == 1;
        boolean rightIsScalar = broadcastingInfo.getBroadcastAlongLastAxis() && ArraysKt.last((int[])rightBroadcastingShape) == 1;
        UIntArray[] leftBlocks = left.getArray().getBlocks();
        UIntArray[] rightBlocks = right.getArray().getBlocks();
        UIntArray[] destBlocks = dest.getArray().getBlocks();
        ScalarBroadcastFun leftIsScalarFun = (arg_0, arg_1, arg_2, arg_3) -> BroadcastTwoArgumentsUIntKt.broadcastTwoTensorsUInt$lambda$1(destBroadcastingShape, leftOffsets, rightOffsets, destOffsets, leftBlocks, destBlocksInRow, destBlocks, rightBlocks, op, arg_0, arg_1, arg_2, arg_3);
        ScalarBroadcastFun rightIsScalarFun = (arg_0, arg_1, arg_2, arg_3) -> BroadcastTwoArgumentsUIntKt.broadcastTwoTensorsUInt$lambda$2(destBroadcastingShape, leftOffsets, rightOffsets, destOffsets, rightBlocks, destBlocksInRow, destBlocks, leftBlocks, op, arg_0, arg_1, arg_2, arg_3);
        ScalarBroadcastFun defaultFun = (arg_0, arg_1, arg_2, arg_3) -> BroadcastTwoArgumentsUIntKt.broadcastTwoTensorsUInt$lambda$3(destBlocksInRow, leftBlocks, rightBlocks, destBlocks, op, arg_0, arg_1, arg_2, arg_3);
        ScalarBroadcastFun broadcastingFun = leftIsScalar ? leftIsScalarFun : (rightIsScalar ? rightIsScalarFun : defaultFun);
        BroadcastTwoArgumentsUIntKt.broadcastTwoTensorsUInt$broadcast(totalAxesToBroadcast, broadcastingFun, destBroadcastingShape, leftOffsets, rightOffsets, destOffsets, leftBroadcastingShape, rightBroadcastingShape, 0, 0, 0, 0);
        return dest;
    }

    private static final MutableUIntNDArray executeWithoutBroadcasting(UIntNDArray left, UIntNDArray right, MutableUIntNDArray dest, UIntBinaryOperation op) {
        UIntArray[] leftBlocks = left.getArray().getBlocks();
        UIntArray[] rightBlocks = right.getArray().getBlocks();
        UIntArray[] destBlocks = dest.getArray().getBlocks();
        int n = destBlocks.length;
        for (int blockIdx = 0; blockIdx < n; ++blockIdx) {
            int[] destBlock = destBlocks[blockIdx].unbox-impl();
            int[] leftBlock = leftBlocks[blockIdx].unbox-impl();
            int[] rightBlock = rightBlocks[blockIdx].unbox-impl();
            int n2 = UIntArray.getSize-impl((int[])destBlock);
            for (int idx = 0; idx < n2; ++idx) {
                UIntArray.set-VXSXFK8((int[])destBlock, (int)idx, (int)op.invoke-YcLip9I(UIntArray.get-pVg5ArA((int[])leftBlock, (int)idx), UIntArray.get-pVg5ArA((int[])rightBlock, (int)idx)));
            }
        }
        return dest;
    }

    private static final void broadcastTwoTensorsUInt$lambda$1(int[] $destBroadcastingShape, int[] $leftOffsets, int[] $rightOffsets, int[] $destOffsets, UIntArray[] $leftBlocks, int $destBlocksInRow, UIntArray[] $destBlocks, UIntArray[] $rightBlocks, UIntBinaryOperation $op, int leftOffset, int rightOffset, int destOffset, int axisToBroadcastIdx) {
        Intrinsics.checkNotNullParameter((Object)$destBroadcastingShape, (String)"$destBroadcastingShape");
        Intrinsics.checkNotNullParameter((Object)$leftOffsets, (String)"$leftOffsets");
        Intrinsics.checkNotNullParameter((Object)$rightOffsets, (String)"$rightOffsets");
        Intrinsics.checkNotNullParameter((Object)$destOffsets, (String)"$destOffsets");
        Intrinsics.checkNotNullParameter((Object)$leftBlocks, (String)"$leftBlocks");
        Intrinsics.checkNotNullParameter((Object)$destBlocks, (String)"$destBlocks");
        Intrinsics.checkNotNullParameter((Object)$rightBlocks, (String)"$rightBlocks");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        int shapeIdx = axisToBroadcastIdx * 2;
        int batchSize = $destBroadcastingShape[shapeIdx];
        for (int batchIdx = 0; batchIdx < batchSize; ++batchIdx) {
            int leftBatchOffset = leftOffset + $leftOffsets[shapeIdx] * batchIdx;
            int rightBatchOffset = rightOffset + $rightOffsets[shapeIdx] * batchIdx;
            int destBatchOffset = destOffset + $destOffsets[shapeIdx] * batchIdx;
            int leftScalar = UIntArray.get-pVg5ArA((int[])$leftBlocks[leftBatchOffset].unbox-impl(), (int)0);
            for (int blockIdx = 0; blockIdx < $destBlocksInRow; ++blockIdx) {
                int[] destBlock = $destBlocks[destBatchOffset + blockIdx].unbox-impl();
                int[] rightBlock = $rightBlocks[rightBatchOffset + blockIdx].unbox-impl();
                int n = UIntArray.getSize-impl((int[])destBlock);
                for (int idx = 0; idx < n; ++idx) {
                    UIntArray.set-VXSXFK8((int[])destBlock, (int)idx, (int)$op.invoke-YcLip9I(leftScalar, UIntArray.get-pVg5ArA((int[])rightBlock, (int)idx)));
                }
            }
        }
    }

    private static final void broadcastTwoTensorsUInt$lambda$2(int[] $destBroadcastingShape, int[] $leftOffsets, int[] $rightOffsets, int[] $destOffsets, UIntArray[] $rightBlocks, int $destBlocksInRow, UIntArray[] $destBlocks, UIntArray[] $leftBlocks, UIntBinaryOperation $op, int leftOffset, int rightOffset, int destOffset, int axisToBroadcastIdx) {
        Intrinsics.checkNotNullParameter((Object)$destBroadcastingShape, (String)"$destBroadcastingShape");
        Intrinsics.checkNotNullParameter((Object)$leftOffsets, (String)"$leftOffsets");
        Intrinsics.checkNotNullParameter((Object)$rightOffsets, (String)"$rightOffsets");
        Intrinsics.checkNotNullParameter((Object)$destOffsets, (String)"$destOffsets");
        Intrinsics.checkNotNullParameter((Object)$rightBlocks, (String)"$rightBlocks");
        Intrinsics.checkNotNullParameter((Object)$destBlocks, (String)"$destBlocks");
        Intrinsics.checkNotNullParameter((Object)$leftBlocks, (String)"$leftBlocks");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        int shapeIdx = axisToBroadcastIdx * 2;
        int batchSize = $destBroadcastingShape[shapeIdx];
        for (int batchIdx = 0; batchIdx < batchSize; ++batchIdx) {
            int leftBatchOffset = leftOffset + $leftOffsets[shapeIdx] * batchIdx;
            int rightBatchOffset = rightOffset + $rightOffsets[shapeIdx] * batchIdx;
            int destBatchOffset = destOffset + $destOffsets[shapeIdx] * batchIdx;
            int rightScalar = UIntArray.get-pVg5ArA((int[])$rightBlocks[rightBatchOffset].unbox-impl(), (int)0);
            for (int blockIdx = 0; blockIdx < $destBlocksInRow; ++blockIdx) {
                int[] destBlock = $destBlocks[destBatchOffset + blockIdx].unbox-impl();
                int[] leftBlock = $leftBlocks[leftBatchOffset + blockIdx].unbox-impl();
                int n = UIntArray.getSize-impl((int[])destBlock);
                for (int idx = 0; idx < n; ++idx) {
                    UIntArray.set-VXSXFK8((int[])destBlock, (int)idx, (int)$op.invoke-YcLip9I(UIntArray.get-pVg5ArA((int[])leftBlock, (int)idx), rightScalar));
                }
            }
        }
    }

    private static final void broadcastTwoTensorsUInt$lambda$3(int $destBlocksInRow, UIntArray[] $leftBlocks, UIntArray[] $rightBlocks, UIntArray[] $destBlocks, UIntBinaryOperation $op, int leftOffset, int rightOffset, int destOffset, int n) {
        Intrinsics.checkNotNullParameter((Object)$leftBlocks, (String)"$leftBlocks");
        Intrinsics.checkNotNullParameter((Object)$rightBlocks, (String)"$rightBlocks");
        Intrinsics.checkNotNullParameter((Object)$destBlocks, (String)"$destBlocks");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        for (int blockIdx = 0; blockIdx < $destBlocksInRow; ++blockIdx) {
            int[] leftBlock = $leftBlocks[leftOffset + blockIdx].unbox-impl();
            int[] rightBlock = $rightBlocks[rightOffset + blockIdx].unbox-impl();
            int[] destBlock = $destBlocks[destOffset + blockIdx].unbox-impl();
            int n2 = UIntArray.getSize-impl((int[])destBlock);
            for (int idx = 0; idx < n2; ++idx) {
                UIntArray.set-VXSXFK8((int[])destBlock, (int)idx, (int)$op.invoke-YcLip9I(UIntArray.get-pVg5ArA((int[])leftBlock, (int)idx), UIntArray.get-pVg5ArA((int[])rightBlock, (int)idx)));
            }
        }
    }

    private static final void broadcastTwoTensorsUInt$broadcast(int totalAxesToBroadcast, ScalarBroadcastFun broadcastingFun, int[] destBroadcastingShape, int[] leftOffsets, int[] rightOffsets, int[] destOffsets, int[] leftBroadcastingShape, int[] rightBroadcastingShape, int leftOffset, int rightOffset, int destOffset, int axisToBroadcastIdx) {
        if (axisToBroadcastIdx == totalAxesToBroadcast) {
            broadcastingFun.invoke(leftOffset, rightOffset, destOffset, axisToBroadcastIdx);
        } else {
            int shapeIdx = axisToBroadcastIdx * 2;
            int batchSize = destBroadcastingShape[shapeIdx];
            int dimSize = destBroadcastingShape[shapeIdx + 1];
            for (int batchIdx = 0; batchIdx < batchSize; ++batchIdx) {
                int leftBatchOffset = leftOffset + leftOffsets[shapeIdx] * batchIdx;
                int rightBatchOffset = rightOffset + rightOffsets[shapeIdx] * batchIdx;
                int destBatchOffset = destOffset + destOffsets[shapeIdx] * batchIdx;
                for (int dimIdx = 0; dimIdx < dimSize; ++dimIdx) {
                    int leftFullOffset = leftBatchOffset + dimIdx % leftBroadcastingShape[shapeIdx + 1] * leftOffsets[shapeIdx + 1];
                    int rightFullOffset = rightBatchOffset + dimIdx % rightBroadcastingShape[shapeIdx + 1] * rightOffsets[shapeIdx + 1];
                    int destFullOffset = destBatchOffset + dimIdx * destOffsets[shapeIdx + 1];
                    BroadcastTwoArgumentsUIntKt.broadcastTwoTensorsUInt$broadcast(totalAxesToBroadcast, broadcastingFun, destBroadcastingShape, leftOffsets, rightOffsets, destOffsets, leftBroadcastingShape, rightBroadcastingShape, leftFullOffset, rightFullOffset, destFullOffset, axisToBroadcastIdx + 1);
                }
            }
        }
    }
}

