/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.protobuf.arrays;

import io.kinference.protobuf.arrays.PrimitiveArrayBuilder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@RX\u0094\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lio/kinference/protobuf/arrays/LongArrayBuilder;", "Lio/kinference/protobuf/arrays/PrimitiveArrayBuilder;", "", "data", "<init>", "([J)V", "value", "", "position", "getPosition", "()I", "checkCapacity", "", "requiredCapacity", "checkCapacity$serializer_protobuf", "append", "element", "", "build", "serializer-protobuf"})
public final class LongArrayBuilder
extends PrimitiveArrayBuilder<long[]> {
    @NotNull
    private long[] data;
    private int position;

    public LongArrayBuilder(@NotNull long[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        this.position = this.data.length;
        this.checkCapacity$serializer_protobuf(50);
    }

    @Override
    protected int getPosition() {
        return this.position;
    }

    @Override
    public void checkCapacity$serializer_protobuf(int requiredCapacity) {
        if (this.data.length < requiredCapacity) {
            long[] lArray = Arrays.copyOf(this.data, RangesKt.coerceAtLeast((int)requiredCapacity, (int)(this.data.length * 2)));
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
            this.data = lArray;
        }
    }

    public final void append(long element) {
        PrimitiveArrayBuilder.checkCapacity$serializer_protobuf$default(this, 0, 1, null);
        int n = this.getPosition();
        this.position = n + 1;
        this.data[n] = element;
    }

    @Override
    @NotNull
    public long[] build() {
        long[] lArray = Arrays.copyOf(this.data, this.getPosition());
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
        return lArray;
    }
}

