/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.trees;

import io.kinference.ndarray.arrays.NumberNDArray;
import io.kinference.trees.Aggregator;
import io.kinference.trees.TreeSplitType;
import io.kinference.trees.TreeSplitter;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003BW\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J,\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\b\b\u0002\u0010\u001d\u001a\u00020\u00102\b\b\u0002\u0010\u001e\u001a\u00020\u0010H\u0004J\u0016\u0010\u001f\u001a\u00028\u00002\u0006\u0010 \u001a\u00028\u0000H\u00a6@\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/kinference/trees/SingleModeTreeEnsemble;", "T", "Lio/kinference/ndarray/arrays/NumberNDArray;", "", "aggregator", "Lio/kinference/trees/Aggregator;", "treeSizes", "", "featureIds", "nodeFloatSplits", "", "nextNodeIds", "leafValues", "leafCounter", "biases", "numTargets", "", "splitMode", "Lio/kinference/trees/TreeSplitType;", "<init>", "(Lio/kinference/trees/Aggregator;[I[I[F[I[F[I[FILio/kinference/trees/TreeSplitType;)V", "getNumTargets", "()I", "treeSplitter", "Lio/kinference/trees/TreeSplitter;", "applyEntry", "", "array", "output", "srcIdx", "dstIdx", "execute", "input", "(Lio/kinference/ndarray/arrays/NumberNDArray;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "inference-ir-trees"})
public abstract class SingleModeTreeEnsemble<T extends NumberNDArray> {
    @NotNull
    private final Aggregator aggregator;
    @NotNull
    private final int[] treeSizes;
    @NotNull
    private final int[] nextNodeIds;
    @NotNull
    private final float[] leafValues;
    @NotNull
    private final int[] leafCounter;
    @NotNull
    private final float[] biases;
    private final int numTargets;
    @NotNull
    private final TreeSplitter treeSplitter;

    public SingleModeTreeEnsemble(@NotNull Aggregator aggregator, @NotNull int[] treeSizes, @NotNull int[] featureIds, @NotNull float[] nodeFloatSplits, @NotNull int[] nextNodeIds, @NotNull float[] leafValues, @NotNull int[] leafCounter, @NotNull float[] biases, int numTargets, @NotNull TreeSplitType splitMode) {
        Intrinsics.checkNotNullParameter((Object)aggregator, (String)"aggregator");
        Intrinsics.checkNotNullParameter((Object)treeSizes, (String)"treeSizes");
        Intrinsics.checkNotNullParameter((Object)featureIds, (String)"featureIds");
        Intrinsics.checkNotNullParameter((Object)nodeFloatSplits, (String)"nodeFloatSplits");
        Intrinsics.checkNotNullParameter((Object)nextNodeIds, (String)"nextNodeIds");
        Intrinsics.checkNotNullParameter((Object)leafValues, (String)"leafValues");
        Intrinsics.checkNotNullParameter((Object)leafCounter, (String)"leafCounter");
        Intrinsics.checkNotNullParameter((Object)biases, (String)"biases");
        Intrinsics.checkNotNullParameter((Object)((Object)splitMode), (String)"splitMode");
        this.aggregator = aggregator;
        this.treeSizes = treeSizes;
        this.nextNodeIds = nextNodeIds;
        this.leafValues = leafValues;
        this.leafCounter = leafCounter;
        this.biases = biases;
        this.numTargets = numTargets;
        this.treeSplitter = TreeSplitter.Companion.get(splitMode, featureIds, nodeFloatSplits);
    }

    public final int getNumTargets() {
        return this.numTargets;
    }

    protected final void applyEntry(@NotNull float[] array, @NotNull float[] output2, int srcIdx, int dstIdx) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        float[] score = new float[this.numTargets];
        int treeOffset = 0;
        for (int treeSize : this.treeSizes) {
            int index2 = 0;
            while (this.nextNodeIds[2 * (treeOffset + index2)] != 0) {
                int split2 = this.treeSplitter.split(array, srcIdx, treeOffset + index2);
                index2 = this.nextNodeIds[2 * (treeOffset + index2) + split2];
            }
            int leafValueIdx = this.leafCounter[treeOffset + index2] * this.numTargets;
            score = this.aggregator.accept(score, this.leafValues, leafValueIdx);
            treeOffset += treeSize;
        }
        this.aggregator.finalize(this.biases, output2, score, dstIdx, this.numTargets);
    }

    public static /* synthetic */ void applyEntry$default(SingleModeTreeEnsemble singleModeTreeEnsemble, float[] fArray, float[] fArray2, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: applyEntry");
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        singleModeTreeEnsemble.applyEntry(fArray, fArray2, n, n2);
    }

    @Nullable
    public abstract Object execute(@NotNull T var1, @NotNull Continuation<? super T> var2);
}

